/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractUndoPortChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkVersionableChangeAsUnresolvedAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UndoVersionableChangeAction
extends AbstractUndoPortChangeAction {
    public static boolean isValidSelection(ISelection selection) {
        IStructuredSelection ss;
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() > 0) {
            boolean allValidObjects = true;
            for (Object object : ss.toList()) {
                if (!(object instanceof VersionableChangeNode)) {
                    allValidObjects = false;
                    break;
                }
                VersionableChangeNode node = (VersionableChangeNode)object;
                if (node.isResolved()) continue;
                boolean containsResolvedChild = false;
                for (AbstractChangeDetailNode childNode : node.getChildChangeDetailNodes()) {
                    if (!childNode.isResolved()) continue;
                    containsResolvedChild = true;
                    break;
                }
                if (containsResolvedChild) continue;
                allValidObjects = false;
                break;
            }
            isValid = allValidObjects;
        }
        return isValid;
    }

    public static void undoVersionableChange(IStructuredSelection selection, final Shell shell, IOperationRunner runner) {
        int userSelection;
        AbstractUndoPortChangeAction.UndoPortChangeDialog dialog;
        ArrayList<VersionableChangeNode> allVersionableChangeNodes = new ArrayList<VersionableChangeNode>(selection.size());
        for (Object object : selection.toList()) {
            if (!(object instanceof VersionableChangeNode)) continue;
            VersionableChangeNode node = (VersionableChangeNode)object;
            allVersionableChangeNodes.add(node);
        }
        if (allVersionableChangeNodes.size() > 0 && (dialog = new AbstractUndoPortChangeAction.UndoPortChangeDialog(shell, MarkVersionableChangeAsUnresolvedAction.isValidSelection((ISelection)selection))).isValidResult(userSelection = dialog.open())) {
            final HashMap versionableChangeNodeMap = new HashMap();
            for (VersionableChangeNode versionableChangeNode : allVersionableChangeNodes) {
                ArrayList<VersionableChangeNode> versionableChangeNodes;
                HashMap<UUID, ArrayList<VersionableChangeNode>> componentToPortMap;
                ITeamRepository repo = versionableChangeNode.getRepository();
                UUID workspaceUUID = versionableChangeNode.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                UUID componentUUID = versionableChangeNode.getComponent().getItemId();
                HashMap workspaceToComponentMap = (HashMap)versionableChangeNodeMap.get(repo);
                if (workspaceToComponentMap == null) {
                    workspaceToComponentMap = new HashMap();
                }
                if ((componentToPortMap = (HashMap<UUID, ArrayList<VersionableChangeNode>>)workspaceToComponentMap.get(workspaceUUID)) == null) {
                    componentToPortMap = new HashMap<UUID, ArrayList<VersionableChangeNode>>();
                }
                if ((versionableChangeNodes = (ArrayList<VersionableChangeNode>)componentToPortMap.get(componentUUID)) == null) {
                    versionableChangeNodes = new ArrayList<VersionableChangeNode>();
                }
                versionableChangeNodes.add(versionableChangeNode);
                componentToPortMap.put(componentUUID, versionableChangeNodes);
                workspaceToComponentMap.put(workspaceUUID, componentToPortMap);
                versionableChangeNodeMap.put(repo, workspaceToComponentMap);
            }
            String jobName = userSelection == 0 ? UndoVersionableChangeAction.getUndoJobName() : UndoVersionableChangeAction.getMarkAsUnresolvedJobName();
            runner.enqueue(jobName, (Operation)new RepositoryOperation(versionableChangeNodeMap.keySet()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    for (Map.Entry repoToWorkspaceMapEntry : versionableChangeNodeMap.entrySet()) {
                        for (Map.Entry workspaceToComponentMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                            for (Map.Entry componentToVersionableChangesMap : ((Map)workspaceToComponentMap.getValue()).entrySet()) {
                                List versionableChangeNodes = (List)componentToVersionableChangesMap.getValue();
                                if (versionableChangeNodes.size() <= 0) continue;
                                IWorkspaceConnection workspaceConnection = ((VersionableChangeNode)versionableChangeNodes.get(0)).getWorkspaceConnection();
                                IComponent componentHandle = ((VersionableChangeNode)versionableChangeNodes.get(0)).getComponent();
                                UpdateCurrentPatchDilemmaHandler dilemmaHandler = UndoVersionableChangeAction.getUpdateCurrentPortDilemmaHandler(shell);
                                IUpdateCurrentPatchOperation op = OperationFactory.getInstance().getUpdateCurrentPortOperation(dilemmaHandler);
                                op.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
                                op.setContext(workspaceConnection, (IComponentHandle)componentHandle);
                                for (VersionableChangeNode node : versionableChangeNodes) {
                                    if (userSelection == 0) {
                                        op.undoChanges(node.getVersionable(), null, true);
                                        continue;
                                    }
                                    if (userSelection != 2) continue;
                                    op.markAsUnresolved(node.getVersionable(), null);
                                }
                                op.run(monitor);
                            }
                        }
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(UndoVersionableChangeAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        UndoVersionableChangeAction.undoVersionableChange(selection, shell, this.getOperationRunner());
    }
}

