/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractUndoPortChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkChangeDetailAsUnresolvedAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UndoChangeDetailAction
extends AbstractUndoPortChangeAction {
    public static boolean isValidSelection(ISelection selection) {
        IStructuredSelection ss;
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() > 0) {
            boolean allValidObjects = true;
            for (Object object : ss.toList()) {
                if (!(object instanceof AbstractChangeDetailNode)) {
                    allValidObjects = false;
                    break;
                }
                AbstractChangeDetailNode node = (AbstractChangeDetailNode)object;
                if (node.isResolved()) continue;
                allValidObjects = false;
                break;
            }
            isValid = allValidObjects;
        }
        return isValid;
    }

    public static void undoChangeDetail(IStructuredSelection selection, final Shell shell, IOperationRunner runner) {
        AbstractUndoPortChangeAction.UndoPortChangeDialog dialog;
        int userSelection;
        ArrayList<AbstractChangeDetailNode> allAbstractChangeDetailNodes = new ArrayList<AbstractChangeDetailNode>(selection.size());
        for (Object object : selection.toList()) {
            if (!(object instanceof AbstractChangeDetailNode)) continue;
            AbstractChangeDetailNode node = (AbstractChangeDetailNode)object;
            allAbstractChangeDetailNodes.add(node);
        }
        if (allAbstractChangeDetailNodes.size() > 0 && (userSelection = (dialog = new AbstractUndoPortChangeAction.UndoPortChangeDialog(shell, MarkChangeDetailAsUnresolvedAction.isValidSelection((ISelection)selection))).open()) != 1) {
            final HashMap changeDetailNodeMap = new HashMap();
            for (AbstractChangeDetailNode changeDetailNode : allAbstractChangeDetailNodes) {
                ArrayList<AbstractChangeDetailNode> changeDetailNodes;
                HashMap<UUID, ArrayList<AbstractChangeDetailNode>> componentToPortMap;
                ITeamRepository repo = changeDetailNode.getRepository();
                UUID workspaceUUID = changeDetailNode.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                UUID componentUUID = changeDetailNode.getComponent().getItemId();
                HashMap workspaceToComponentMap = (HashMap)changeDetailNodeMap.get(repo);
                if (workspaceToComponentMap == null) {
                    workspaceToComponentMap = new HashMap();
                }
                if ((componentToPortMap = (HashMap<UUID, ArrayList<AbstractChangeDetailNode>>)workspaceToComponentMap.get(workspaceUUID)) == null) {
                    componentToPortMap = new HashMap<UUID, ArrayList<AbstractChangeDetailNode>>();
                }
                if ((changeDetailNodes = (ArrayList<AbstractChangeDetailNode>)componentToPortMap.get(componentUUID)) == null) {
                    changeDetailNodes = new ArrayList<AbstractChangeDetailNode>();
                }
                changeDetailNodes.add(changeDetailNode);
                componentToPortMap.put(componentUUID, changeDetailNodes);
                workspaceToComponentMap.put(workspaceUUID, componentToPortMap);
                changeDetailNodeMap.put(repo, workspaceToComponentMap);
            }
            String jobName = userSelection == 0 ? UndoChangeDetailAction.getUndoJobName() : UndoChangeDetailAction.getMarkAsUnresolvedJobName();
            runner.enqueue(jobName, (Operation)new RepositoryOperation(changeDetailNodeMap.keySet()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    for (Map.Entry repoToWorkspaceMapEntry : changeDetailNodeMap.entrySet()) {
                        for (Map.Entry workspaceToComponentMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                            for (Map.Entry componentToVersionableChangesMap : ((Map)workspaceToComponentMap.getValue()).entrySet()) {
                                List changeDetailNodes = (List)componentToVersionableChangesMap.getValue();
                                if (changeDetailNodes.size() <= 0) continue;
                                IWorkspaceConnection workspaceConnection = ((AbstractChangeDetailNode)changeDetailNodes.get(0)).getWorkspaceConnection();
                                IComponent componentHandle = ((AbstractChangeDetailNode)changeDetailNodes.get(0)).getComponent();
                                UpdateCurrentPatchDilemmaHandler dilemmaHandler = UndoChangeDetailAction.getUpdateCurrentPortDilemmaHandler(shell);
                                IUpdateCurrentPatchOperation op = OperationFactory.getInstance().getUpdateCurrentPortOperation(dilemmaHandler);
                                op.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
                                op.setContext(workspaceConnection, (IComponentHandle)componentHandle);
                                for (AbstractChangeDetailNode node : changeDetailNodes) {
                                    VersionableChangeNode versionableChangeNode = node.getParentNode();
                                    if (versionableChangeNode == null) continue;
                                    IVersionableHandle versionable = versionableChangeNode.getVersionable();
                                    if (userSelection == 0) {
                                        op.undoChanges(versionable, Collections.singleton(node.getChangeDetail().getId()), true);
                                        continue;
                                    }
                                    if (userSelection != 2) continue;
                                    op.markAsUnresolved(versionable, Collections.singleton(node.getChangeDetail().getId()));
                                }
                                op.run(monitor);
                            }
                        }
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(UndoChangeDetailAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        UndoChangeDetailAction.undoChangeDetail(selection, shell, this.getOperationRunner());
    }
}

