/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.MoveChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryFilesPicker;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class SetVersionableChangeParentFolderAction
extends AbstractPortAction {
    public static boolean isValidSelection(ISelection selection) {
        IStructuredSelection ss;
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            VersionableChangeNode versionableNode;
            Object object = ss.getFirstElement();
            if (object instanceof VersionableChangeNode) {
                versionableNode = (VersionableChangeNode)object;
                isValid = versionableNode.canSetParent();
            }
            if (object instanceof MoveChangeDetailNode) {
                versionableNode = ((MoveChangeDetailNode)object).getParentNode();
                isValid = versionableNode != null && versionableNode.canSetParent();
            }
        }
        return isValid;
    }

    public static void reparentVersionableChange(final IStructuredSelection selection, final Shell shell, final IOperationRunner runner) {
        Display display = shell.getDisplay();
        if (!display.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Object object = selection.getFirstElement();
                    VersionableChangeNode versionableNode = null;
                    if (object instanceof VersionableChangeNode) {
                        versionableNode = (VersionableChangeNode)object;
                    } else if (object instanceof MoveChangeDetailNode) {
                        versionableNode = ((MoveChangeDetailNode)object).getParentNode();
                    }
                    if (versionableNode != null) {
                        IComponent component;
                        final IVersionableHandle versionable = versionableNode.getVersionable();
                        final IWorkspaceConnection workspaceConnection = versionableNode.getWorkspaceConnection();
                        final IFolderHandle folderHandle = RepositoryFilesPicker.pickFolder(shell, workspaceConnection, (IComponentHandle)(component = versionableNode.getComponent()), new IVersionableHandle[0], Messages.SetVersionableChangeParentFolderAction_FOLDER_PICKER_DIALOG_DESCRIPTION);
                        if (folderHandle != null) {
                            runner.enqueue(Messages.SetVersionableChangeParentFolderAction_JOB_NAME, (Operation)new RepositoryOperation(versionableNode.getRepository()){

                                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                    UpdateCurrentPatchDilemmaHandler dilemmaHandler = UpdateCurrentPatchDilemmaHandler.getDefault();
                                    IUpdateCurrentPatchOperation op = OperationFactory.getInstance().getUpdateCurrentPortOperation(dilemmaHandler);
                                    op.setContext(workspaceConnection, (IComponentHandle)component);
                                    op.reparentVersionable(versionable, folderHandle);
                                    op.run(monitor);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(SetVersionableChangeParentFolderAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        SetVersionableChangeParentFolderAction.reparentVersionableChange(selection, shell, this.getOperationRunner());
    }
}

