/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInCompareEditorAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.MoveChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnAutoResolveDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionableChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ResolveChangeDetailWithProposedAction
extends AbstractPortAction {
    public static boolean isValidSelection(ISelection selection) {
        IStructuredSelection ss;
        boolean isEnabled = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() > 0) {
            boolean allValidObjects = true;
            for (Object object : ss.toList()) {
                MoveChangeDetailNode moveChange;
                if (!(object instanceof AbstractChangeDetailNode)) {
                    allValidObjects = false;
                    break;
                }
                AbstractChangeDetailNode node = (AbstractChangeDetailNode)object;
                if (node.getChangeDetail().isResolved()) {
                    allValidObjects = false;
                    break;
                }
                if (object instanceof MoveChangeDetailNode && ((moveChange = (MoveChangeDetailNode)object).isMissingTargetParent() || moveChange.isDependentOnMoveTargetResolution())) {
                    allValidObjects = false;
                    break;
                }
                VersionableChangeNode parent = node.getParentNode();
                if (parent == null || !parent.isItemMissing()) continue;
                allValidObjects = false;
                break;
            }
            isEnabled = allValidObjects;
        }
        return isEnabled;
    }

    public static void resolveChangeDetailWithProposed(IStructuredSelection selection, IWorkbenchPage page, Shell shell, IOperationRunner runner) {
        ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed(selection, true, page, shell, runner);
    }

    public static void resolveChangeDetailWithProposed(IStructuredSelection selection, boolean showTextContentWarning, final IWorkbenchPage page, final Shell shell, IOperationRunner runner) {
        if (ResolveChangeDetailWithProposedAction.isValidSelection((ISelection)selection)) {
            final HashSet<AbstractChangeDetailNode> allAbstractChangeDetailNodes = new HashSet<AbstractChangeDetailNode>(selection.size());
            final HashSet<ContentChangeDetailNode> contentChangeDetailNodes = new HashSet<ContentChangeDetailNode>();
            for (Object object : selection.toList()) {
                if (object instanceof AbstractChangeDetailNode) {
                    allAbstractChangeDetailNodes.add((AbstractChangeDetailNode)object);
                }
                if (!(object instanceof ContentChangeDetailNode)) continue;
                contentChangeDetailNodes.add((ContentChangeDetailNode)object);
            }
            if (allAbstractChangeDetailNodes.size() > 0) {
                final HashMap changeDetailNodeMap = new HashMap();
                for (AbstractChangeDetailNode changeDetailNode : allAbstractChangeDetailNodes) {
                    ArrayList<AbstractChangeDetailNode> changeDetailNodes;
                    HashMap<UUID, ArrayList<AbstractChangeDetailNode>> componentToPortMap;
                    ITeamRepository repo = changeDetailNode.getRepository();
                    UUID workspaceUUID = changeDetailNode.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                    UUID componentUUID = changeDetailNode.getComponent().getItemId();
                    HashMap workspaceToComponentMap = (HashMap)changeDetailNodeMap.get(repo);
                    if (workspaceToComponentMap == null) {
                        workspaceToComponentMap = new HashMap();
                    }
                    if ((componentToPortMap = (HashMap<UUID, ArrayList<AbstractChangeDetailNode>>)workspaceToComponentMap.get(workspaceUUID)) == null) {
                        componentToPortMap = new HashMap<UUID, ArrayList<AbstractChangeDetailNode>>();
                    }
                    if ((changeDetailNodes = (ArrayList<AbstractChangeDetailNode>)componentToPortMap.get(componentUUID)) == null) {
                        changeDetailNodes = new ArrayList<AbstractChangeDetailNode>();
                    }
                    changeDetailNodes.add(changeDetailNode);
                    componentToPortMap.put(componentUUID, changeDetailNodes);
                    workspaceToComponentMap.put(workspaceUUID, componentToPortMap);
                    changeDetailNodeMap.put(repo, workspaceToComponentMap);
                }
                if (showTextContentWarning && contentChangeDetailNodes.size() > 0) {
                    String title = Messages.ResolveChangeDetailWithProposedAction_CONFIRM_CONTENT_OVERWRITE_DIALOG_TITLE;
                    String message = contentChangeDetailNodes.size() == 1 ? Messages.ResolveChangeDetailWithProposedAction_CONFIRM_CONTENT_OVERWRITE_DIALOG_MESSAGE_SINGLE : Messages.ResolveChangeDetailWithProposedAction_CONFIRM_CONTENT_OVERWRITE_DIALOG_MESSAGE;
                    DialogUtil.pauseIfNeededBeforeShowingDialog();
                    int button = JFaceUtils.showMessageButtonsBlocking((String)title, (String)message, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (int)3, (int)1);
                    if (button != 0) {
                        return;
                    }
                }
                String jobName = Messages.ResolveChangeDetailWithProposedAction_JOB_NAME;
                runner.enqueue(jobName, (Operation)new RepositoryOperation(changeDetailNodeMap.keySet()){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        int size = allAbstractChangeDetailNodes.size();
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10 + contentChangeDetailNodes.size()));
                        for (ContentChangeDetailNode contentChangeDetailNode : contentChangeDetailNodes) {
                            OpenVersionableChangeInCompareEditorAction.saveOpenCompareEditors(contentChangeDetailNode.getParentNode(), page, shell, (IProgressMonitor)progress.newChild(1));
                        }
                        ArrayList<VersionableChangeNode> compareEditorsToClose = new ArrayList<VersionableChangeNode>();
                        for (Map.Entry repoToWorkspaceMapEntry : changeDetailNodeMap.entrySet()) {
                            for (Map.Entry workspaceToComponentMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                                for (Map.Entry componentToVersionableChangesMap : ((Map)workspaceToComponentMap.getValue()).entrySet()) {
                                    List changeDetailNodes = (List)componentToVersionableChangesMap.getValue();
                                    if (changeDetailNodes.size() <= 0) continue;
                                    IWorkspaceConnection workspaceConnection = ((AbstractChangeDetailNode)changeDetailNodes.get(0)).getWorkspaceConnection();
                                    IComponent componentHandle = ((AbstractChangeDetailNode)changeDetailNodes.get(0)).getComponent();
                                    UpdateCurrentPatchDilemmaHandler dilemmaHandler = ResolveChangeDetailWithProposedAction.getUpdateCurrentPortDilemmaHandler(shell);
                                    IUpdateCurrentPatchOperation op = OperationFactory.getInstance().getUpdateCurrentPortOperation(dilemmaHandler);
                                    op.setContext(workspaceConnection, (IComponentHandle)componentHandle);
                                    for (AbstractChangeDetailNode node : changeDetailNodes) {
                                        VersionableChangeNode versionableChangeNode = node.getParentNode();
                                        if (versionableChangeNode == null) continue;
                                        op.resolveWithProposed(versionableChangeNode.getVersionable(), Collections.singleton(node.getChangeDetail().getId()), true);
                                    }
                                    op.run((IProgressMonitor)progress.newChild(10));
                                    ICurrentPatch currentPort = workspaceConnection.getCurrentPatch((IComponentHandle)componentHandle);
                                    if (currentPort == null) continue;
                                    for (AbstractChangeDetailNode node : changeDetailNodes) {
                                        IChangeDetail changeDetail;
                                        IVersionableChange versionableChange;
                                        VersionableChangeNode versionableChangeNode;
                                        if (!(node instanceof ContentChangeDetailNode) || (versionableChangeNode = node.getParentNode()) == null || (versionableChange = currentPort.getVersionableChange(versionableChangeNode.getVersionableChange().getId())) == null || (changeDetail = versionableChange.getChangeDetail(node.getChangeDetailID())) == null || !changeDetail.isResolved()) continue;
                                        compareEditorsToClose.add(versionableChangeNode);
                                    }
                                }
                            }
                        }
                        OpenVersionableChangeInCompareEditorAction.closeNonDirtyCompareEditors(compareEditorsToClose, page, shell);
                        progress.done();
                    }
                });
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(ResolveChangeDetailWithProposedAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed(selection, page, shell, this.getOperationRunner());
    }

    protected static UpdateCurrentPatchDilemmaHandler getUpdateCurrentPortDilemmaHandler(Shell shell) {
        return new WarnAutoResolveDilemmaHandler(shell);
    }
}

