/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class RemovePendingPortAction
extends AbstractPortAction {
    public static boolean isValidSelection(ISelection selection) {
        boolean isValid = false;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            boolean allValidObjects = true;
            for (Object object : ss.toList()) {
                if (object instanceof PendingPortNode) continue;
                allValidObjects = false;
                break;
            }
            isValid = allValidObjects;
        }
        return isValid;
    }

    public static void removePendingPorts(ISelection selection, final IWorkbenchPart workbenchPart, IOperationRunner runner) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<PendingPortNode> allPendingPorts = new ArrayList<PendingPortNode>(ss.toList().size());
            for (Object object : ss.toList()) {
                if (!(object instanceof PendingPortNode)) continue;
                allPendingPorts.add((PendingPortNode)object);
            }
            if (allPendingPorts.size() > 0) {
                String confirmationMessage;
                String string = confirmationMessage = allPendingPorts.size() == 1 ? Messages.RemovePendingPortAction_REMOVE_CONFIRMATION_SINGLE_MESSAGE : Messages.RemovePendingPortAction_REMOVE_CONFIRMATION_MESSAGE;
                if (!MessageDialog.openQuestion((Shell)workbenchPart.getSite().getShell(), (String)Messages.RemovePendingPortAction_REMOVE_CONFIRMATION_TITLE, (String)confirmationMessage)) {
                    return;
                }
                final HashMap pendingPortNodeMap = new HashMap();
                for (PendingPortNode pendingPortNode : allPendingPorts) {
                    ArrayList<PendingPortNode> pendingPorts;
                    HashMap<UUID, ArrayList<PendingPortNode>> componentToPortMap;
                    ITeamRepository repo = pendingPortNode.getRepository();
                    UUID workspaceUUID = pendingPortNode.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                    UUID componentUUID = pendingPortNode.getComponent().getItemId();
                    HashMap workspaceToComponentMap = (HashMap)pendingPortNodeMap.get(repo);
                    if (workspaceToComponentMap == null) {
                        workspaceToComponentMap = new HashMap();
                    }
                    if ((componentToPortMap = (HashMap<UUID, ArrayList<PendingPortNode>>)workspaceToComponentMap.get(workspaceUUID)) == null) {
                        componentToPortMap = new HashMap<UUID, ArrayList<PendingPortNode>>();
                    }
                    if ((pendingPorts = (ArrayList<PendingPortNode>)componentToPortMap.get(componentUUID)) == null) {
                        pendingPorts = new ArrayList<PendingPortNode>();
                    }
                    pendingPorts.add(pendingPortNode);
                    componentToPortMap.put(componentUUID, pendingPorts);
                    workspaceToComponentMap.put(workspaceUUID, componentToPortMap);
                    pendingPortNodeMap.put(repo, workspaceToComponentMap);
                }
                String jobName = Messages.RemovePendingPortAction_JOB_NAME;
                runner.enqueue(jobName, (Operation)new RepositoryOperation(pendingPortNodeMap.keySet()){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        for (Map.Entry repoToWorkspaceMapEntry : pendingPortNodeMap.entrySet()) {
                            for (Map.Entry workspaceToComponentMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                                for (Map.Entry componentToPendingPortsMap : ((Map)workspaceToComponentMap.getValue()).entrySet()) {
                                    List pendingPortNodes = (List)componentToPendingPortsMap.getValue();
                                    if (pendingPortNodes.size() <= 0) continue;
                                    UUID[] pendingPortIds = new UUID[pendingPortNodes.size()];
                                    int i = 0;
                                    while (i < pendingPortNodes.size()) {
                                        pendingPortIds[i] = ((PendingPortNode)pendingPortNodes.get(i)).getPortSource().getSourceId();
                                        ++i;
                                    }
                                    final IWorkspaceConnection workspace = ((PendingPortNode)pendingPortNodes.get(0)).getWorkspaceConnection();
                                    final IComponent component = ((PendingPortNode)pendingPortNodes.get(0)).getComponent();
                                    workspace.removeAcceptQueueEntries((IComponentHandle)component, pendingPortIds, monitor);
                                    final Display display = workbenchPart.getSite().getShell().getDisplay();
                                    if (display == null) continue;
                                    display.asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!display.isDisposed()) {
                                                RemovePendingPortAction.closePortEditorIfNoPortsExist(workbenchPart, workspace, component);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(RemovePendingPortAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        RemovePendingPortAction.removePendingPorts((ISelection)selection, this.getPart(), this.getOperationRunner());
    }
}

