/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RemoveChangeSetLinksAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean isEnabled = true;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object element : ss.toList()) {
                if (element != null && Adapters.hasAdapter(element, ChangeSetWrapper.class)) continue;
                isEnabled = false;
                break;
            }
        }
        action.setEnabled(isEnabled);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        HashMap<ITeamRepository, ArrayList<IChangeSet>> repoToChangeSetMap = new HashMap<ITeamRepository, ArrayList<IChangeSet>>();
        for (Object e : selection.toList()) {
            if (e == null || !Adapters.hasAdapter(e, IChangeSetHandle.class)) continue;
            ChangeSetWrapper wrapper = (ChangeSetWrapper)((Object)Adapters.getAdapter(e, ChangeSetWrapper.class));
            ITeamRepository repo = wrapper.getRepository();
            IChangeSet cs = wrapper.getChangeSet();
            ArrayList<IChangeSet> csList = (ArrayList<IChangeSet>)repoToChangeSetMap.get(repo);
            if (csList == null) {
                csList = new ArrayList<IChangeSet>();
                repoToChangeSetMap.put(repo, csList);
            }
            csList.add(cs);
        }
        if (repoToChangeSetMap.size() == 0) {
            MessageDialog.openError((Shell)shell, (String)Messages.RemoveChangeSetLinksAction_INVALID_SELECTION_DIALOG_TITLE, (String)Messages.RemoveChangeSetLinksAction_INVALID_SELECTION_DIALOG_MESSAGE_EMPTY);
            return;
        }
        if (repoToChangeSetMap.size() > 1) {
            MessageDialog.openError((Shell)shell, (String)Messages.RemoveChangeSetLinksAction_INVALID_SELECTION_DIALOG_TITLE, (String)Messages.RemoveChangeSetLinksAction_INVALID_SELECTION_DIALOG_MESSAGE_MULTI_REPO);
            return;
        }
        if (!MessageDialog.openQuestion((Shell)shell, (String)Messages.RemoveChangeSetLinksAction_CONFIRM_DIALOG_TITLE, (String)Messages.RemoveChangeSetLinksAction_CONFIRM_DIALOG_MESSAGE)) {
            return;
        }
        for (final Map.Entry entry : repoToChangeSetMap.entrySet()) {
            this.getOperationRunner().enqueue(Messages.RemoveChangeSetLinksAction_JOB_NAME, (Operation)new RepositoryOperation((ITeamRepository)entry.getKey()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)entry.getKey()));
                    manager.removeChangeSetLinks((List)entry.getValue(), monitor);
                }
            });
        }
    }
}

