/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IProcessAcceptQueueOperation;
import com.ibm.team.filesystem.client.operations.ProcessAcceptQueueDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenPortEditorAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortsContainerNode;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnProcessAcceptQueueDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.service.prefs.Preferences;

public class ProcessPendingPortsAction
extends AbstractPortAction {
    public static boolean openProcessPendingPortsQuestion(Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)Messages.ProcessPendingPortsAction_PROCESS_PENDING_PORTS_DIALOG_TITLE, (String)Messages.ProcessPendingPortsAction_PROCESS_PENDING_PORTS_DIALOG_DESCRIPTION);
    }

    public static boolean isValidSelection(ISelection selection) {
        PendingPortsContainerNode containerNode;
        Object object;
        IStructuredSelection ss;
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof PendingPortsContainerNode && (containerNode = (PendingPortsContainerNode)object).getChildPendingPorts().size() > 0 && !PortsCacheManager.getInstance().hasCurrentPort(containerNode.getRepository(), (IWorkspaceHandle)containerNode.getWorkspaceConnection().getResolvedWorkspace(), (IComponentHandle)containerNode.getComponent())) {
            isValid = true;
        }
        return isValid;
    }

    public static void processPendingPorts(final IWorkbenchPart workbenchPart, IOperationRunner runner, final IWorkspaceConnection workspace, final IComponent component, boolean allowUserToChooseFlags) {
        final Shell shell = workbenchPart.getSite().getShell();
        try {
            if (workspace.getAcceptQueueSize((IComponentHandle)component) <= 0L) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.ProcessPendingPortsAction_NO_PENDING_PORTS_DIALOG_TITLE, (String)Messages.ProcessPendingPortsAction_NO_PENDING_PORTS_DIALOG_MESSAGE);
            } else if (workspace.getCurrentPatch((IComponentHandle)component) != null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.ProcessPendingPortsAction_CURRENT_PORT_DIALOG_TITLE, (String)Messages.ProcessPendingPortsAction_CURRENT_PORT_DIALOG_MESSAGE);
            } else {
                int flags;
                if (allowUserToChooseFlags) {
                    ProcessPendingPortsDialog dialog = new ProcessPendingPortsDialog(shell);
                    dialog.create();
                    if (dialog.open() == 0) {
                        return;
                    }
                    flags = dialog.getFlags();
                } else {
                    flags = ProcessPendingPortsAction.getDefaultFlags();
                }
                String jobName = Messages.ProcessPendingPortsAction_JOB_NAME;
                final ProcessAcceptQueueDilemmaHandler dilemmaHandler = ProcessPendingPortsAction.getProcessPendingPortsDilemmaHandler(shell);
                runner.enqueue(jobName, (Operation)new RepositoryOperation(workspace.teamRepository()){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        IProcessAcceptQueueOperation op = OperationFactory.getInstance().getProcessAcceptQueueOperation(dilemmaHandler);
                        op.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
                        op.setFlags(flags);
                        op.processAcceptQueue(workspace, (IComponentHandle)component);
                        op.run(monitor);
                        final Display display = shell.getDisplay();
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!display.isDisposed()) {
                                        try {
                                            if (workspace.getCurrentPatch((IComponentHandle)component) == null && workspace.getAcceptQueueSize((IComponentHandle)component) <= 0L) {
                                                ProcessPendingPortsAction.closePortEditorIfNoPortsExist(workbenchPart, workspace, component);
                                            } else {
                                                OpenPortEditorAction.openPortEditor(workbenchPart.getSite().getPage(), workspace, component, "com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage");
                                            }
                                        }
                                        catch (ComponentNotInWorkspaceException e) {
                                            StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
        catch (ComponentNotInWorkspaceException e) {
            StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
        }
    }

    public static int getDefaultFlags() {
        return 1;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(ProcessPendingPortsAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object object;
        if (selection.size() == 1 && (object = selection.getFirstElement()) instanceof PendingPortsContainerNode) {
            PendingPortsContainerNode node = (PendingPortsContainerNode)object;
            ProcessPendingPortsAction.processPendingPorts(this.getPart(), this.getOperationRunner(), node.getWorkspaceConnection(), node.getComponent(), false);
        }
    }

    private static ProcessAcceptQueueDilemmaHandler getProcessPendingPortsDilemmaHandler(Shell shell) {
        return new WarnProcessAcceptQueueDilemmaHandler(shell);
    }

    private static class ProcessPendingPortsDialog
    extends TitleAreaDialog {
        private final String PREF_KEY_PROCESS_PENDING_PORTS_POLICY = "process_pending_ports_policy";
        private Button fDoNotAutoResolve;
        private Button fAutoResolveOnly;
        private Button fProcessAllPendingPorts;
        private int fFlags = 0;
        private Preferences fPrefs = this.getInstanceScope();

        public ProcessPendingPortsDialog(Shell parentShell) {
            super(parentShell);
        }

        private Preferences getInstanceScope() {
            return new InstanceScope().getNode("com.ibm.team.filesystem.ide.ui").node(((Object)((Object)this)).getClass().getName());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.ProcessPendingPortsAction_DIALOG_SHELL_TITLE);
        }

        public void create() {
            super.create();
            this.setTitle(Messages.ProcessPendingPortsAction_DIALOG_TITLE);
            this.setMessage(Messages.ProcessPendingPortsAction_DIALOG_MESSAGE, 0);
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(dialogArea, 0);
            GridLayoutFactory.fillDefaults().spacing(3, 3).margins(LayoutConstants.getMargins()).generateLayout(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            ProcessPendingPortsDialog.applyDialogFont((Control)parent);
            WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
            Group group = new Group(composite, 0);
            group.setText(Messages.ProcessPendingPortsAction_BUTTON_GROUP_TITLE);
            GridLayoutFactory.fillDefaults().margins(5, 5).generateLayout((Composite)group);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)group);
            this.fDoNotAutoResolve = toolkit.createButton((Composite)group, Messages.ProcessPendingPortsAction_DO_NOT_AUTO_RESOLVE_BUTTON_TEXT, 16);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDoNotAutoResolve);
            this.fAutoResolveOnly = toolkit.createButton((Composite)group, Messages.ProcessPendingPortsAction_AUTO_RESOLVE_ONLY_BUTTON_TEXT, 16);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDoNotAutoResolve);
            this.fProcessAllPendingPorts = toolkit.createButton((Composite)group, Messages.ProcessPendingPortsAction_PROCESS_ALL_PENDING_PORTS_BUTTON_TEXT, 16);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDoNotAutoResolve);
            int previousSelection = this.fPrefs.getInt("process_pending_ports_policy", 0);
            if (previousSelection == 0) {
                this.fDoNotAutoResolve.setSelection(true);
            } else if (previousSelection == 1) {
                this.fAutoResolveOnly.setSelection(true);
            } else if (previousSelection == 2) {
                this.fProcessAllPendingPorts.setSelection(true);
            } else {
                this.fDoNotAutoResolve.setSelection(true);
            }
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setFocus();
            }
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            this.saveInput();
            super.okPressed();
        }

        private void saveInput() {
            if (this.fDoNotAutoResolve.getSelection()) {
                this.fFlags = 0;
                this.fPrefs.putInt("process_pending_ports_policy", 0);
            } else if (this.fAutoResolveOnly.getSelection()) {
                this.fFlags = 1;
                this.fPrefs.putInt("process_pending_ports_policy", 1);
            } else if (this.fProcessAllPendingPorts.getSelection()) {
                this.fFlags = 2;
                this.fPrefs.putInt("process_pending_ports_policy", 2);
            } else {
                this.fFlags = 0;
                this.fPrefs.putInt("process_pending_ports_policy", 0);
            }
        }

        public int getFlags() {
            return this.fFlags;
        }
    }
}

