/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractOpenVersionableChangeInCompareAction;
import com.ibm.team.filesystem.ide.ui.internal.compare.DelegatingSaveableCompareEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class OpenVersionableChangeInCompareEditorAction
extends AbstractOpenVersionableChangeInCompareAction {
    public static void saveOpenCompareEditors(Map<ITeamRepository, Map<UUID, Map<UUID, List<VersionableChangeNode>>>> versionableChangeNodeMap, IWorkbenchPage page, Shell shell, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)OpenVersionableChangeInCompareEditorAction.getNumVersionables(versionableChangeNodeMap));
        for (Map.Entry<ITeamRepository, Map<UUID, Map<UUID, List<VersionableChangeNode>>>> repoToWorkspaceMapEntry : versionableChangeNodeMap.entrySet()) {
            for (Map.Entry<UUID, Map<UUID, List<VersionableChangeNode>>> workspaceToComponentMap : repoToWorkspaceMapEntry.getValue().entrySet()) {
                for (Map.Entry<UUID, List<VersionableChangeNode>> componentToVersionableChangesMap : workspaceToComponentMap.getValue().entrySet()) {
                    List<VersionableChangeNode> versionableChangeNodes = componentToVersionableChangesMap.getValue();
                    for (VersionableChangeNode node : versionableChangeNodes) {
                        OpenVersionableChangeInCompareEditorAction.saveOpenCompareEditors(node, page, shell, (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
        }
    }

    public static void saveOpenCompareEditors(final VersionableChangeNode node, IWorkbenchPage page, final Shell shell, IProgressMonitor monitor) {
        Display display;
        IVersionableChange versionableChange;
        IComponent component;
        IWorkspaceConnection workspace;
        CompareEditorInput input;
        IEditorPart editor;
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (node != null && (editor = page.findEditor((IEditorInput)(input = DelegatingSaveableCompareEditorInput.createInput(page, workspace = node.getWorkspaceConnection(), (IComponentHandle)(component = node.getComponent()), versionableChange = node.getVersionableChange(), OpenVersionableChangeInCompareEditorAction.shouldOpenIn3WayCompare(node), false)))) != null && editor.isDirty() && (display = shell.getDisplay()) != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    String message;
                    String title;
                    if (editor.isDirty() && MessageDialog.openQuestion((Shell)shell, (String)(title = Messages.OpenVersionableChangeInCompareEditorAction_SAVE_RESOURCE_DIALOG_TITLE), (String)(message = NLS.bind((String)Messages.OpenVersionableChangeInCompareEditorAction_SAVE_RESOURCE_DIALOG_MESSAGE, (Object)node.getName())))) {
                        editor.doSave((IProgressMonitor)progress.newChild(1));
                    }
                }
            });
        }
        progress.setWorkRemaining(0);
    }

    public static void closeNonDirtyCompareEditors(List<VersionableChangeNode> versionableChangeNode, final IWorkbenchPage page, Shell shell) {
        for (VersionableChangeNode node : versionableChangeNode) {
            if (node == null) continue;
            IWorkspaceConnection workspace = node.getWorkspaceConnection();
            IComponent component = node.getComponent();
            IVersionableChange versionableChange = node.getVersionableChange();
            final CompareEditorInput input = DelegatingSaveableCompareEditorInput.createInput(page, workspace, (IComponentHandle)component, versionableChange, OpenVersionableChangeInCompareEditorAction.shouldOpenIn3WayCompare(node), false);
            Display display = shell.getDisplay();
            if (display == null) continue;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IEditorPart editor = page.findEditor((IEditorInput)input);
                    if (editor != null && !editor.isDirty()) {
                        page.closeEditor(editor, true);
                    }
                }
            });
        }
    }

    @Override
    protected String getJobName() {
        return Messages.OpenVersionableChangeInCompareEditorAction_JOB_NAME;
    }

    @Override
    protected String getUnloadedComponentMessage(VersionableChangeNode versionableChangeNode) {
        return NLS.bind((String)Messages.OpenVersionableChangeInCompareEditorAction_UNLOADED_COMPONENT_DIALOG_MESSAGE, (Object)versionableChangeNode.getVersionableType(false), (Object)versionableChangeNode.getName());
    }

    @Override
    protected String getMissingFileMessage(VersionableChangeNode versionableChangeNode) {
        return NLS.bind((String)Messages.OpenVersionableChangeInCompareEditorAction_MISSING_LOCAL_FILE_MESSAGE, (Object)versionableChangeNode.getVersionableType(false), (Object)versionableChangeNode.getName());
    }

    @Override
    protected void prepareToOpenInCompare(final VersionableChangeNode versionableChangeNode, final ContentChangeDetailNode changeDetailNode, final IWorkbenchPage page, final Shell shell) {
        final IOperationRunner runner = this.getContext().getUserOperationRunner();
        runner.enqueue(this.getJobName(), (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
                    IComponent component = versionableChangeNode.getComponent();
                    IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)versionableChangeNode.getVersionable(), (IProgressMonitor)progress.newChild(50));
                    if (shareable != null && shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(25))) {
                        OpenVersionableChangeInCompareEditorAction.this.showIgnoredVersionableDialog(versionableChangeNode);
                    }
                    if (versionableChangeNode.getVersionableChange().getConfigurationState() == null) {
                        OpenVersionableChangeInCompareEditorAction.this.handleMissingLocalFile(versionableChangeNode, changeDetailNode, page, shell, runner, (IProgressMonitor)progress.newChild(25));
                        return;
                    }
                    OpenVersionableChangeInCompareEditorAction.this.openInCompare(OpenVersionableChangeInCompareEditorAction.this.getContext(), versionableChangeNode, OpenVersionableChangeInCompareEditorAction.shouldOpenIn3WayCompare(versionableChangeNode), (IProgressMonitor)progress.newChild(25));
                }
                finally {
                    progress.done();
                }
            }
        });
    }

    @Override
    protected void openInCompare(final UIContext context, VersionableChangeNode versionableChangeNode, final boolean useThreeWayCompare, IProgressMonitor monitor) {
        final IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
        IComponent component = versionableChangeNode.getComponent();
        IVersionableChange versionableChange = versionableChangeNode.getVersionableChange();
        JFaceUtils.syncExec((Runnable)new Runnable((IComponentHandle)component, versionableChange){
            private final /* synthetic */ IComponentHandle val$component;
            private final /* synthetic */ IVersionableChange val$versionableChange;
            {
                this.val$component = iComponentHandle;
                this.val$versionableChange = iVersionableChange;
            }

            @Override
            public void run() {
                if (useThreeWayCompare) {
                    OpenVersionableChangeInCompareEditorAction.this.showHidingOutgoingChangesDialog(context);
                }
                CompareEditorInput input = DelegatingSaveableCompareEditorInput.createInput(context.getPage(), workspace, this.val$component, this.val$versionableChange, useThreeWayCompare, false);
                OpenInCompareAction.openCompareEditor(input, context.getPage());
            }
        });
    }

    private void showHidingOutgoingChangesDialog(UIContext context) {
        MessageDialogWithToggle dialog;
        IPreferenceStore store;
        boolean showDialog;
        IWorkbenchPage page;
        Shell shell = context.getShell();
        if (shell == null && (page = JFaceUtils.getWorkbenchPage()) != null) {
            shell = page.getWorkbenchWindow().getShell();
        }
        if (shell != null && (showDialog = (store = UiPlugin.getDefault().getPreferenceStore()).getBoolean("com.ibm.team.filesystem.ide.ui.show_hiding_outgoing_changes_dialog")) && (dialog = MessageDialogWithToggle.openInformation((Shell)shell, (String)Messages.OpenVersionableChangeInCompareEditorAction_HIDING_OUTGOING_CHANGES_DIALOG_TITLE, (String)Messages.OpenVersionableChangeInCompareEditorAction_HIDING_OUTGOING_CHANGES_DIALOG_MESSAGE, (String)Messages.OpenVersionableChangeInCompareEditorAction_HIDING_OUTGOING_CHANGES_DIALOG_DONT_SHOW_AGAIN, (boolean)false, null, null)).getReturnCode() == 0) {
            store.setValue("com.ibm.team.filesystem.ide.ui.show_hiding_outgoing_changes_dialog", !dialog.getToggleState());
        }
    }
}

