/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MergeVersionableChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ResolveChangeDetailWithProposedAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PropertyChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.ui.internal.compare.PropertyChangeDetailCompareEditorInput;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnMarkAsResolvedDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IPropertyChangeDetail;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenPropertyChangeInCompareEditorAction
extends AbstractPortAction {
    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        boolean isEnabled = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof PropertyChangeDetailNode) {
            isEnabled = true;
        }
        action.setEnabled(isEnabled);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object != null && object instanceof PropertyChangeDetailNode) {
            PropertyChangeDetailNode propertyChangeNode = (PropertyChangeDetailNode)object;
            OpenPropertyChangeInCompareEditorAction.openPropertyCompareDialog(propertyChangeNode, true, page, this.getContext().getShell(), this.getOperationRunner());
        }
    }

    public static void openPropertyCompareDialog(final PropertyChangeDetailNode propertyChangeNode, final boolean showDeletePrompt, final IWorkbenchPage page, final Shell shell, final IOperationRunner runner) {
        final VersionableChangeNode versionableChangeNode = propertyChangeNode.getParentNode();
        if (versionableChangeNode != null) {
            UUID originalCurrentPortId;
            IComponent component;
            final IWorkspaceConnection workspace = propertyChangeNode.getWorkspaceConnection();
            ICurrentPatch currentPort = workspace.getCurrentPatch((IComponentHandle)(component = propertyChangeNode.getComponent()));
            UUID uUID = originalCurrentPortId = currentPort == null ? null : currentPort.getSourceId();
            if (originalCurrentPortId != null) {
                runner.enqueue(Messages.OpenPropertyChangeInCompareEditorAction_JOB_NAME, (Operation)new RepositoryOperation(workspace.teamRepository()){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)versionableChangeNode.getVersionable(), (IProgressMonitor)progress.newChild(25));
                        if (shareable == null) {
                            progress.setWorkRemaining(80);
                            MergeVersionableChangeAction.mergeMissingResource(versionableChangeNode, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                            return;
                        }
                        if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(25))) {
                            OpenPropertyChangeInCompareEditorAction.showIgnoredVersionableDialog(versionableChangeNode);
                        }
                        progress.setWorkRemaining(50);
                        WarnMarkAsResolvedDilemmaHandler customHandler = new WarnMarkAsResolvedDilemmaHandler(shell){

                            @Override
                            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
                                DialogUtil.pauseIfNeededBeforeShowingDialog();
                                String title = Messages.OpenPropertyChangeInCompareEditorAction_UN_CHECKED_IN_CHANGES_DIALOG_TITLE;
                                String message = NLS.bind((String)Messages.OpenPropertyChangeInCompareEditorAction_UN_CHECKED_IN_CHANGES_DIALOG_DESCRIPTION, (Object)versionableChangeNode.getVersionableType(false), (Object)versionableChangeNode.getName());
                                String checkInButton = Messages.OpenPropertyChangeInCompareEditorAction_UN_CHECKED_IN_CHANGES_DIALOG_CHECK_IN_BUTTON;
                                String cancelButton = Messages.OpenPropertyChangeInCompareEditorAction_UN_CHECKED_IN_CHANGES_DIALOG_CANCEL_BUTTON;
                                String helpID = "com.ibm.team.filesystem.ide.ui.dialog_localchangesupdatecurrentport";
                                int code = JFaceUtils.showMessageButtonsBlocking((String)title, (String)NLS.bind((String)message, (Object)versionableChangeNode.getName()), (String[])new String[]{checkInButton, cancelButton}, (int)4, (int)0, (String)helpID);
                                switch (code) {
                                    case 0: {
                                        return 0;
                                    }
                                }
                                return 1;
                            }
                        };
                        final PropertyChangeDetailCompareEditorInput input = PropertyChangeDetailCompareEditorInput.create((IWorkspaceConnection)workspace, (IComponentHandle)component, (IVersionableChange)versionableChangeNode.getVersionableChange(), (IPropertyChangeDetail)propertyChangeNode.getPropertyChangeDetail(), (IShareable)shareable, (UpdateCurrentPatchDilemmaHandler)customHandler, (IProgressMonitor)progress.newChild(50));
                        SWTUtil.greedyExec((Display)shell.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (showDeletePrompt && propertyChangeNode.isDeleted()) {
                                    String title = Messages.OpenPropertyChangeInCompareEditorAction_PROPERTY_DELETION_DIALOG_TITLE;
                                    String message = Messages.OpenPropertyChangeInCompareEditorAction_PROPERTY_DELETION_DIALOG_DESCRIPTION;
                                    String openInCompareButton = Messages.OpenPropertyChangeInCompareEditorAction_PROPERTY_DELETION_DIALOG_OPEN_COMPARE_BUTTON;
                                    String removePropertyButton = Messages.OpenPropertyChangeInCompareEditorAction_PROPERTY_DELETION_DIALOG_REMOVE_PROPERTY_BUTTON;
                                    int result = JFaceUtils.showMessageButtonsBlocking((String)title, (String)NLS.bind((String)message, (Object)propertyChangeNode.getPropertyName(propertyChangeNode.getDefaultMaxPropertyNameLength())), (String[])new String[]{openInCompareButton, removePropertyButton}, (int)3, (int)1);
                                    if (result == -1) {
                                        return;
                                    }
                                    if (result == 1) {
                                        ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)propertyChangeNode), page, shell, runner);
                                        return;
                                    }
                                }
                                CompareUI.openCompareDialog((CompareEditorInput)input);
                                if (input.hasChange()) {
                                    runner.enqueue(Messages.OpenPropertyChangeInCompareEditorAction_SAVE_PROPERTY_CHANGE_JOB_NAME, (Operation)new RepositoryOperation(workspace.teamRepository()){

                                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                                            input.applyPropertyChange(monitor);
                                        }
                                    });
                                }
                            }
                        });
                        progress.done();
                    }
                });
            }
        }
    }

    private static void showIgnoredVersionableDialog(VersionableChangeNode versionableChangeNode) {
        String title = NLS.bind((String)Messages.OpenPropertyChangeInCompareEditorAction_IGNORED_VERSIONABLE_DIALOG_TITLE, (Object)versionableChangeNode.getVersionableType(true));
        String message = NLS.bind((String)Messages.OpenPropertyChangeInCompareEditorAction_IGNORED_VERSIONABLE_DIALOG_MESSAGE, (Object)versionableChangeNode.getVersionableType(false), (Object)versionableChangeNode.getName());
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        JFaceUtils.showMessageBlocking((String)title, (String)message, (int)2);
    }
}

