/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditor;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditorInput;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenPortEditorAction
extends AbstractPortAction {
    public static void openPortEditor(IWorkbenchPage page, IWorkspaceConnection workspace, IComponent component) {
        OpenPortEditorAction.openPortEditor(page, workspace, component, null);
    }

    public static void openPortEditor(IWorkbenchPage page, IWorkspaceConnection workspace, IComponent component, String pageID) {
        IWorkbenchPage pageToUse = page;
        if (pageToUse == null) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            pageToUse = win.getActivePage();
        }
        if (pageToUse != null) {
            PortEditor.open(pageToUse, new PortEditorInput(workspace, component), pageID);
        }
    }

    public static void openPortEditor(IWorkbenchPage page, IStructuredSelection selection) {
        IWorkbenchPage pageToUse = page;
        if (pageToUse == null) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            pageToUse = win.getActivePage();
        }
        if (pageToUse != null) {
            for (Object object : selection.toList()) {
                ComponentSyncInfo info;
                IWorkspaceConnection workspace = null;
                IComponent component = null;
                if (object instanceof AbstractPortNode) {
                    AbstractPortNode portNode = (AbstractPortNode)object;
                    workspace = portNode.getWorkspaceConnection();
                    component = portNode.getComponent();
                }
                if (object instanceof WorkspaceComponentWrapper) {
                    WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)object;
                    workspace = wrapper.getWorkspaceConnection();
                    component = wrapper.getComponent();
                }
                if (object instanceof ComponentSyncContext) {
                    ComponentSyncContext componentSyncContext = (ComponentSyncContext)object;
                    info = componentSyncContext.getComponentSyncInfo();
                    workspace = info.getLocalWorkspaceConnection();
                    component = info.getComponent();
                }
                if (object instanceof IOutgoingRemoteActivity) {
                    IOutgoingRemoteActivity activity = (IOutgoingRemoteActivity)object;
                    info = activity.getActivitySource().getModel().getComponentSyncInfo();
                    workspace = info.getLocalWorkspaceConnection();
                    component = info.getComponent();
                }
                if (workspace == null || component == null) continue;
                OpenPortEditorAction.openPortEditor(page, workspace, component);
            }
        }
    }

    public static boolean isValidSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        for (Object object : ((IStructuredSelection)selection).toList()) {
            ComponentSyncInfo info;
            IWorkspaceConnection workspace = null;
            IComponent component = null;
            if (object instanceof AbstractPortNode) {
                AbstractPortNode portNode = (AbstractPortNode)object;
                workspace = portNode.getWorkspaceConnection();
                component = portNode.getComponent();
            }
            if (object instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)object;
                workspace = wrapper.getWorkspaceConnection();
                component = wrapper.getComponent();
            }
            if (object instanceof ComponentSyncContext) {
                ComponentSyncContext componentSyncContext = (ComponentSyncContext)object;
                info = componentSyncContext.getComponentSyncInfo();
                workspace = info.getLocalWorkspaceConnection();
                component = info.getComponent();
            }
            if (object instanceof IOutgoingRemoteActivity) {
                ICurrentPatch currentPatch;
                IChangeSetHandle targetCS;
                IOutgoingRemoteActivity activity = (IOutgoingRemoteActivity)object;
                info = activity.getActivitySource().getModel().getComponentSyncInfo();
                workspace = info.getLocalWorkspaceConnection();
                component = info.getComponent();
                if (!(workspace == null || workspace.getCurrentPatch((IComponentHandle)component) == null || (targetCS = (currentPatch = workspace.getCurrentPatch((IComponentHandle)component)).getTargetChangeSet()) != null && targetCS.sameItemId((IItemHandle)activity.getChangeSetHandle()))) {
                    return false;
                }
            }
            if (workspace == null || component == null) {
                return false;
            }
            try {
                if (workspace.getCurrentPatch((IComponentHandle)component) != null || workspace.getAcceptQueueSize((IComponentHandle)component) >= 1L) continue;
                return false;
            }
            catch (ComponentNotInWorkspaceException e) {
                return false;
            }
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(OpenPortEditorAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        OpenPortEditorAction.openPortEditor(page, selection);
    }
}

