/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractOpenVersionableChangeInCompareAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkVersionableChangeAsResolvedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInCompareEditorAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInExternalCompareAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ResolveVersionableChangeWithProposedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.SetVersionableChangeParentFolderAction;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnIgnorePortChangeDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class MergeVersionableChangeAction
extends AbstractPortAction {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(MergeVersionableChangeAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        MergeVersionableChangeAction.mergeVersionableChange(selection, page, this.getContext().getShell(), this.getContext().getUserOperationRunner());
    }

    public static boolean isValidSelection(ISelection selection) {
        Object object;
        IStructuredSelection ss;
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof VersionableChangeNode) {
            VersionableChangeNode versionableChangeNode = (VersionableChangeNode)object;
            isValid = versionableChangeNode.canBeMerged();
        }
        return isValid;
    }

    public static void mergeVersionableChange(IStructuredSelection selection, final IWorkbenchPage page, final Shell shell, final IOperationRunner runner) {
        if (MergeVersionableChangeAction.isValidSelection((ISelection)selection) && selection.getFirstElement() instanceof VersionableChangeNode) {
            final VersionableChangeNode versionableChangeNode = (VersionableChangeNode)selection.getFirstElement();
            IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
            IComponent component = versionableChangeNode.getComponent();
            IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
            if (!model.getLocalSynchronizationManager().isShared((IWorkspaceHandle)workspace.getResolvedWorkspace(), (IComponentHandle)component)) {
                MergeVersionableChangeAction.showRequestMergeOnUnloadedComponentDialog(versionableChangeNode);
            } else {
                String jobName = NLS.bind((String)Messages.MergeVersionableChangeAction_MERGE_JOB_NAME, (Object)versionableChangeNode.getVersionableType(true));
                if (versionableChangeNode.isDeleted()) {
                    jobName = NLS.bind((String)Messages.MergeVersionableChangeAction_MERGE_RESOURCE_DELETION_JOB_NAME, (Object)versionableChangeNode.getVersionableType(true));
                } else if (versionableChangeNode.isAdded()) {
                    jobName = NLS.bind((String)Messages.MergeVersionableChangeAction_MERGE_RESOURCE_ADDITION_JOB_NAME, (Object)versionableChangeNode.getVersionableType(true));
                } else if (versionableChangeNode.isItemMissing()) {
                    jobName = NLS.bind((String)Messages.MergeVersionableChangeAction_MERGE_ITEM_MISSING_JOB_NAME, (Object)versionableChangeNode.getVersionableType(true));
                }
                runner.enqueue(jobName, (Operation)new RepositoryOperation(versionableChangeNode.getRepository()){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        if (versionableChangeNode.isDeleted()) {
                            MergeVersionableChangeAction.mergeResourceDeletion(versionableChangeNode, page, shell, runner, monitor);
                        } else if (versionableChangeNode.isAdded()) {
                            MergeVersionableChangeAction.mergeResourceAddition(versionableChangeNode, page, shell, runner, monitor);
                        } else if (versionableChangeNode.isItemMissing()) {
                            MergeVersionableChangeAction.mergeMissingResource(versionableChangeNode, page, shell, runner, monitor);
                        }
                    }
                });
            }
        }
    }

    public static void mergeResourceDeletion(VersionableChangeNode versionableChangeNode, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        if (versionableChangeNode.isDeleted()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            String versionableType = versionableChangeNode.getVersionableType(false);
            String versionableTypeCaps = versionableChangeNode.getVersionableType(true);
            String versionableName = versionableChangeNode.getName();
            String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_DELETE_DIALOG_TITLE, (Object)versionableTypeCaps);
            String ignoreButton = Messages.MergeVersionableChangeAction_DELETE_DIALOG_IGNORE_BUTTON;
            String deleteButton = Messages.MergeVersionableChangeAction_DELETE_DIALOG_DELETE_BUTTON;
            IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
            IComponent component = versionableChangeNode.getComponent();
            IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)versionableChangeNode.getVersionable(), (IProgressMonitor)progress.newChild(50));
            if (shareable == null || !shareable.exists((IProgressMonitor)progress.newChild(50))) {
                ResolveVersionableChangeWithProposedAction.resolveVersionableChangeWithProposed((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), page, shell, runner);
            } else if (versionableChangeNode.isAutoResolvable()) {
                ResolveVersionableChangeWithProposedAction.resolveVersionableChangeWithProposed((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), page, shell, runner);
            } else if (versionableChangeNode.hasDescendants()) {
                String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_DELETE_WITH_DESCENDANTS_DIALOG_MESSAGE, (Object)versionableType);
                MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, deleteButton, false, 4, page, shell, runner);
            } else if (versionableChangeNode.getVersionable() instanceof IFileItemHandle) {
                String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_DELETE_FILE_DIALOG_MESSAGE, (Object)versionableName);
                MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, deleteButton, true, 3, page, shell, runner);
            } else {
                String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_DELETE_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
                MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, deleteButton, false, 3, page, shell, runner);
            }
            progress.done();
        }
    }

    public static void mergeResourceAddition(VersionableChangeNode versionableChangeNode, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        if (versionableChangeNode.isAdded()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            String versionableType = versionableChangeNode.getVersionableType(false);
            String versionableTypeCaps = versionableChangeNode.getVersionableType(true);
            String versionableName = versionableChangeNode.getName();
            String ignoreButton = Messages.MergeVersionableChangeAction_IGNORE_BUTTON;
            String addButton = Messages.MergeVersionableChangeAction_ADD_BUTTON;
            String overwriteButton = Messages.MergeVersionableChangeAction_OVERWRITE_BUTTON;
            IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
            IComponent component = versionableChangeNode.getComponent();
            IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)versionableChangeNode.getVersionable(), (IProgressMonitor)progress.newChild(25));
            if (shareable != null && shareable.exists((IProgressMonitor)progress.newChild(25))) {
                String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_ALREADY_EXISTS_DIALOG_TITLE, (Object)versionableTypeCaps);
                if (versionableChangeNode.getVersionable() instanceof IFileItemHandle) {
                    String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_FILE_ALREADY_EXISTS_DIALOG_MESSAGE, (Object)versionableName);
                    MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, overwriteButton, true, 3, page, shell, runner);
                } else {
                    String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_ALREADY_EXISTS_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
                    MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, overwriteButton, false, 3, page, shell, runner);
                }
            } else {
                progress.setWorkRemaining(50);
                if (versionableChangeNode.isDependentOnChange()) {
                    String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_DEPENDS_ON_PARENT_DIALOG_TITLE, (Object)versionableTypeCaps);
                    String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_DEPENDS_ON_PARENT_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
                    DialogUtil.pauseIfNeededBeforeShowingDialog();
                    JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMsg, (int)2);
                } else if (versionableChangeNode.isMissingParent()) {
                    String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_MISSING_PARENT_DIALOG_TITLE, (Object)versionableTypeCaps);
                    String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_MISSING_PARENT_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
                    String setParentButton = Messages.MergeVersionableChangeAction_SET_PARENT_BUTTON;
                    String cancelButton = Messages.MergeVersionableChangeAction_CANCEL_BUTTON;
                    DialogUtil.pauseIfNeededBeforeShowingDialog();
                    int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{ignoreButton, setParentButton, cancelButton}, (int)3, (int)2);
                    switch (code) {
                        case 0: {
                            MarkVersionableChangeAsResolvedAction.markVersionableChangeAsResolved((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), new WarnIgnorePortChangeDilemmaHandler(shell), page, shell, runner);
                            break;
                        }
                        case 1: {
                            SetVersionableChangeParentFolderAction.reparentVersionableChange((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), shell, runner);
                        }
                    }
                } else {
                    boolean hasNameCollision = false;
                    IVersionableHandle versionableAtAddLocation = null;
                    IVersionableHandle parentHandle = versionableChangeNode.getVersionableChange().getParent();
                    if (parentHandle != null) {
                        IShareable parentShareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)parentHandle, (IProgressMonitor)progress.newChild(25));
                        if (parentShareable != null) {
                            IRelativeLocation addLocation = parentShareable.getLocalPath().append(versionableName);
                            IShareable shareableAtAddLocation = parentShareable.getSandbox().findShareable(addLocation, ResourceType.getResourceType((IVersionableHandle)versionableChangeNode.getVersionable()));
                            if (shareableAtAddLocation != null && shareableAtAddLocation.exists((IProgressMonitor)progress.newChild(25))) {
                                hasNameCollision = true;
                                versionableAtAddLocation = shareableAtAddLocation.getVersionable((IProgressMonitor)progress.newChild(25));
                            }
                        } else if (versionableChangeNode.hasNameCollision()) {
                            hasNameCollision = true;
                        }
                    } else if (versionableChangeNode.hasNameCollision()) {
                        hasNameCollision = true;
                    }
                    if (hasNameCollision) {
                        String shareableAtAddLocationType = Messages.MergeVersionableChangeAction_FILE_OR_FOLDER;
                        if (versionableAtAddLocation != null) {
                            shareableAtAddLocationType = ItemUtil.getVersionableType(versionableAtAddLocation, (boolean)false);
                        }
                        String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_WITH_NAME_COLLISION_DIALOG_TITLE, (Object)versionableTypeCaps);
                        String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_WITH_NAME_COLLISION_DIALOG_MESSAGE, (Object[])new String[]{versionableType, versionableName, shareableAtAddLocationType});
                        if (versionableChangeNode.isFolder() && versionableAtAddLocation != null && versionableAtAddLocation instanceof IFolderHandle) {
                            dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_FOLDER_WITH_NAME_COLLISION_DIALOG_MESSAGE, (Object)versionableName);
                            overwriteButton = Messages.MergeVersionableChangeAction_MERGE_BUTTON;
                        }
                        MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, overwriteButton, false, 3, page, shell, runner);
                    } else {
                        String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_DIALOG_TITLE, (Object)versionableTypeCaps);
                        String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_ADD_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
                        MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, addButton, false, 3, page, shell, runner);
                    }
                }
            }
            progress.done();
        }
    }

    public static void mergeMissingResource(VersionableChangeNode versionableChangeNode, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
        IComponent component = versionableChangeNode.getComponent();
        String versionableType = versionableChangeNode.getVersionableType(false);
        String versionableTypeCaps = versionableChangeNode.getVersionableType(true);
        String versionableName = versionableChangeNode.getName();
        String ignoreButton = Messages.MergeVersionableChangeAction_IGNORE_BUTTON;
        String addButton = Messages.MergeVersionableChangeAction_ADD_BUTTON;
        String overwriteButton = Messages.MergeVersionableChangeAction_OVERWRITE_BUTTON;
        if (versionableChangeNode.isDependentOnChange()) {
            String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_WITH_DEPENDS_ON_DIALOG_TITLE, (Object)versionableTypeCaps);
            String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_WITH_DEPENDS_ON_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMsg, (int)2);
        } else if (versionableChangeNode.isMissingParent()) {
            String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_AND_MISSING_PARENT_DIALOG_TITLE, (Object)versionableTypeCaps);
            String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_AND_MISSING_PARENT_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
            String setParentButton = Messages.MergeVersionableChangeAction_SET_PARENT_BUTTON;
            String cancelButton = Messages.MergeVersionableChangeAction_CANCEL_BUTTON;
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{ignoreButton, setParentButton, cancelButton}, (int)3, (int)2);
            switch (code) {
                case 0: {
                    MarkVersionableChangeAsResolvedAction.markVersionableChangeAsResolved((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), new WarnIgnorePortChangeDilemmaHandler(shell), page, shell, runner);
                    break;
                }
                case 1: {
                    SetVersionableChangeParentFolderAction.reparentVersionableChange((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), shell, runner);
                }
            }
        } else {
            boolean hasNameCollision = false;
            IVersionableHandle versionableAtAddLocation = null;
            IVersionableHandle parentHandle = versionableChangeNode.getVersionableChange().getParent();
            if (parentHandle != null) {
                IShareable parentShareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)parentHandle, (IProgressMonitor)progress.newChild(25));
                if (parentShareable != null) {
                    IRelativeLocation addLocation = parentShareable.getLocalPath().append(versionableName);
                    IShareable shareableAtAddLocation = parentShareable.getSandbox().findShareable(addLocation, ResourceType.getResourceType((IVersionableHandle)versionableChangeNode.getVersionable()));
                    if (shareableAtAddLocation != null && shareableAtAddLocation.exists((IProgressMonitor)progress.newChild(25))) {
                        hasNameCollision = true;
                        versionableAtAddLocation = shareableAtAddLocation.getVersionable((IProgressMonitor)progress.newChild(25));
                    }
                }
                if (versionableChangeNode.hasNameCollision()) {
                    hasNameCollision = true;
                }
            } else if (versionableChangeNode.hasNameCollision()) {
                hasNameCollision = true;
            }
            if (hasNameCollision) {
                String shareableAtAddLocationType = Messages.MergeVersionableChangeAction_FILE_OR_FOLDER;
                if (versionableAtAddLocation != null) {
                    shareableAtAddLocationType = ItemUtil.getVersionableType(versionableAtAddLocation, (boolean)false);
                }
                String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_WITH_NAME_CONFLICT_DIALOG_TITLE, (Object)versionableTypeCaps);
                String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_WITH_NAME_CONFLICT_DIALOG_MESSAGE, (Object[])new String[]{versionableType, versionableName, shareableAtAddLocationType});
                if (versionableChangeNode.isFolder() && versionableAtAddLocation != null && versionableAtAddLocation instanceof IFolderHandle) {
                    dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_FOLDER_WITH_FOLDER_NAME_CONFLICT_DIALOG_MESSAGE, (Object)versionableName);
                    overwriteButton = Messages.MergeVersionableChangeAction_MERGE_BUTTON;
                }
                MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, overwriteButton, false, 3, page, shell, runner);
            } else {
                String dialogTitle = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_DIALOG_TITLE, (Object)versionableTypeCaps);
                String dialogMsg = NLS.bind((String)Messages.MergeVersionableChangeAction_MISSING_ITEM_DIALOG_MESSAGE, (Object)versionableType, (Object)versionableName);
                MergeVersionableChangeAction.openMergeDialog(versionableChangeNode, dialogTitle, dialogMsg, ignoreButton, addButton, false, 3, page, shell, runner);
            }
        }
        progress.done();
    }

    private static void openMergeDialog(VersionableChangeNode versionableChangeNode, String dialogTitle, String dialogMsg, String markAsResolvedButton, String resolveWithProposedButton, boolean allowOpenInCompare, int dialogSeverity, IWorkbenchPage page, Shell shell, IOperationRunner runner) {
        String openInCompareButton = Messages.MergeVersionableChangeAction_OPEN_IN_COMPARE_BUTTON;
        String cancelButton = Messages.MergeVersionableChangeAction_CANCEL_BUTTON;
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        if (allowOpenInCompare && versionableChangeNode.getVersionable() instanceof IFileItemHandle) {
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{markAsResolvedButton, resolveWithProposedButton, openInCompareButton, cancelButton}, (int)dialogSeverity, (int)3);
            switch (code) {
                case 0: {
                    MarkVersionableChangeAsResolvedAction.markVersionableChangeAsResolved((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), new WarnIgnorePortChangeDilemmaHandler(shell), page, shell, runner);
                    break;
                }
                case 1: {
                    ResolveVersionableChangeWithProposedAction.resolveVersionableChangeWithProposed((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), page, shell, runner);
                    break;
                }
                case 2: {
                    boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(versionableChangeNode.getName());
                    AbstractOpenVersionableChangeInCompareAction actionDelegate = useExternalCompareTool ? new OpenVersionableChangeInExternalCompareAction() : new OpenVersionableChangeInCompareEditorAction();
                    MergeVersionableChangeAction.runActionDelegate(actionDelegate, (IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), page, shell, false);
                }
            }
        } else {
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{markAsResolvedButton, resolveWithProposedButton, cancelButton}, (int)dialogSeverity, (int)2);
            switch (code) {
                case 0: {
                    MarkVersionableChangeAsResolvedAction.markVersionableChangeAsResolved((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), new WarnIgnorePortChangeDilemmaHandler(shell), page, shell, runner);
                    break;
                }
                case 1: {
                    ResolveVersionableChangeWithProposedAction.resolveVersionableChangeWithProposed((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), page, shell, runner);
                }
            }
        }
    }

    private static void runActionDelegate(final AbstractActionDelegate actionDelegate, final IStructuredSelection selection, final IWorkbenchPage page, final Shell shell, final boolean checkActionEnablement) {
        Display display = shell.getDisplay();
        if (!display.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    actionDelegate.init(page.getWorkbenchWindow());
                    if (checkActionEnablement) {
                        Action tempAction = new Action(){};
                        actionDelegate.selectionChanged((IAction)tempAction, (ISelection)selection);
                        if (tempAction.isEnabled()) {
                            actionDelegate.run(shell, page, selection);
                        }
                    } else {
                        actionDelegate.run(shell, page, selection);
                    }
                }
            });
        }
    }
}

