/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractOpenVersionableChangeInCompareAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkChangeDetailAsResolvedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MergeVersionableChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenPropertyChangeInCompareEditorAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInCompareEditorAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInExternalCompareAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ResolveChangeDetailWithProposedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.SetVersionableChangeParentFolderAction;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentTypeChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.EncodingChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ExecutableBitChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.LineDelimiterChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.MoveChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortNodesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PropertyChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.SymbolicLinkChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnIgnorePortChangeDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class MergeChangeDetailAction
extends AbstractPortAction {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(MergeChangeDetailAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        MergeChangeDetailAction.mergeChangeDetail(selection, page, this.getContext().getShell(), this.getContext().getUserOperationRunner());
    }

    public static boolean isValidSelection(ISelection selection) {
        Object object;
        IStructuredSelection ss;
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof AbstractChangeDetailNode) {
            AbstractChangeDetailNode node = (AbstractChangeDetailNode)object;
            isValid = !node.isResolved();
        }
        return isValid;
    }

    public static void mergeChangeDetail(IStructuredSelection selection, final IWorkbenchPage page, final Shell shell, final IOperationRunner runner) {
        if (MergeChangeDetailAction.isValidSelection((ISelection)selection) && selection.getFirstElement() instanceof AbstractChangeDetailNode) {
            final AbstractChangeDetailNode changeDetailNode = (AbstractChangeDetailNode)selection.getFirstElement();
            final VersionableChangeNode versionableChangeNode = changeDetailNode.getParentNode();
            final IWorkspaceConnection workspace = changeDetailNode.getWorkspaceConnection();
            final IComponent component = changeDetailNode.getComponent();
            if (versionableChangeNode != null) {
                runner.enqueue(NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_JOB_NAME, (Object)changeDetailNode.getChangeType(true)), (Operation)new RepositoryOperation(workspace.teamRepository()){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)versionableChangeNode.getVersionable(), (IProgressMonitor)progress.newChild(10));
                        if (changeDetailNode instanceof ContentChangeDetailNode) {
                            boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(versionableChangeNode.getName());
                            if (useExternalCompareTool && (shareable == null || !shareable.exists((IProgressMonitor)progress.newChild(10)))) {
                                useExternalCompareTool = false;
                            }
                            boolean isText = MergeChangeDetailAction.isText(shareable, workspace, component, versionableChangeNode.getVersionableChange(), (IProgressMonitor)progress.newChild(1));
                            MergeChangeDetailAction.mergeContentChange((ContentChangeDetailNode)changeDetailNode, versionableChangeNode, isText, useExternalCompareTool, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                        } else if (changeDetailNode instanceof ContentTypeChangeDetailNode) {
                            String currentType = MergeChangeDetailAction.getContentType(shareable, workspace, component, versionableChangeNode.getVersionableChange(), (IProgressMonitor)progress.newChild(1));
                            MergeChangeDetailAction.mergeContentTypeChange((ContentTypeChangeDetailNode)changeDetailNode, versionableChangeNode, currentType, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                        } else if (changeDetailNode instanceof EncodingChangeDetailNode) {
                            String currentEncoding = MergeChangeDetailAction.getCurrentEncoding(shareable, workspace, component, versionableChangeNode.getVersionableChange(), (IProgressMonitor)progress.newChild(1));
                            MergeChangeDetailAction.mergeEncodingChange((EncodingChangeDetailNode)changeDetailNode, versionableChangeNode, currentEncoding, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                        } else if (changeDetailNode instanceof ExecutableBitChangeDetailNode) {
                            MergeChangeDetailAction.mergeExecutableBitChange((ExecutableBitChangeDetailNode)changeDetailNode, page, shell, runner);
                        } else if (changeDetailNode instanceof LineDelimiterChangeDetailNode) {
                            FileLineDelimiter currentDelimiter = MergeChangeDetailAction.getCurrentLineDelimiter(shareable, workspace, component, versionableChangeNode.getVersionableChange(), (IProgressMonitor)progress.newChild(1));
                            MergeChangeDetailAction.mergeLineDelimiterChange((LineDelimiterChangeDetailNode)changeDetailNode, versionableChangeNode, currentDelimiter, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                        } else if (changeDetailNode instanceof MoveChangeDetailNode) {
                            if (shareable == null || !shareable.exists((IProgressMonitor)progress.newChild(10))) {
                                progress.setWorkRemaining(80);
                                MergeVersionableChangeAction.mergeMissingResource(versionableChangeNode, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                                return;
                            }
                            MergeChangeDetailAction.mergeMoveChange((MoveChangeDetailNode)changeDetailNode, versionableChangeNode, shareable, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                        } else if (changeDetailNode instanceof PropertyChangeDetailNode) {
                            String property = ((PropertyChangeDetailNode)changeDetailNode).getPropertyName();
                            String currentValue = MergeChangeDetailAction.getCurrentPropertyValue(property, shareable, workspace, component, versionableChangeNode.getVersionableChange(), (IProgressMonitor)progress.newChild(1));
                            MergeChangeDetailAction.mergePropertyChange((PropertyChangeDetailNode)changeDetailNode, versionableChangeNode, currentValue, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                        } else if (changeDetailNode instanceof SymbolicLinkChangeDetailNode) {
                            String currentTarget = MergeChangeDetailAction.getCurrentTarget(shareable, workspace, component, versionableChangeNode.getVersionableChange(), (IProgressMonitor)progress.newChild(1));
                            MergeChangeDetailAction.mergeSymbolicLinkChange((SymbolicLinkChangeDetailNode)changeDetailNode, versionableChangeNode, currentTarget, page, shell, runner, (IProgressMonitor)progress.newChild(80));
                        }
                        progress.done();
                    }
                });
            }
        }
    }

    protected static String getCurrentTarget(IShareable shareable, IWorkspaceConnection workspace, IComponent component, IVersionableChange versionableChange, IProgressMonitor monitor) throws TeamRepositoryException {
        if (shareable != null) {
            LinkInfo linkInfo = CoreShareablesUtil.getFileStorage((IShareable)shareable).getLinkInfo(monitor);
            return linkInfo.getTarget();
        }
        IVersionable item = workspace.configuration((IComponentHandle)component).fetchCompleteItem(versionableChange.getVersionable(), monitor);
        if (item instanceof ISymbolicLink) {
            ISymbolicLink file = (ISymbolicLink)item;
            return file.getTarget();
        }
        return null;
    }

    protected static String getCurrentPropertyValue(String propertyName, IShareable shareable, IWorkspaceConnection workspace, IComponent component, IVersionableChange versionableChange, IProgressMonitor monitor) throws TeamRepositoryException {
        if (shareable != null) {
            IMetadataProperties metadataProperties = shareable.getMetadataProperties(monitor);
            return (String)metadataProperties.getCurrentProperties().get(propertyName);
        }
        IVersionable item = workspace.configuration((IComponentHandle)component).fetchCompleteItem(versionableChange.getVersionable(), monitor);
        return (String)item.getUserProperties().get(propertyName);
    }

    protected static FileLineDelimiter getCurrentLineDelimiter(IShareable shareable, IWorkspaceConnection workspace, IComponent component, IVersionableChange versionableChange, IProgressMonitor monitor) throws TeamRepositoryException {
        if (shareable != null) {
            return shareable.getLineDelimiter(monitor);
        }
        try {
            IVersionable item = workspace.configuration((IComponentHandle)component).fetchCompleteItem(versionableChange.getVersionable(), monitor);
            if (item instanceof IFileItem) {
                IFileItem file = (IFileItem)item;
                return file.getContent().getLineDelimiter();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    protected static String getCurrentEncoding(IShareable shareable, IWorkspaceConnection workspace, IComponent component, IVersionableChange versionableChange, IProgressMonitor monitor) throws TeamRepositoryException {
        if (shareable != null) {
            IContentExaminer contentExaminer = SharingManager.getInstance().getContentExaminer(shareable);
            return contentExaminer.getEncoding(shareable, monitor);
        }
        try {
            IVersionable item = workspace.configuration((IComponentHandle)component).fetchCompleteItem(versionableChange.getVersionable(), monitor);
            if (item instanceof IFileItem) {
                IFileItem file = (IFileItem)item;
                return file.getContent().getCharacterEncoding();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return IContentProperties.CHARACTER_ENCODING_UNKNOWN;
    }

    protected static String getContentType(IShareable shareable, IWorkspaceConnection workspace, IComponent component, IVersionableChange versionableChange, IProgressMonitor monitor) throws TeamRepositoryException {
        if (shareable != null) {
            return shareable.getContentType(monitor);
        }
        try {
            IVersionable item = workspace.configuration((IComponentHandle)component).fetchCompleteItem(versionableChange.getVersionable(), monitor);
            if (item instanceof IFileItem) {
                IFileItem file = (IFileItem)item;
                return file.getContentType();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return "application/unknown";
    }

    protected static boolean isText(IShareable shareable, IWorkspaceConnection workspace, IComponent component, IVersionableChange versionableChange, IProgressMonitor monitor) throws TeamRepositoryException {
        if (shareable != null) {
            IContentProperties properties = SharingManager.getInstance().getContentExaminer(shareable).findStoredProperties(shareable, monitor);
            return properties.isText();
        }
        try {
            IVersionable item = workspace.configuration((IComponentHandle)component).fetchCompleteItem(versionableChange.getVersionable(), monitor);
            if (item instanceof IFileItem) {
                IFileItem file = (IFileItem)item;
                return file.getContentType().startsWith("text");
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return false;
    }

    private static void openConflictDialog(AbstractChangeDetailNode changeDetailNode, String dialogTitle, String dialogMsg, IWorkbenchPage page, Shell shell, IOperationRunner runner) {
        MergeChangeDetailAction.openConflictDialog(changeDetailNode, dialogTitle, dialogMsg, Messages.MergeChangeDetailAction_MERGE_DIALOG_IGNORE_BUTTON, Messages.MergeChangeDetailAction_MERGE_DIALOG_ACCEPT_BUTTON, page, shell, runner);
    }

    private static void openConflictDialog(AbstractChangeDetailNode changeDetailNode, String dialogTitle, String dialogMsg, String markAsResolvedButton, String resolveWithProposedButton, IWorkbenchPage page, Shell shell, IOperationRunner runner) {
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{markAsResolvedButton, resolveWithProposedButton, Messages.MergeChangeDetailAction_MERGE_DIALOG_CANCEL_BUTTON}, (int)3, (int)2);
        switch (code) {
            case 0: {
                MarkChangeDetailAsResolvedAction.markChangeDetailAsResolved((IStructuredSelection)new StructuredSelection((Object)changeDetailNode), new WarnIgnorePortChangeDilemmaHandler(shell), page, shell, runner);
                break;
            }
            case 1: {
                ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)changeDetailNode), page, shell, runner);
            }
        }
    }

    private static void runActionDelegate(final AbstractActionDelegate actionDelegate, final IStructuredSelection selection, final IWorkbenchPage page, final Shell shell) {
        Display display = shell.getDisplay();
        if (!display.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    actionDelegate.init(page.getWorkbenchWindow());
                    Action tempAction = new Action(){};
                    actionDelegate.selectionChanged((IAction)tempAction, (ISelection)selection);
                    if (tempAction.isEnabled()) {
                        actionDelegate.run(shell, page, selection);
                    }
                }
            });
        }
    }

    private static void mergeContentChange(ContentChangeDetailNode contentChange, VersionableChangeNode versionableChangeNode, boolean isText, boolean useExternalCompareTool, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        boolean openCompare = false;
        if (isText) {
            openCompare = true;
        } else {
            String dialogTitle = Messages.MergeChangeDetailAction_CONTENT_NOT_TEXT_DIALOG_TITLE;
            String dialogMessage = useExternalCompareTool ? NLS.bind((String)Messages.MergeChangeDetailAction_CONTENT_NOT_TEXT_DIALOG_MESSAGE_EXTERNAL_COMPARE, (Object)versionableChangeNode.getName()) : NLS.bind((String)Messages.MergeChangeDetailAction_CONTENT_NOT_TEXT_DIALOG_MESSAGE, (Object)versionableChangeNode.getName());
            String openInCompareButton = Messages.MergeChangeDetailAction_MERGE_DIALOG_OPEN_IN_COMPARE_BUTTON;
            String overwriteButton = Messages.MergeChangeDetailAction_MERGE_DIALOG_OVERWRITE_BUTTON;
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])new String[]{openInCompareButton, overwriteButton, Messages.MergeChangeDetailAction_MERGE_DIALOG_CANCEL_BUTTON}, (int)3, (int)2);
            switch (code) {
                case 0: {
                    openCompare = true;
                    break;
                }
                case 1: {
                    ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)contentChange), false, page, shell, runner);
                    return;
                }
            }
        }
        if (openCompare) {
            AbstractOpenVersionableChangeInCompareAction actionDelegate = useExternalCompareTool ? new OpenVersionableChangeInExternalCompareAction() : new OpenVersionableChangeInCompareEditorAction();
            MergeChangeDetailAction.runActionDelegate(actionDelegate, (IStructuredSelection)new StructuredSelection((Object)contentChange), page, shell);
        }
    }

    private static void mergeContentTypeChange(ContentTypeChangeDetailNode contentTypeChange, VersionableChangeNode versionableChangeNode, String currentType, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        String beforeType = contentTypeChange.getContentTypeChangeDetail().getBeforeType();
        String afterType = contentTypeChange.getContentTypeChangeDetail().getAfterType();
        if (beforeType.equals(currentType) || afterType.equals(currentType)) {
            ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)contentTypeChange), page, shell, runner);
            return;
        }
        String dialogTitle = Messages.MergeChangeDetailAction_MERGE_CONTENT_TYPE_DIALOG_TITLE;
        String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_CONTENT_TYPE_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), beforeType, afterType, currentType});
        MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)contentTypeChange, dialogTitle, dialogMsg, page, shell, runner);
    }

    private static void mergeEncodingChange(EncodingChangeDetailNode encodingChange, VersionableChangeNode versionableChangeNode, String currentEncoding, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        String afterEncoding;
        String beforeEncoding = encodingChange.getEncodingChangeDetail().getBeforeCharacterEncoding();
        if (beforeEncoding == null) {
            beforeEncoding = IContentProperties.CHARACTER_ENCODING_UNKNOWN;
        }
        if ((afterEncoding = encodingChange.getEncodingChangeDetail().getAfterCharacterEncoding()) == null) {
            afterEncoding = IContentProperties.CHARACTER_ENCODING_UNKNOWN;
        }
        if (beforeEncoding.equals(currentEncoding) || afterEncoding.equals(currentEncoding)) {
            ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)encodingChange), page, shell, runner);
            return;
        }
        String dialogTitle = Messages.MergeChangeDetailAction_MERGE_ENCODING_DIALOG_TITLE;
        String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_ENCODING_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), beforeEncoding, afterEncoding, currentEncoding});
        MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)encodingChange, dialogTitle, dialogMsg, page, shell, runner);
    }

    private static void mergeExecutableBitChange(ExecutableBitChangeDetailNode executableBitChange, IWorkbenchPage page, Shell shell, IOperationRunner runner) {
        ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)executableBitChange), page, shell, runner);
    }

    private static void mergeLineDelimiterChange(LineDelimiterChangeDetailNode lineDelimiterChange, VersionableChangeNode versionableChangeNode, FileLineDelimiter currentLineDelimiter, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        FileLineDelimiter beforeLineDelimiter = lineDelimiterChange.getLineDelimiterChangeDetail().getBeforeLineDelimiter();
        FileLineDelimiter afterLineDelimiter = lineDelimiterChange.getLineDelimiterChangeDetail().getAfterLineDelimiter();
        if (beforeLineDelimiter.equals((Object)currentLineDelimiter) || afterLineDelimiter.equals((Object)currentLineDelimiter)) {
            ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)lineDelimiterChange), page, shell, runner);
            return;
        }
        String dialogTitle = Messages.MergeChangeDetailAction_MERGE_LINE_DELIMITER_DIALOG_TITLE;
        String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_LINE_DELIMITER_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), beforeLineDelimiter.toString(), afterLineDelimiter.toString(), currentLineDelimiter.toString()});
        MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)lineDelimiterChange, dialogTitle, dialogMsg, page, shell, runner);
    }

    private static void mergeMoveChange(MoveChangeDetailNode moveChange, VersionableChangeNode versionableChangeNode, IShareable shareable, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVersionableHandle versionable = versionableChangeNode.getVersionable();
        String versionableType = versionableChangeNode.getVersionableType(false);
        String localName = shareable.getFullPath().getName();
        String versionableName = versionableChangeNode.getName();
        String beforeName = moveChange.getBeforeName();
        String afterName = moveChange.getAfterName();
        if (moveChange.isRename() && !moveChange.isMove()) {
            if (!afterName.equals(localName)) {
                IRelativeLocation renamedLocation = shareable.getLocalPath().getParent().append(afterName);
                IShareable shareableAtRenameLocation = shareable.getSandbox().findShareable(renamedLocation, ResourceType.getResourceType((IVersionableHandle)versionable));
                if (shareableAtRenameLocation != null && shareableAtRenameLocation.exists((IProgressMonitor)progress.newChild(100))) {
                    String dialogTitle = Messages.MergeChangeDetailAction_RENAME_CONFLICT_DIALOG_TITLE;
                    String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_RENAME_CONFLICT_DIALOG_MSG, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableName, afterName});
                    String overwriteButton = Messages.MergeChangeDetailAction_MOVE_CONFLICT_OVERWRITE_BUTTON;
                    MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)moveChange, dialogTitle, dialogMsg, Messages.MergeChangeDetailAction_MERGE_DIALOG_IGNORE_BUTTON, overwriteButton, page, shell, runner);
                    progress.setWorkRemaining(0);
                    return;
                }
            }
            if (beforeName.equals(localName) || afterName.equals(localName)) {
                ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)moveChange), page, shell, runner);
                return;
            }
            String dialogTitle = Messages.MergeChangeDetailAction_MERGE_RENAME_DIALOG_TITLE;
            String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_RENAME_DIALOG_MESSAGE, (Object[])new String[]{versionableType, versionableName, beforeName, afterName, localName});
            MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)moveChange, dialogTitle, dialogMsg, page, shell, runner);
            progress.setWorkRemaining(0);
            return;
        }
        if (moveChange.isMove()) {
            IShareable currentParentShareable = CoreShareablesUtil.getParent((IShareable)shareable);
            IVersionableHandle currentParent = null;
            if (currentParentShareable == null) {
                IVersionable fullVersionable = SCMPlatform.getWorkspaceManager((ITeamRepository)versionableChangeNode.getRepository()).versionableManager().fetchCompleteState(versionable, (IProgressMonitor)progress.newChild(25));
                currentParent = fullVersionable.getParent();
            } else {
                currentParent = currentParentShareable.getVersionable((IProgressMonitor)progress.newChild(25));
            }
            IFolderHandle beforeParent = moveChange.getBeforeParent();
            IFolderHandle afterParent = moveChange.getAfterParent();
            IShareable moveDestinationFolder = ComponentSyncUtil.findShareable((IContextHandle)moveChange.getWorkspaceConnection().getContextHandle(), (IComponentHandle)moveChange.getComponent(), (IVersionableHandle)afterParent, (IProgressMonitor)progress.newChild(25));
            if (moveDestinationFolder == null || !moveDestinationFolder.exists((IProgressMonitor)progress.newChild(25))) {
                if (moveChange.isDependentOnMoveTargetResolution()) {
                    String dialogTitle = Messages.MergeChangeDetailAction_DEPENDS_ON_MOVE_DESTINATION_RESOLUTION_DIALOG_TITLE;
                    String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_DEPENDS_ON_MOVE_DESTINATION_RESOLUTION_DIALOG_MSG, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), moveChange.getAfterPath(false)});
                    DialogUtil.pauseIfNeededBeforeShowingDialog();
                    JFaceUtils.showMessageBlocking((String)dialogTitle, (String)dialogMsg, (int)2);
                    progress.setWorkRemaining(0);
                    return;
                }
                String dialogTitle = Messages.MergeChangeDetailAction_MOVE_DESTINATION_MISSING_DIALOG_TITLE;
                String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MOVE_DESTINATION_MISSING_DIALOG_BASIC_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName()});
                String afterPath = moveChange.getAfterPath(false);
                if (!afterPath.equals(PortNodesUtil.MISSING_FOLDER_LABEL)) {
                    dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MOVE_DESTINATION_MISSING_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), afterPath});
                }
                String setParentFolderButton = Messages.MergeChangeDetailAction_SET_PARENT_FOLDER_BUTTON;
                DialogUtil.pauseIfNeededBeforeShowingDialog();
                int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{Messages.MergeChangeDetailAction_MERGE_DIALOG_IGNORE_BUTTON, setParentFolderButton, Messages.MergeChangeDetailAction_MERGE_DIALOG_CANCEL_BUTTON}, (int)3, (int)2);
                switch (code) {
                    case 0: {
                        MarkChangeDetailAsResolvedAction.markChangeDetailAsResolved((IStructuredSelection)new StructuredSelection((Object)moveChange), new WarnIgnorePortChangeDilemmaHandler(shell), page, shell, runner);
                        break;
                    }
                    case 1: {
                        SetVersionableChangeParentFolderAction.reparentVersionableChange((IStructuredSelection)new StructuredSelection((Object)versionableChangeNode), shell, runner);
                    }
                }
                progress.setWorkRemaining(0);
                return;
            }
            progress.setWorkRemaining(50);
            if (moveDestinationFolder != null) {
                IVersionableHandle versionableAtMoveDestination;
                IRelativeLocation proposedMoveAndRenameLocation = moveDestinationFolder.getLocalPath().append(moveChange.isRename() ? afterName : localName);
                IShareable shareableAtMoveDestination = shareable.getSandbox().findShareable(proposedMoveAndRenameLocation, ResourceType.getResourceType((IVersionableHandle)versionable));
                if (shareableAtMoveDestination != null && shareableAtMoveDestination.exists((IProgressMonitor)progress.newChild(25)) && (versionableAtMoveDestination = shareableAtMoveDestination.getVersionable((IProgressMonitor)progress.newChild(25))) != null && !versionableAtMoveDestination.sameItemId((IItemHandle)versionable)) {
                    String dialogTitle = Messages.MergeChangeDetailAction_MOVE_CONFLICT_DIALOG_TITLE;
                    String afterParentPathAndName = "/" + moveChange.getAfterPath(true);
                    String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MOVE_CONFLICT_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableName, afterParentPathAndName});
                    String overwriteButton = Messages.MergeChangeDetailAction_MOVE_CONFLICT_OVERWRITE_BUTTON;
                    MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)moveChange, dialogTitle, dialogMsg, Messages.MergeChangeDetailAction_MERGE_DIALOG_IGNORE_BUTTON, overwriteButton, page, shell, runner);
                    progress.setWorkRemaining(0);
                    return;
                }
            }
            boolean canResolveWithProposed = false;
            if (beforeParent.sameItemId((IItemHandle)currentParent) || afterParent.sameItemId((IItemHandle)currentParent)) {
                canResolveWithProposed = moveChange.isRename() && beforeName.equals(localName) || afterName.equals(localName) ? true : true;
            }
            if (canResolveWithProposed) {
                ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)moveChange), page, shell, runner);
                return;
            }
            String currentPathAndName = shareable.getLocalPath().toString();
            String beforeParentPathAndName = "/" + moveChange.getBeforePath(true);
            String afterParentPathAndName = "/" + moveChange.getAfterPath(true);
            String dialogTitle = Messages.MergeChangeDetailAction_MERGE_MOVE_DIALOG_TITLE;
            String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_MOVE_DIALOG_MESSAGE, (Object[])new String[]{versionableType, localName, beforeParentPathAndName, afterParentPathAndName, currentPathAndName});
            MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)moveChange, dialogTitle, dialogMsg, page, shell, runner);
            progress.setWorkRemaining(0);
            return;
        }
    }

    private static void mergePropertyChange(PropertyChangeDetailNode propertyChange, VersionableChangeNode versionableChangeNode, String currentValueFull, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws FileSystemException {
        String newLineChars = "(\\r\\n|\\r|\\n)";
        String space = " ";
        String propertyNameTruncated = propertyChange.getPropertyName(propertyChange.getDefaultMaxPropertyNameLength());
        if (propertyNameTruncated != null) {
            propertyNameTruncated = propertyNameTruncated.replaceAll(newLineChars, space);
        }
        String currentValueTruncated = currentValueFull;
        int length = propertyChange.getDefaultMaxPropertyValueLength();
        if (currentValueTruncated != null && length >= 0 && currentValueTruncated.length() > length) {
            currentValueTruncated = NLS.bind((String)Messages.MergeChangeDetailAction_PROPERTY_VALUE_TRUNCATED_TEXT, (Object)currentValueTruncated.substring(0, length)).replaceAll(newLineChars, space);
        }
        String beforeValueFull = propertyChange.getBeforeValue();
        String beforeValueTruncated = propertyChange.getBeforeValue(propertyChange.getDefaultMaxPropertyValueLength());
        if (beforeValueTruncated != null) {
            beforeValueTruncated = beforeValueTruncated.replaceAll(newLineChars, space);
        }
        String afterValueFull = propertyChange.getAfterValue();
        String afterValueTruncated = propertyChange.getAfterValue(propertyChange.getDefaultMaxPropertyValueLength());
        if (afterValueTruncated != null) {
            afterValueTruncated = afterValueTruncated.replaceAll(newLineChars, space);
        }
        String dialogTitle = Messages.MergeChangeDetailAction_MERGE_PROPERTY_CHANGE_DIALOG_TITLE;
        String dialogMsg = null;
        String acceptButton = Messages.MergeChangeDetailAction_MERGE_DIALOG_ACCEPT_BUTTON;
        if (propertyChange.isModified()) {
            if (currentValueFull != null && (beforeValueFull.equals(currentValueFull) || afterValueFull.equals(currentValueFull))) {
                ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)propertyChange), page, shell, runner);
                return;
            }
            dialogMsg = currentValueFull == null ? NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_PROPERTY_MODIFIED_NO_LOCAL_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), propertyNameTruncated, beforeValueTruncated, afterValueTruncated}) : NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_PROPERTY_MODIFIED_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), propertyNameTruncated, beforeValueTruncated, afterValueTruncated, currentValueTruncated});
        } else if (propertyChange.isAdded()) {
            if (currentValueFull == null || afterValueFull.equals(currentValueFull)) {
                ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)propertyChange), page, shell, runner);
                return;
            }
            dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_PROPERTY_ADD_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), propertyNameTruncated, afterValueTruncated, currentValueTruncated});
        } else if (propertyChange.isDeleted()) {
            if (currentValueFull == null || beforeValueFull.equals(currentValueFull)) {
                ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)propertyChange), page, shell, runner);
                return;
            }
            dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_PROPERTY_DELETE_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), propertyNameTruncated, beforeValueTruncated, currentValueTruncated});
            acceptButton = Messages.MergeChangeDetailAction_MERGE_DIALOG_DELETE_BUTTON;
        }
        if (dialogMsg == null) {
            ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)propertyChange), page, shell, runner);
            return;
        }
        String ignoreButton = Messages.MergeChangeDetailAction_MERGE_DIALOG_IGNORE_BUTTON;
        String openInCompareButton = Messages.MergeChangeDetailAction_MERGE_DIALOG_OPEN_IN_COMPARE_BUTTON;
        String cancelButton = Messages.MergeChangeDetailAction_MERGE_DIALOG_CANCEL_BUTTON;
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        int code = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMsg, (String[])new String[]{ignoreButton, acceptButton, openInCompareButton, cancelButton}, (int)3, (int)3);
        switch (code) {
            case 0: {
                MarkChangeDetailAsResolvedAction.markChangeDetailAsResolved((IStructuredSelection)new StructuredSelection((Object)propertyChange), new WarnIgnorePortChangeDilemmaHandler(shell), page, shell, runner);
                break;
            }
            case 1: {
                ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)propertyChange), page, shell, runner);
                break;
            }
            case 2: {
                OpenPropertyChangeInCompareEditorAction.openPropertyCompareDialog(propertyChange, false, page, shell, runner);
            }
        }
    }

    private static void mergeSymbolicLinkChange(SymbolicLinkChangeDetailNode symbolicLinkChange, VersionableChangeNode versionableChangeNode, String currentTarget, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws TeamRepositoryException {
        String beforeTarget = symbolicLinkChange.getSymbolicLinkChangeDetail().getBeforeTarget();
        String afterTarget = symbolicLinkChange.getSymbolicLinkChangeDetail().getAfterTarget();
        if (beforeTarget.equals(currentTarget) || afterTarget.equals(currentTarget)) {
            ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed((IStructuredSelection)new StructuredSelection((Object)symbolicLinkChange), page, shell, runner);
            return;
        }
        String dialogTitle = Messages.MergeChangeDetailAction_MERGE_SYMBOLIC_LINK_DIALOG_TITLE;
        String dialogMsg = NLS.bind((String)Messages.MergeChangeDetailAction_MERGE_SYMBOLIC_LINK_DIALOG_MESSAGE, (Object[])new String[]{versionableChangeNode.getVersionableType(false), versionableChangeNode.getName(), beforeTarget, afterTarget, currentTarget});
        MergeChangeDetailAction.openConflictDialog((AbstractChangeDetailNode)symbolicLinkChange, dialogTitle, dialogMsg, page, shell, runner);
    }
}

