/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.CompleteCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICompleteCurrentPatchOperation;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ProcessPendingPortsAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortOutputControl;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditor;
import com.ibm.team.internal.filesystem.ui.util.WarnCompleteCurrentPortsUser;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CompleteCurrentPortAction
extends AbstractPortAction {
    public static void completeCurrentPort(final IWorkspaceConnection workspace, final IComponent component, final boolean createPortLink, final IWorkbenchPart workbenchPart, final IOperationRunner runner) {
        final Shell shell = workbenchPart.getSite().getShell();
        boolean showContinueAcceptButton = false;
        try {
            showContinueAcceptButton = workspace.getAcceptQueueSize((IComponentHandle)component) > 0L;
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        final CompleteCurrentPortDialog dialog = new CompleteCurrentPortDialog(shell, createPortLink, showContinueAcceptButton);
        if (dialog.open() == 0) {
            String jobName = Messages.CompleteCurrentPortAction_JOB_NAME;
            final WarnCompleteCurrentPortsUser dilemmaHandler = new WarnCompleteCurrentPortsUser(shell);
            runner.enqueue(jobName, (Operation)new RepositoryOperation(workspace.teamRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    Display display;
                    ICompleteCurrentPatchOperation op = OperationFactory.getInstance().getCompleteCurrentPatchOperation((CompleteCurrentPatchDilemmaHandler)dilemmaHandler);
                    if (createPortLink) {
                        op.setFlags(1);
                    }
                    op.completeCurrentPatch(workspace, (IComponentHandle)component);
                    op.run(monitor);
                    if (dialog.isAllowAcceptFromMergeQueue() && dialog.isAcceptFromMergeQueue()) {
                        ProcessPendingPortsAction.processPendingPorts(workbenchPart, runner, workspace, component, false);
                    }
                    if ((display = shell.getDisplay()) != null) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!display.isDisposed()) {
                                    CompleteCurrentPortAction.closePortEditorIfNoPortsExist(workbenchPart, workspace, component);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof CurrentPortNode) {
            IComponentSyncContext context;
            IComponentSyncContext[] contexts;
            CurrentPortNode currentPortNode = (CurrentPortNode)object;
            isValid = true;
            IChangeSet portTarget = currentPortNode.getPortTargetChangeSet();
            if (portTarget != null && (contexts = ComponentSyncModel.getInstance().getComponentSyncContexts((IConnection)currentPortNode.getWorkspaceConnection(), (IComponentHandle)currentPortNode.getComponent())).length > 0 && (context = contexts[0]) != null) {
                for (Object activity : context.getOutgoingActivitySource().getActivities()) {
                    IChangeSet changeSet;
                    IOutgoingRemoteActivity outgoingActivity;
                    if (!(activity instanceof IOutgoingRemoteActivity) || !portTarget.sameItemId((IItemHandle)(outgoingActivity = (IOutgoingRemoteActivity)activity).getChangeSetHandle()) || (changeSet = outgoingActivity.getChangeSet()) == null || changeSet.changes().size() != 0) continue;
                    isValid = false;
                }
            }
        }
        action.setEnabled(isValid);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object object;
        if (selection.size() == 1 && (object = selection.getFirstElement()) instanceof CurrentPortNode) {
            CurrentPortOutputControl currentPortOutputControl;
            CurrentPortPage currentPortPage;
            CurrentPortNode currentPortNode = (CurrentPortNode)object;
            boolean createPortLink = true;
            IWorkbenchPart targetPart = this.getPart();
            PortEditor portEditor = (PortEditor)((Object)targetPart.getAdapter(PortEditor.class));
            if (portEditor != null && (currentPortPage = portEditor.getCurrentPortPage()) != null && (currentPortOutputControl = currentPortPage.getCurrentPortOutputControl()) != null) {
                createPortLink = currentPortOutputControl.isCreatePortLink();
            }
            CompleteCurrentPortAction.completeCurrentPort(currentPortNode.getWorkspaceConnection(), currentPortNode.getComponent(), createPortLink, this.getPart(), this.getOperationRunner());
        }
    }

    protected static class CompleteCurrentPortDialog
    extends TrayDialog {
        private boolean fCreatePortLink;
        private boolean fAllowAcceptFromMergeQueue;
        private Button fAcceptFromMergeQueueButton;
        private boolean fAcceptFromMergeQueue;

        public CompleteCurrentPortDialog(Shell shell, boolean createPortLink, boolean allowAcceptFromMergeQueue) {
            super(shell);
            this.fCreatePortLink = createPortLink;
            this.fAllowAcceptFromMergeQueue = allowAcceptFromMergeQueue;
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            this.fAcceptFromMergeQueue = store.getBoolean("com.ibm.team.filesystem.ide.ui.process_merge_queue_after_complete");
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        public boolean isAllowAcceptFromMergeQueue() {
            return this.fAllowAcceptFromMergeQueue;
        }

        public boolean isAcceptFromMergeQueue() {
            return this.fAcceptFromMergeQueue;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.CompleteCurrentPortAction_CONFIRM_DIALOG_TITLE);
            Rectangle shellBounds = newShell.getParent().getBounds();
            Point dialogSize = newShell.getSize();
            newShell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
        }

        protected Control createContents(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            parent.setLayout(this.getLayout());
            Composite composite = new Composite(parent, 0);
            Point defaultSpacing = LayoutConstants.getSpacing();
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(defaultSpacing.x * 2, defaultSpacing.y).applyTo(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            this.createDialogAndButtonArea(composite);
            return parent;
        }

        protected void createDialogAndButtonArea(Composite parent) {
            this.dialogArea = this.createDialogArea(parent);
            this.buttonBar = this.createButtonBar(parent);
            CompleteCurrentPortDialog.applyDialogFont((Control)parent);
        }

        protected Control createDialogArea(Composite parent) {
            String helpID;
            WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
            this.createMessageArea(parent);
            if (this.fAllowAcceptFromMergeQueue) {
                Composite composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                composite.setLayout((Layout)layout);
                GridData data = new GridData(1808);
                data.horizontalSpan = 2;
                composite.setLayoutData((Object)data);
                Label spacer = toolkit.createLabel(composite, null);
                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)spacer);
                this.fAcceptFromMergeQueueButton = toolkit.createButton(composite, Messages.CompleteCurrentPortAction_CONFIRM_DIALOG_ACCEPT_NEXT_BUTTON, 32);
                this.fAcceptFromMergeQueueButton.setSelection(this.fAcceptFromMergeQueue);
                this.fAcceptFromMergeQueueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (fAcceptFromMergeQueueButton.getSelection()) {
                            fAcceptFromMergeQueue = true;
                        } else {
                            fAcceptFromMergeQueue = false;
                        }
                    }
                });
                GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fAcceptFromMergeQueueButton);
            }
            if ((helpID = this.getHelpContextId()) != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpID);
            }
            return parent;
        }

        protected Control createMessageArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(768);
            composite.setLayoutData((Object)data);
            Image image = this.getSWTImage(4);
            if (image != null) {
                Label imageLabel = new Label(composite, 0);
                image.setBackground(imageLabel.getBackground());
                imageLabel.setImage(image);
                this.addAccessibleListeners(imageLabel, image);
                GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)imageLabel);
            }
            Label messageLabel = new Label(composite, 64);
            messageLabel.setText(this.fCreatePortLink ? Messages.CompleteCurrentPortAction_CONFIRM_DIALOG_MESSAGE_CREATE_LINK : Messages.CompleteCurrentPortAction_CONFIRM_DIALOG_MESSAGE);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel);
            return parent;
        }

        private Image getSWTImage(final int imageID) {
            Display display;
            Shell shell = this.getShell();
            if (shell == null || shell.isDisposed()) {
                shell = this.getParentShell();
            }
            if (shell == null || shell.isDisposed()) {
                display = Display.getCurrent();
                Assert.isNotNull((Object)display, (String)"The dialog should be created in UI thread");
            } else {
                display = shell.getDisplay();
            }
            final Image[] image = new Image[1];
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    image[0] = display.getSystemImage(imageID);
                }
            });
            return image[0];
        }

        private void addAccessibleListeners(Label label, Image image) {
            label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent event) {
                    String accessibleMessage = JFaceResources.getString((String)"question");
                    if (accessibleMessage == null) {
                        return;
                    }
                    event.result = accessibleMessage;
                }
            });
        }

        public String getHelpContextId() {
            if (this.fCreatePortLink) {
                return "com.ibm.team.filesystem.ide.ui.dialog_completeresultingchangesetwithlink";
            }
            return "com.ibm.team.filesystem.ide.ui.dialog_completeresultingchangeset";
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.CompleteCurrentPortAction_CONFIRM_DIALOG_OK_BUTTON, true);
            this.createButton(parent, 1, Messages.CompleteCurrentPortAction_CONFIRM_DIALOG_CANCEL_BUTTON, false);
        }

        public boolean close() {
            if (this.getReturnCode() == 0 && this.fAcceptFromMergeQueueButton != null) {
                IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                store.setValue("com.ibm.team.filesystem.ide.ui.process_merge_queue_after_complete", this.fAcceptFromMergeQueueButton.getSelection());
            }
            return super.close();
        }
    }
}

