/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractAutoResolvePortChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInCompareEditorAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IVersionableChange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class AutoResolveVersionableChangeAction
extends AbstractAutoResolvePortChangeAction {
    public static boolean isValidSelection(ISelection selection) {
        IStructuredSelection ss;
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() > 0) {
            boolean allValidObjects = true;
            for (Object object : ss.toList()) {
                if (!(object instanceof VersionableChangeNode)) {
                    allValidObjects = false;
                    break;
                }
                VersionableChangeNode node = (VersionableChangeNode)object;
                if (!node.isResolved() && !node.isDependentOnChange()) continue;
                allValidObjects = false;
                break;
            }
            isValid = allValidObjects;
        }
        return isValid;
    }

    public static void autoResolveVersionableChange(IStructuredSelection selection, final IWorkbenchPage page, final Shell shell, IOperationRunner runner) {
        final HashSet<VersionableChangeNode> allVersionableChangeNodes = new HashSet<VersionableChangeNode>(selection.size());
        for (Object object : selection.toList()) {
            if (!(object instanceof VersionableChangeNode)) continue;
            allVersionableChangeNodes.add((VersionableChangeNode)object);
        }
        if (allVersionableChangeNodes.size() > 0) {
            final HashMap versionableChangeNodeMap = new HashMap();
            for (VersionableChangeNode versionableChangeNode : allVersionableChangeNodes) {
                ArrayList<VersionableChangeNode> versionableChangeNodes;
                HashMap<UUID, ArrayList<VersionableChangeNode>> componentToPortMap;
                ITeamRepository repo = versionableChangeNode.getRepository();
                UUID workspaceUUID = versionableChangeNode.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                UUID componentUUID = versionableChangeNode.getComponent().getItemId();
                HashMap workspaceToComponentMap = (HashMap)versionableChangeNodeMap.get(repo);
                if (workspaceToComponentMap == null) {
                    workspaceToComponentMap = new HashMap();
                }
                if ((componentToPortMap = (HashMap<UUID, ArrayList<VersionableChangeNode>>)workspaceToComponentMap.get(workspaceUUID)) == null) {
                    componentToPortMap = new HashMap<UUID, ArrayList<VersionableChangeNode>>();
                }
                if ((versionableChangeNodes = (ArrayList<VersionableChangeNode>)componentToPortMap.get(componentUUID)) == null) {
                    versionableChangeNodes = new ArrayList<VersionableChangeNode>();
                }
                versionableChangeNodes.add(versionableChangeNode);
                componentToPortMap.put(componentUUID, versionableChangeNodes);
                workspaceToComponentMap.put(workspaceUUID, componentToPortMap);
                versionableChangeNodeMap.put(repo, workspaceToComponentMap);
            }
            String jobName = Messages.AutoResolveVersionableChangeAction_JOB_NAME;
            final UpdateCurrentPatchDilemmaHandler dilemmaHandler = AutoResolveVersionableChangeAction.getUpdateCurrentPortDilemmaHandler(shell);
            runner.enqueue(jobName, (Operation)new RepositoryOperation(versionableChangeNodeMap.keySet()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    int size = allVersionableChangeNodes.size();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10));
                    OpenVersionableChangeInCompareEditorAction.saveOpenCompareEditors(versionableChangeNodeMap, page, shell, (IProgressMonitor)progress.newChild(size));
                    ArrayList<VersionableChangeNode> compareEditorsToClose = new ArrayList<VersionableChangeNode>();
                    boolean failedToResolve = false;
                    for (Map.Entry repoToWorkspaceMapEntry : versionableChangeNodeMap.entrySet()) {
                        for (Map.Entry workspaceToComponentMap : ((Map)repoToWorkspaceMapEntry.getValue()).entrySet()) {
                            for (Map.Entry componentToVersionableChangesMap : ((Map)workspaceToComponentMap.getValue()).entrySet()) {
                                List versionableChangeNodes = (List)componentToVersionableChangesMap.getValue();
                                if (versionableChangeNodes.size() <= 0) continue;
                                IWorkspaceConnection workspaceConnection = ((VersionableChangeNode)versionableChangeNodes.get(0)).getWorkspaceConnection();
                                IComponent componentHandle = ((VersionableChangeNode)versionableChangeNodes.get(0)).getComponent();
                                IUpdateCurrentPatchOperation op = OperationFactory.getInstance().getUpdateCurrentPortOperation(dilemmaHandler);
                                op.setFileContentMerger(FileSystemResourcesPlugin.getConfiguredExternalFileContentMerger());
                                op.setContext(workspaceConnection, (IComponentHandle)componentHandle);
                                for (VersionableChangeNode node : versionableChangeNodes) {
                                    op.autoResolve(node.getVersionable(), null, true);
                                }
                                op.run((IProgressMonitor)progress.newChild(9));
                                ICurrentPatch currentPort = workspaceConnection.getCurrentPatch((IComponentHandle)componentHandle);
                                if (currentPort == null) continue;
                                for (VersionableChangeNode node : versionableChangeNodes) {
                                    IVersionableChange updatedChange = currentPort.getVersionableChange(node.getVersionableChange().getId());
                                    if (updatedChange == null) continue;
                                    if (updatedChange.isResolved()) {
                                        compareEditorsToClose.add(node);
                                        continue;
                                    }
                                    failedToResolve = true;
                                }
                            }
                        }
                    }
                    OpenVersionableChangeInCompareEditorAction.closeNonDirtyCompareEditors(compareEditorsToClose, page, shell);
                    if (failedToResolve) {
                        AutoResolveVersionableChangeAction.promptToIndicateFailureToAutoResolve(shell);
                    }
                    progress.done();
                }
            });
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(AutoResolveVersionableChangeAction.isValidSelection(selection));
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        AutoResolveVersionableChangeAction.autoResolveVersionableChange(selection, page, shell, this.getOperationRunner());
    }
}

