/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditor;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractPortAction
extends AbstractActionDelegate {
    public static void closePortEditorIfNoPortsExist(IWorkbenchPart workbenchPart, IWorkspaceConnection workspace, IComponent component) {
        try {
            if (workspace.getCurrentPatch((IComponentHandle)component) == null && workspace.getAcceptQueueSize((IComponentHandle)component) <= 0L) {
                PortEditor portEditor = (PortEditor)((Object)workbenchPart.getAdapter(PortEditor.class));
                PortEditorInput portEditorInput = portEditor.getPortEditorInput();
                if (portEditor != null && portEditorInput != null && portEditorInput.getWorkspace().equals((Object)workspace) && portEditorInput.getComponent().sameItemId((IItemHandle)component)) {
                    MessageDialogWithToggle dialog;
                    IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
                    boolean showDialog = store.getBoolean("com.ibm.team.filesystem.ide.ui.show_close_port_editor_dialog");
                    if (showDialog && (dialog = MessageDialogWithToggle.openInformation((Shell)workbenchPart.getSite().getShell(), (String)Messages.AbstractPortAction_CLOSE_PORT_EDITOR_DIALOG_TITLE, (String)NLS.bind((String)Messages.AbstractPortAction_CLOSE_PORT_EDITOR_DIALOG_MESSAGE, (Object)workspace.getName(), (Object)component.getName()), (String)Messages.AbstractPortAction_CLOSE_PORT_EDITOR_DIALOG_DO_NOT_SHOW, (boolean)false, null, null)).getReturnCode() == 0) {
                        store.setValue("com.ibm.team.filesystem.ide.ui.show_close_port_editor_dialog", !dialog.getToggleState());
                    }
                    portEditor.close(false);
                }
            }
        }
        catch (ComponentNotInWorkspaceException e) {
            StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
        }
    }

    public static void showRequestMergeOnUnloadedComponentDialog(VersionableChangeNode versionableChangeNode) {
        String title = Messages.AbstractPortAction_COMPONENT_NOT_LOADED_DIALOG_TITLE;
        String message = NLS.bind((String)Messages.AbstractPortAction_COMPONENT_NOT_LOADED_DIALOG_MESSAGE, (Object)versionableChangeNode.getVersionableType(false), (Object)versionableChangeNode.getName());
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        JFaceUtils.showMessageBlocking((String)title, (String)message, (int)2);
    }

    public static int getNumVersionables(Map<ITeamRepository, Map<UUID, Map<UUID, List<VersionableChangeNode>>>> versionableChangeNodeMap) {
        int num = 0;
        for (Map.Entry<ITeamRepository, Map<UUID, Map<UUID, List<VersionableChangeNode>>>> repoToWorkspaceMapEntry : versionableChangeNodeMap.entrySet()) {
            for (Map.Entry<UUID, Map<UUID, List<VersionableChangeNode>>> workspaceToComponentMap : repoToWorkspaceMapEntry.getValue().entrySet()) {
                for (Map.Entry<UUID, List<VersionableChangeNode>> componentToVersionableChangesMap : workspaceToComponentMap.getValue().entrySet()) {
                    num += componentToVersionableChangesMap.getValue().size();
                }
            }
        }
        return num;
    }
}

