/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MergeVersionableChangeAction;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractOpenVersionableChangeInCompareAction
extends AbstractPortAction {
    public static boolean shouldOpenIn3WayCompare(VersionableChangeNode versionableChangeNode) {
        return !versionableChangeNode.isAdded();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        boolean isEnabled = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            VersionableChangeNode versionableChangeNode;
            Object object = ss.getFirstElement();
            if (object instanceof ContentChangeDetailNode) {
                isEnabled = true;
            } else if (object instanceof VersionableChangeNode && (versionableChangeNode = (VersionableChangeNode)object).canOpenInCompare()) {
                isEnabled = true;
            }
        }
        action.setEnabled(isEnabled);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        VersionableChangeNode versionableChangeNode = null;
        ContentChangeDetailNode changeDetailNode = null;
        if (object instanceof ContentChangeDetailNode) {
            changeDetailNode = (ContentChangeDetailNode)object;
            versionableChangeNode = changeDetailNode.getParentNode();
        } else if (object instanceof VersionableChangeNode) {
            versionableChangeNode = (VersionableChangeNode)object;
            for (AbstractChangeDetailNode childNode : versionableChangeNode.getChildChangeDetailNodes()) {
                if (!(childNode instanceof ContentChangeDetailNode)) continue;
                changeDetailNode = (ContentChangeDetailNode)childNode;
                break;
            }
        }
        if (versionableChangeNode != null) {
            this.prepareToOpenInCompare(versionableChangeNode, changeDetailNode, page, shell);
        }
    }

    protected void prepareToOpenInCompare(final VersionableChangeNode versionableChangeNode, final ContentChangeDetailNode changeDetailNode, final IWorkbenchPage page, final Shell shell) {
        final IOperationRunner runner = this.getContext().getUserOperationRunner();
        runner.enqueue(this.getJobName(), (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
                IComponent component = versionableChangeNode.getComponent();
                IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
                if (model.getLocalSynchronizationManager().isShared((IWorkspaceHandle)workspace.getResolvedWorkspace(), (IComponentHandle)component)) {
                    IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)versionableChangeNode.getVersionable(), (IProgressMonitor)progress.newChild(50));
                    if (!(versionableChangeNode.isAdded() || versionableChangeNode.isDeleted() || shareable != null && shareable.exists((IProgressMonitor)progress.newChild(25)))) {
                        progress.setWorkRemaining(25);
                        AbstractOpenVersionableChangeInCompareAction.this.handleMissingLocalFile(versionableChangeNode, changeDetailNode, page, shell, runner, (IProgressMonitor)progress.newChild(25));
                        return;
                    }
                    progress.setWorkRemaining(50);
                    if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(25))) {
                        AbstractOpenVersionableChangeInCompareAction.this.showIgnoredVersionableDialog(versionableChangeNode);
                    }
                } else {
                    AbstractOpenVersionableChangeInCompareAction.this.showRequestCompareOnUnloadedComponentDialog(versionableChangeNode);
                    return;
                }
                AbstractOpenVersionableChangeInCompareAction.this.openInCompare(AbstractOpenVersionableChangeInCompareAction.this.getContext(), versionableChangeNode, AbstractOpenVersionableChangeInCompareAction.shouldOpenIn3WayCompare(versionableChangeNode), (IProgressMonitor)progress.newChild(25));
                progress.done();
            }
        });
    }

    protected abstract String getJobName();

    protected abstract String getUnloadedComponentMessage(VersionableChangeNode var1);

    protected abstract String getMissingFileMessage(VersionableChangeNode var1);

    protected abstract void openInCompare(UIContext var1, VersionableChangeNode var2, boolean var3, IProgressMonitor var4) throws FileSystemException, TeamRepositoryException;

    private void showRequestCompareOnUnloadedComponentDialog(VersionableChangeNode versionableChangeNode) {
        String title = Messages.AbstractOpenVersionableChangeInCompareAction_COMPONENT_NOT_LOADED_DIALOG_TITLE;
        String message = this.getUnloadedComponentMessage(versionableChangeNode);
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        JFaceUtils.showMessageBlocking((String)title, (String)message, (int)2);
    }

    protected void handleMissingLocalFile(VersionableChangeNode versionableChangeNode, ContentChangeDetailNode contentChangeDetailNode, IWorkbenchPage page, Shell shell, IOperationRunner runner, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean resolved = false;
        if (contentChangeDetailNode != null && contentChangeDetailNode.isResolved() || contentChangeDetailNode == null && versionableChangeNode.isResolved()) {
            resolved = true;
        }
        if (resolved) {
            String title = Messages.AbstractOpenVersionableChangeInCompareAction_MISSING_LOCAL_FILE_TITLE;
            String message = NLS.bind((String)Messages.AbstractOpenVersionableChangeInCompareAction_MISSING_LOCAL_FILE_MESSAGE, (Object)this.getMissingFileMessage(versionableChangeNode));
            String openButton = Messages.AbstractOpenVersionableChangeInCompareAction_OPEN_REMOTE_FILE_BUTTON;
            String cancelButton = Messages.AbstractOpenVersionableChangeInCompareAction_CANCEL_BUTTON;
            DialogUtil.pauseIfNeededBeforeShowingDialog();
            int code = JFaceUtils.showMessageButtonsBlocking((String)title, (String)message, (String[])new String[]{openButton, cancelButton}, (int)4, (int)0);
            if (code == 0) {
                this.openRemoteFile(versionableChangeNode, monitor);
            }
        } else {
            MergeVersionableChangeAction.mergeMissingResource(versionableChangeNode, page, shell, runner, monitor);
        }
    }

    protected void showIgnoredVersionableDialog(VersionableChangeNode versionableChangeNode) {
        String title = NLS.bind((String)Messages.AbstractOpenVersionableChangeInCompareAction_IGNORED_VERSIONABLE_DIALOG_TITLE, (Object)versionableChangeNode.getVersionableType(true));
        String message = NLS.bind((String)Messages.AbstractOpenVersionableChangeInCompareAction_IGNORED_VERSIONABLE_DIALOG_MESSAGE, (Object)versionableChangeNode.getVersionableType(false), (Object)versionableChangeNode.getName());
        DialogUtil.pauseIfNeededBeforeShowingDialog();
        JFaceUtils.showMessageBlocking((String)title, (String)message, (int)2);
    }

    private void openRemoteFile(VersionableChangeNode versionableChangeNode, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection workspace = versionableChangeNode.getWorkspaceConnection();
        IComponent component = versionableChangeNode.getComponent();
        ITeamRepository repo = workspace.teamRepository();
        IVersionableHandle versionableAfterStateHandle = versionableChangeNode.getAfterState();
        IVersionable versionableAfterState = null;
        if (versionableAfterStateHandle != null) {
            versionableAfterState = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(versionableAfterStateHandle, monitor);
        }
        FileState fileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionableChangeNode.getVersionable().getItemType(), versionableAfterState);
        WorkspaceNamespace nameSpace = WorkspaceNamespace.create((IWorkspaceConnection)workspace, (IComponentHandle)component);
        final FileItemWrapper fiw = new FileItemWrapper(fileState.getStateId(), "", (ItemNamespace)nameSpace);
        JFaceUtils.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                PartUtil.openEditor(AbstractOpenVersionableChangeInCompareAction.this.getContext(), fiw);
            }
        });
    }
}

