/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.operations.AbortCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAbortCurrentPatchOperation;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbstractPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ProcessPendingPortsAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnAbortPortsUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.AcceptQueueFlags;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class AbortCurrentPortAction
extends AbstractPortAction {
    public static void abortCurrentPort(final IWorkspaceConnection workspace, final IComponent component, final IWorkbenchPart workbenchPart, final IOperationRunner runner) {
        final Shell shell = workbenchPart.getSite().getShell();
        boolean hasSourceChangeSet = true;
        ICurrentPatch currentPath = workspace.getCurrentPatch((IComponentHandle)component);
        if (currentPath.getSource() != null && currentPath.getSource().getChangeSet() == null) {
            hasSourceChangeSet = false;
        }
        boolean showDiscardMergeQueueButton = false;
        try {
            showDiscardMergeQueueButton = workspace.getAcceptQueueSize((IComponentHandle)component) > 0L;
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        AbortCurrentPortDialog dialog = new AbortCurrentPortDialog(shell, hasSourceChangeSet, showDiscardMergeQueueButton);
        int exitCode = dialog.open();
        final int flags = dialog.getFlags();
        if (exitCode != 1 && AcceptQueueFlags.isValidForAbort((int)flags)) {
            String jobName = Messages.AbortCurrentPortAction_JOB_NAME;
            final AbortCurrentPatchDilemmaHandler dilemmaHandler = AbortCurrentPortAction.getAbortPortsDilemmaHandler(shell);
            runner.enqueue(jobName, (Operation)new RepositoryOperation(workspace.teamRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    IAbortCurrentPatchOperation op = OperationFactory.getInstance().getAbortCurrentPatchOperation(dilemmaHandler);
                    op.setFlags(flags);
                    op.abort(workspace, Arrays.asList(component));
                    op.run(monitor);
                    final Display display = shell.getDisplay();
                    if (display != null) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (flags != 0 && flags != 2) {
                                    try {
                                        if (workspace.getAcceptQueueSize((IComponentHandle)component) > 0L && ProcessPendingPortsAction.openProcessPendingPortsQuestion(shell)) {
                                            ProcessPendingPortsAction.processPendingPorts(workbenchPart, runner, workspace, component, false);
                                        }
                                    }
                                    catch (ComponentNotInWorkspaceException e) {
                                        StatusUtil.log((Object)this, (Throwable)e);
                                    }
                                }
                                if (!display.isDisposed()) {
                                    AbortCurrentPortAction.closePortEditorIfNoPortsExist(workbenchPart, workspace, component);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    protected static AbortCurrentPatchDilemmaHandler getAbortPortsDilemmaHandler(Shell shell) {
        return new WarnAbortPortsUser(UIContext.createShellContext((Shell)shell));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        boolean isValid = false;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (object = ss.getFirstElement()) instanceof CurrentPortNode) {
            isValid = true;
        }
        action.setEnabled(isValid);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object object;
        if (selection.size() == 1 && (object = selection.getFirstElement()) instanceof CurrentPortNode) {
            CurrentPortNode currentPortNode = (CurrentPortNode)object;
            AbortCurrentPortAction.abortCurrentPort(currentPortNode.getWorkspaceConnection(), currentPortNode.getComponent(), this.getPart(), this.getOperationRunner());
        }
    }

    protected static class AbortCurrentPortDialog
    extends MessageDialog {
        private static final String DIALOG_TITLE = Messages.AbortCurrentPortAction_DIALOG_TITLE;
        private static final String DISCARD_CURRENT_PORT_BUTTON_TEXT = Messages.AbortCurrentPortAction_DISCARD_CURRENT_PORT_BUTTON_TEXT;
        private static final String CANCEL_BUTTON_TEXT = Messages.AbortCurrentPortAction_CANCEL_BUTTON_TEXT;
        private static final String DIALOG_MESSAGE_HAS_CHANGE_SET_AS_SOURCE = Messages.AbortCurrentPortAction_DIALOG_MESSAGE;
        private static final String REQUEUE_CURRENT_PORT_BUTTON_TEXT = Messages.AbortCurrentPortAction_REQUEUE_CURRENT_PORT_BUTTON_TEXT;
        private static String[] fButtons = new String[]{DISCARD_CURRENT_PORT_BUTTON_TEXT, REQUEUE_CURRENT_PORT_BUTTON_TEXT, CANCEL_BUTTON_TEXT};
        private static int fDefaultIndex = 2;
        private static final String DIALOG_MESSAGE_HAS_PATCH_AS_SOURCE = Messages.AbortCurrentPortAction_DIALOG_MESSAGE_NO_SOURCE;
        private boolean fAllowDiscardMergeQueue;
        private Button fDiscardFromMergeQueueButton;
        public static final int CANCEL = 1;
        public static final int DISCARD_CURRENT_PORT = 2;
        public static final int DISCARD_CURRENT_PORT_AND_MERGE_QUEUE = 3;
        public static final int REQUEUE_CURRENT_PORT = 4;
        private int fFlags = 1;

        public AbortCurrentPortDialog(Shell shell, boolean hasSourceChangeSet, boolean allowDiscardMergeQueue) {
            super(shell, DIALOG_TITLE, null, hasSourceChangeSet ? DIALOG_MESSAGE_HAS_CHANGE_SET_AS_SOURCE : DIALOG_MESSAGE_HAS_PATCH_AS_SOURCE, 4, fButtons, fDefaultIndex);
            this.fAllowDiscardMergeQueue = allowDiscardMergeQueue;
        }

        public int open() {
            int exitCode = super.open();
            if (exitCode == -1) {
                return 1;
            }
            return exitCode;
        }

        protected Control createCustomArea(Composite parent) {
            if (this.fAllowDiscardMergeQueue) {
                WidgetToolkit toolkit = WidgetFactoryContext.forDialogBox().getToolkit();
                toolkit.createLabel(parent, null);
                this.fDiscardFromMergeQueueButton = toolkit.createButton(parent, Messages.AbortCurrentPortAction_DISCARD_MERGE_QUEUE_CHECKBOX, 32);
                this.fDiscardFromMergeQueueButton.setSelection(false);
                this.fDiscardFromMergeQueueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (fDiscardFromMergeQueueButton.getSelection()) {
                            this.getButton(1).setEnabled(false);
                        } else {
                            this.getButton(1).setEnabled(true);
                        }
                    }
                });
            }
            return null;
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 0: {
                    if (this.fDiscardFromMergeQueueButton != null && this.fDiscardFromMergeQueueButton.getSelection()) {
                        this.setReturnCode(3);
                        this.fFlags = 2;
                        break;
                    }
                    this.setReturnCode(2);
                    this.fFlags = 1;
                    break;
                }
                case 1: {
                    this.setReturnCode(4);
                    this.fFlags = 0;
                    break;
                }
                case 2: {
                    this.setReturnCode(1);
                    this.fFlags = -1;
                }
            }
            this.close();
        }

        public int getFlags() {
            return this.fFlags;
        }
    }
}

