/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.load;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadAsWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LoadAsAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean actionEnabled = true;
        List elements = ((IStructuredSelection)selection).toList();
        if (elements.size() == 1) {
            Set contexts = ComponentSyncUtil.getContexts((Collection)elements);
            for (IComponentSyncContext context : contexts) {
                if (!context.getOutgoingTeamPlace().isStream() && ComponentSyncUtil.allLocal((Collection)contexts)) continue;
                actionEnabled = false;
            }
        } else {
            actionEnabled = false;
        }
        action.setEnabled(actionEnabled);
    }

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final Object element = selection.getFirstElement();
        this.getOperationRunner().enqueue(Messages.CheckoutSelectedAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                WorkspaceComponentWrapper wrapper;
                IComponentSyncContext context;
                LoadAsWizardInput loadOp = null;
                if (element instanceof FolderItemWrapper) {
                    FolderItemWrapper folder = (FolderItemWrapper)((Object)element);
                    loadOp = LoadAsAction.this.createLoadInput(folder, problems, monitor);
                } else if (element instanceof ContributorPlaceComponentWrapper) {
                    ContributorPlaceComponentWrapper componentWrapper = (ContributorPlaceComponentWrapper)element;
                    loadOp = LoadAsAction.this.createLoadInput(componentWrapper, problems, monitor);
                } else if (element instanceof FileItemWrapper) {
                    FileItemWrapper file = (FileItemWrapper)((Object)element);
                    loadOp = LoadAsAction.this.createLoadInput(file, problems, monitor);
                } else if (element instanceof SymbolicLinkItemWrapper) {
                    SymbolicLinkItemWrapper link = (SymbolicLinkItemWrapper)((Object)element);
                    loadOp = LoadAsAction.this.createLoadInput(link, problems, monitor);
                } else if (element instanceof IComponentSyncContext && (context = (IComponentSyncContext)element).isLocal() && (wrapper = WorkspaceComponentWrapper.newWrapper(context.getWorkspaceSyncContext().getLocal(), context.getComponent())) instanceof ContributorPlaceComponentWrapper) {
                    ContributorPlaceComponentWrapper componentWrapper = (ContributorPlaceComponentWrapper)wrapper;
                    loadOp = LoadAsAction.this.createLoadInput(componentWrapper, problems, monitor);
                }
                if (loadOp != null) {
                    loadOp.load(shell, LoadAsAction.this.getOperationRunner());
                }
            }
        });
    }

    LoadAsWizardInput createLoadInput(ContributorPlaceComponentWrapper componentWrapper, IStatusCollector problems, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponent component = componentWrapper.getComponent();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.LoadAsAction_LoadComponentTaskName, (Object)component.getName()), (int)100);
        WorkspaceNamespace namespace = componentWrapper.getNamespace();
        IWorkspaceConnection connection = namespace.getWorkspaceConnection((IProgressMonitor)sub.newChild(50));
        List completeItems = connection.configuration((IComponentHandle)component).fetchCompleteItems(Collections.singletonList(component.getRootFolder()), (IProgressMonitor)sub.newChild(50));
        StateId folderItem = new StateId((IItemHandle)((IFolder)completeItems.get(0)));
        FolderItemWrapper folder = new FolderItemWrapper(folderItem, "", (ItemNamespace)namespace);
        LoadAsWizardInput loadOp = new LoadAsWizardInput(connection, component, new NamedSiloedItem(component, folder));
        return loadOp;
    }

    LoadAsWizardInput createLoadInput(AbstractFileSystemItemWrapper fileOrFolder, IStatusCollector problems, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection currConnection;
        WorkspaceNamespace workspaceNamespace;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.LoadAsAction_TaskName, (Object)fileOrFolder.getFQName()), (int)100);
        IWorkspaceConnection connection = null;
        ItemNamespace namespace = fileOrFolder.getWorkspace();
        ItemId componentId = null;
        IComponent component = null;
        if (namespace instanceof WorkspaceNamespace) {
            workspaceNamespace = (WorkspaceNamespace)namespace;
            componentId = workspaceNamespace.getComponentId();
            currConnection = workspaceNamespace.getWorkspaceConnection((IProgressMonitor)sub.newChild(50));
            if (currConnection.isStream()) {
                problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CheckoutSelectedAction_2));
                return null;
            }
        } else {
            if (namespace instanceof BaselineNamespace) {
                problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CheckoutSelectedAction_2));
                return null;
            }
            problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CheckoutSelectedAction_3));
            return null;
        }
        component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)workspaceNamespace.getRepository(), (ItemId)componentId, (IProgressMonitor)sub.newChild(50));
        connection = currConnection;
        LoadAsWizardInput loadOp = new LoadAsWizardInput(connection, component, NamedSiloedItem.createFor(component, fileOrFolder));
        return loadOp;
    }
}

