/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizard;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadWizardInput;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.NamedSiloedItem;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LoadAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.isEnablededFor(selection));
    }

    private boolean isEnablededFor(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            HashMap<UUID, HashSet<String>> selectedPaths = new HashMap<UUID, HashSet<String>>();
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                if (selected != null && Adapters.hasAdapter((Object)selected, ContributorPlaceWrapper.class)) {
                    return ss.size() == 1;
                }
                if (selected instanceof FolderItemWrapper) {
                    FolderItemWrapper folder = (FolderItemWrapper)((Object)selected);
                    UUID componentId = this.getComponentId(folder);
                    HashSet<String> componentPaths = (HashSet<String>)selectedPaths.get(componentId);
                    if (componentPaths == null) {
                        componentPaths = new HashSet<String>();
                        selectedPaths.put(componentId, componentPaths);
                    }
                    if (this.overlaps(folder.getFQName(), componentPaths)) {
                        return false;
                    }
                    componentPaths.add(folder.getFQName());
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private UUID getComponentId(FolderItemWrapper folder) {
        ItemNamespace workspace = folder.getWorkspace();
        if (workspace instanceof WorkspaceNamespace) {
            WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)workspace;
            return workspaceNamespace.getComponentId().getItemUUID();
        }
        return null;
    }

    private boolean overlaps(String testPath, Set<String> componentPaths) {
        for (String path : componentPaths) {
            if (!PathUtils.isParentFolder((String)testPath, (String)path) && !PathUtils.isParentFolder((String)path, (String)testPath)) continue;
            return true;
        }
        return false;
    }

    public void run(final Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element != null && Adapters.hasAdapter((Object)element, ContributorPlaceWrapper.class)) {
            final ContributorPlaceWrapper contributorPlace = (ContributorPlaceWrapper)((Object)Adapters.getAdapter((Object)element, ContributorPlaceWrapper.class));
            final IOperationRunner operationRunner = this.getOperationRunner();
            this.getOperationRunner().enqueue(Messages.CheckoutSelectedAction_0, (Operation)new RepositoryOperation(){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    LoadAction.checkout(shell, contributorPlace, operationRunner, monitor);
                }
            });
        } else if (element instanceof FolderItemWrapper) {
            final Object[] objects = selection.toArray();
            this.getOperationRunner().enqueue(Messages.CheckoutSelectedAction_0, (Operation)new RepositoryOperation(){

                /*
                 * WARNING - void declaration
                 */
                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    void var9_12;
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckoutSelectedAction_0, (int)100);
                    HashSet<NamedSiloedItem> initialSelection = new HashSet<NamedSiloedItem>();
                    IWorkspaceConnection connection = null;
                    IWorkspace workspace = null;
                    SubMonitor subProgress = sub.newChild(80);
                    subProgress.setWorkRemaining(objects.length);
                    Object[] objectArray = objects;
                    int n = objects.length;
                    boolean n2 = false;
                    while (var9_12 < n) {
                        Object o = objectArray[var9_12];
                        SubMonitor iterProgress = subProgress.newChild(1);
                        iterProgress.setWorkRemaining(100);
                        if (o instanceof FolderItemWrapper) {
                            FolderItemWrapper folder = (FolderItemWrapper)((Object)o);
                            ItemNamespace namespace = folder.getWorkspace();
                            ItemId componentId = null;
                            IComponent component = null;
                            if (namespace instanceof WorkspaceNamespace) {
                                WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)namespace;
                                componentId = workspaceNamespace.getComponentId();
                                IWorkspaceConnection currConnection = workspaceNamespace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(50));
                                if (currConnection.isStream()) {
                                    problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CheckoutSelectedAction_2));
                                    return;
                                }
                                IWorkspace currWorkspace = currConnection.getResolvedWorkspace();
                                component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)workspaceNamespace.getRepository(), (ItemId)componentId, (IProgressMonitor)iterProgress.newChild(50));
                                if (connection == null) {
                                    connection = currConnection;
                                    workspace = currWorkspace;
                                } else if (!currWorkspace.sameItemId(workspace)) {
                                    problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CheckoutSelectedAction_1));
                                    return;
                                }
                            } else {
                                if (namespace instanceof BaselineNamespace) {
                                    problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LoadAction_0));
                                    return;
                                }
                                problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CheckoutSelectedAction_3));
                                return;
                            }
                            if (component != null) {
                                initialSelection.add(new NamedSiloedItem(component, folder));
                            }
                        } else {
                            problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)NLS.bind((String)Messages.CheckoutSelectedAction_4, (Object)o.toString())));
                            return;
                        }
                        iterProgress.done();
                        ++var9_12;
                    }
                    subProgress.done();
                    ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
                    for (SiloedItemId siloedItemId : initialSelection) {
                        IComponentHandle handle = siloedItemId.getComponentHandle();
                        components.add(handle);
                    }
                    LoadWizardInput loadWizardInput = new LoadWizardInput((IConnection)connection, (Collection<? extends IComponentHandle>)components, (Set<NamedSiloedItem>)initialSelection, (IProgressMonitor)sub.newChild(20));
                    if (loadWizardInput.getLoadType() != 7) {
                        loadWizardInput.setLoadType(3);
                    }
                    loadWizardInput.refreshSelectedFolders((IProgressMonitor)sub.newChild(1));
                    LoadAction.checkout(shell.getDisplay(), shell, connection.getResolvedWorkspace(), loadWizardInput, LoadAction.this.getOperationRunner());
                }
            });
        } else {
            JFaceUtils.showMessage((String)Messages.CheckoutSelectedAction_5, (String)Messages.CheckoutSelectedAction_6, (int)4);
        }
    }

    public static void checkout(Shell shell, ContributorPlaceWrapper contributorPlace, IOperationRunner operationRunner, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IConnection connection = contributorPlace.getConnection((IProgressMonitor)progress.newChild(50));
        LoadWizardInput loadOp = new LoadWizardInput(connection, null, null, (IProgressMonitor)progress.newChild(50));
        LoadAction.checkout(shell.getDisplay(), shell, contributorPlace.getWorkspace(), loadOp, operationRunner);
    }

    public static void checkout(Display display, Shell shell, IWorkspaceConnection workspace, List<? extends IComponentHandle> components, IOperationRunner operationRunner, IProgressMonitor monitor) throws TeamRepositoryException {
        if (components.isEmpty()) {
            LoadAction.requestShowPendingView(workspace.getResolvedWorkspace());
        } else {
            LoadWizardInput loadOp = new LoadWizardInput((IConnection)workspace, components, null, monitor);
            LoadAction.checkout(display, shell, workspace.getResolvedWorkspace(), loadOp, operationRunner);
        }
    }

    private static void checkout(Display display, final Shell shell, final IWorkspace workspace, final LoadWizardInput loadOp, final IOperationRunner operationRunner) {
        SWTUtil.greedyExec((Display)display, (Control)shell, (Runnable)new Runnable(){

            @Override
            public void run() {
                loadOp.initialize();
                LoadWizard loadWizard = new LoadWizard(loadOp);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)loadWizard);
                dialog.addPageChangingListener((IPageChangingListener)loadWizard);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    LoadAction.requestShowPendingView(workspace);
                    loadOp.doLoad(operationRunner);
                }
            }
        });
    }

    public static void requestShowPendingView(IWorkspace workspace) {
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        manager.activate((IWorkspaceHandle)workspace);
        LocalWorkspaceChangesView.requestShowPendingView();
    }
}

