/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.file;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.internal.filesystem.ui.util.ShareablesUtil;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.FileSharingWizard;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.files.FileSharingWizardInput;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ShareFilesAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean enable = true;
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            IContainer foundParent = null;
            for (Object object : ss.toList()) {
                if (!enable) break;
                IContainer thisParent = null;
                if (object instanceof IResource) {
                    thisParent = ((IResource)object).getParent();
                } else if (object instanceof AbstractAdaptableRemoteResource) {
                    AbstractAdaptableRemoteResource remoteParent = ((AbstractAdaptableRemoteResource)object).getParent();
                    ILocation iLocation = thisParent = remoteParent == null ? null : remoteParent.getLocation();
                }
                if (thisParent == null) {
                    enable = false;
                    break;
                }
                if (foundParent == null) {
                    foundParent = thisParent;
                    continue;
                }
                if (foundParent.equals(thisParent)) continue;
                enable = false;
            }
        } else {
            enable = false;
        }
        action.setEnabled(enable);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List selectionList = selection.toList();
        ArrayList<IShareable> files = new ArrayList<IShareable>(selectionList.size());
        for (Object thisSel : selectionList) {
            IShareable thisShareable = null;
            if (thisSel instanceof IResource) {
                thisShareable = ShareablesUtil.getShareableWithoutSandbox((IResource)thisSel);
            } else if (thisSel instanceof AbstractAdaptableRemoteResource) {
                AbstractAdaptableRemoteResource remoteResource = (AbstractAdaptableRemoteResource)thisSel;
                thisShareable = this.getShareablesWithoutSandbox(remoteResource);
            }
            if (thisShareable == null) continue;
            files.add(thisShareable);
        }
        if (!files.isEmpty()) {
            ShareFilesAction.shareFiles(this.getContext(), new HashSet<IShareable>(files));
        }
    }

    public IShareable getShareablesWithoutSandbox(AbstractAdaptableRemoteResource remoteResource) {
        IShareable shareable = (IShareable)remoteResource.getAdapter(IShareable.class);
        AbstractAdaptableRemoteResource parent = remoteResource.getParent();
        if (parent == null) {
            return null;
        }
        if (shareable == null) {
            shareable = remoteResource.createShareableToShare();
        }
        return shareable;
    }

    public static void shareFiles(UIContext context, Set<IShareable> files) {
        try {
            FileSharingWizardInput input = new FileSharingWizardInput(files);
            FileSharingWizard shareWizard = new FileSharingWizard(input);
            WizardDialog dialog = new WizardDialog(context.getShell(), (IWizard)shareWizard);
            dialog.open();
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

