/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.file;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.WorkspaceContext;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandlerForVersionable;
import com.ibm.team.internal.filesystem.ui.views.history.entries.VersionableHistoryEntry;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFileNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewFolderNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesViewSymbolicLinkNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LockAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        this.getOperationRunner().enqueue(Messages.LockAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(selection.size() * 10));
                ILockOperation lockOperation = IOperationFactory.instance.getLockOperation((LockDilemmaHandler)new LockConfirmationHandlerForVersionable());
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemId itemId;
                    StructuralChangesViewNode file;
                    Object o = objectArray[n2];
                    if (o instanceof VersionableHistoryEntry) {
                        VersionableHistoryEntry historyEntry = (VersionableHistoryEntry)o;
                        AbstractFileSystemItemWrapper item = historyEntry.getTargetItem();
                        IItemContext sourceContext = historyEntry.getDynamicContext();
                        ItemNamespace sourceNamespace = null;
                        if (sourceContext != null && sourceContext instanceof WorkspaceContext) {
                            sourceNamespace = sourceContext.getNamespace();
                        }
                        lockOperation = LockAction.lock(lockOperation, (IVersionableHandle)item.getItem().toHandle(), item.getWorkspace(), sourceNamespace, (IProgressMonitor)sub.newChild(1), problems);
                    } else if (o instanceof StructuralChangesViewFileNode) {
                        file = (StructuralChangesViewFileNode)o;
                        itemId = ((FileChange)((StructuralChangesViewFileNode)file).getWrapper()).getItemId();
                        lockOperation = LockAction.lock(lockOperation, (IVersionableHandle)itemId.toHandle(), ((StructuralChangesViewFileNode)file).getNamespace(), (IProgressMonitor)sub.newChild(1), problems);
                    } else if (o instanceof StructuralChangesViewSymbolicLinkNode) {
                        file = (StructuralChangesViewSymbolicLinkNode)o;
                        itemId = ((FileChange)((StructuralChangesViewSymbolicLinkNode)file).getWrapper()).getItemId();
                        lockOperation = LockAction.lock(lockOperation, (IVersionableHandle)itemId.toHandle(), ((StructuralChangesViewSymbolicLinkNode)file).getNamespace(), (IProgressMonitor)sub.newChild(1), problems);
                    } else if (!(o instanceof StructuralChangesViewFolderNode) && o instanceof AbstractFileSystemItemWrapper) {
                        if (o instanceof FolderItemWrapper) {
                            return;
                        }
                        SubMonitor innerProgress = sub.newChild(1).setWorkRemaining(3);
                        ItemNamespace workspaceNamespace = null;
                        ItemNamespace streamNamespace = null;
                        AbstractFileSystemItemWrapper wrapper = (AbstractFileSystemItemWrapper)((Object)o);
                        IConnection connection = wrapper.getWorkspace().getConnection((IProgressMonitor)innerProgress.newChild(1));
                        if (!(connection instanceof IWorkspaceConnection)) {
                            problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_3));
                            return;
                        }
                        IWorkspaceConnection wc = (IWorkspaceConnection)connection;
                        if (wc.isStream()) {
                            streamNamespace = wrapper.getWorkspace();
                        } else {
                            workspaceNamespace = wrapper.getWorkspace();
                            IFlowEntry flowEntry = wc.getFlowTable().getCurrentDeliverFlow();
                            if (flowEntry == null || !(flowEntry.getFlowNode() instanceof IWorkspaceHandle)) {
                                problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_3));
                                return;
                            }
                            IWorkspaceHandle flowTargetHandle = (IWorkspaceHandle)flowEntry.getFlowNode();
                            ITeamRepository flowTargetRepository = flowEntry.getRemoteRepositoryURI() == null ? wc.teamRepository() : RepositoryUtils.getTeamRepository((String)flowEntry.getRemoteRepositoryURI(), (UUID)flowEntry.getRemoteRepositoryIdentifier());
                            if (flowTargetRepository == null) {
                                flowTargetRepository = wc.teamRepository();
                                problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_InaccessibleFlowTargetRepository));
                                return;
                            }
                            ItemId componentId = wrapper.getWorkspace().fetchComponentId((IProgressMonitor)innerProgress.newChild(1));
                            streamNamespace = ItemNamespace.getNamespace((ITeamRepository)flowTargetRepository, (IContextHandle)flowTargetHandle, (IComponentHandle)((IComponentHandle)componentId.toHandle()));
                        }
                        lockOperation = LockAction.lock(lockOperation, (IVersionableHandle)wrapper.getItem().toHandle(), streamNamespace, workspaceNamespace, (IProgressMonitor)innerProgress.newChild(1), problems);
                        innerProgress.done();
                    }
                    if (lockOperation == null) {
                        return;
                    }
                    ++n2;
                }
                if (lockOperation != null) {
                    lockOperation.run((IProgressMonitor)sub.newChild(selection.size() * 9));
                }
            }
        });
    }

    public static ILockOperation lock(ILockOperation lockOperation, IVersionableHandle versionableHandle, ItemNamespace namespace, IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
        return LockAction.lock(lockOperation, versionableHandle, namespace, null, monitor, problems);
    }

    public static ILockOperation lock(ILockOperation lockOperation, IVersionableHandle versionableHandle, ItemNamespace namespace, ItemNamespace sourceNamespace, IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        ItemId componentId = namespace.fetchComponentId((IProgressMonitor)sub.newChild(1));
        if (componentId.equals((Object)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE))) {
            problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_4));
            return null;
        }
        IConnection connection = namespace.getConnection((IProgressMonitor)sub.newChild(1));
        IConnection sourceConnection = null;
        if (sourceNamespace != null) {
            ItemId componentId2 = sourceNamespace.fetchComponentId((IProgressMonitor)sub.newChild(1));
            if (componentId2.equals((Object)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE))) {
                problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_4));
                return null;
            }
            sourceConnection = sourceNamespace.getConnection((IProgressMonitor)sub.newChild(1));
        }
        IWorkspaceConnection workspaceConnection = null;
        if (connection instanceof IWorkspaceConnection) {
            workspaceConnection = (IWorkspaceConnection)connection;
            if (!workspaceConnection.isStream()) {
                problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_3));
                return null;
            }
        } else {
            problems.reportProblem(FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.LockAction_3));
            return null;
        }
        IComponentHandle componentHandle = (IComponentHandle)componentId.toHandle();
        lockOperation.lock((IWorkspaceConnection)sourceConnection, workspaceConnection, componentHandle, versionableHandle);
        return lockOperation;
    }
}

