/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.file;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.operations.LoadFileRequest;
import com.ibm.team.filesystem.rcp.core.internal.operations.RestoreFileOperation;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnBackupUserWithConsole;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.client.internal.StateLocator;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class LoadFileAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        List<FileItemWrapper> wrappers = this.getWrappers(selection);
        HashSet<UUID> ids = new HashSet<UUID>();
        boolean duplicate = false;
        for (FileItemWrapper wrapper : wrappers) {
            if (ids.add(wrapper.getItem().getItemUUID())) continue;
            duplicate = true;
            break;
        }
        if (duplicate) {
            JFaceUtils.showMessageBlocking((String)Messages.LoadFileAction_sameItemErrorTitle, (String)Messages.LoadFileAction_sameItemErrorMessage, (int)1);
        } else {
            LoadFileAction.loadFile(this.getContext(), wrappers);
        }
    }

    private List<FileItemWrapper> getWrappers(IStructuredSelection selection) {
        ArrayList wrappers = NewCollection.arrayList();
        for (Object next : selection.toList()) {
            FileItemWrapper nextWrapper = (FileItemWrapper)((Object)Adapters.getAdapter(next, FileItemWrapper.class));
            if (nextWrapper != null) {
                wrappers.add(nextWrapper);
                continue;
            }
            if (!(next instanceof ChangeNode)) continue;
            ChangeNode node = (ChangeNode)next;
            ItemNamespace namespace = node.getNamespace();
            IVersionableHandle state = node.getState();
            if (state == null) continue;
            FileItemWrapper fiw = new FileItemWrapper(new StateId(state.getItemType(), state.getItemId(), state.getStateId()), "", namespace);
            wrappers.add(fiw);
        }
        return wrappers;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            action.setEnabled(!this.getWrappers(ss).isEmpty());
        }
    }

    private static Set<StateLocator<IVersionable>> getFileStates(List<FileItemWrapper> wrappers) {
        HashSet<StateLocator<IVersionable>> states = new HashSet<StateLocator<IVersionable>>();
        for (FileItemWrapper wrapper : wrappers) {
            states.add((StateLocator<IVersionable>)StateLocator.create((ITeamRepository)wrapper.getRepository(), (StateId)wrapper.getFileItem()));
        }
        return states;
    }

    private static IPathResolver getPathResolverFor(Collection<FileItemWrapper> wrappers) {
        HashSet<NamespaceSetId> snapshots = new HashSet<NamespaceSetId>();
        for (FileItemWrapper wrapper : wrappers) {
            snapshots.add(NamespaceSetId.create((ItemNamespace)wrapper.getWorkspace()));
        }
        ArrayList<Object> pathResolvers = new ArrayList<Object>();
        pathResolvers.add(CopyFileAreaPathResolver.create());
        for (SnapshotId snapshotId : snapshots) {
            pathResolvers.add(SnapshotPathResolver.create((SnapshotId)snapshotId));
        }
        FallbackPathResolver fallbackPathResolver = new FallbackPathResolver(pathResolvers);
        return fallbackPathResolver;
    }

    public static void loadFile(final UIContext context, final List<FileItemWrapper> wrappers) {
        context.getUserOperationRunner().enqueue(Messages.LoadFileAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor mainProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Set states = LoadFileAction.getFileStates(wrappers);
                IPathResolver pathResolver = LoadFileAction.getPathResolverFor(wrappers);
                Map fetchedStates = RepoFetcher.fetchItems((Collection)states, (FetchProfile)FetchProfile.createFullProfile(), (IProgressMonitor)mainProgress.newChild(wrappers.size()));
                SubMonitor loopProgress = mainProgress.newChild(20).setWorkRemaining(wrappers.size());
                RestoreFileOperation op = new RestoreFileOperation(pathResolver, (RestoreFileOperation.RestoreFileDilemmaHandler)new LoadDilemmaHandler(context));
                for (FileItemWrapper next : wrappers) {
                    SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
                    ItemId component = next.getWorkspace().fetchComponentId((IProgressMonitor)iterationProgress.newChild(100));
                    StateLocator nextState = StateLocator.create((ITeamRepository)next.getRepository(), (StateId)next.getFileItem());
                    IVersionable versionable = (IVersionable)fetchedStates.get(nextState);
                    if (!(versionable instanceof IFileItem)) continue;
                    IFileItem fileItem = (IFileItem)versionable;
                    op.requestRestore(fileItem, component, next.getRepository());
                }
                try {
                    op.run((IProgressMonitor)mainProgress.newChild(80));
                }
                catch (FileSystemException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                    ErrorDialog.openError((Shell)context.getShell(), null, null, (IStatus)FileSystemStatusUtil.getStatusFor((Throwable)e));
                }
            }
        });
    }

    private static IStatus getMostSevereStatus(Collection<IStatus> toCheck) {
        IStatus best = Status.OK_STATUS;
        for (IStatus next : toCheck) {
            if (next.getSeverity() < best.getSeverity()) continue;
            best = next;
        }
        return best;
    }

    private static void showErrors(final UIContext context, final Map<LoadFileRequest, IStatus> results) {
        final IStatus mostSevere = LoadFileAction.getMostSevereStatus(results.values());
        if (mostSevere.getSeverity() > 0) {
            context.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (results.size() == 1) {
                        LoadFileRequest wrapper = (LoadFileRequest)results.keySet().iterator().next();
                        IStatus reason = mostSevere;
                        if (reason.getSeverity() >= 4) {
                            MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.StandardLoadFileDilemmaHandler_0, (int)4, (String)NLS.bind((String)Messages.StandardLoadFileDilemmaHandler_1, (Object)wrapper.getPath().getFileName(), (Object)reason.getMessage()));
                        } else {
                            MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.StandardLoadFileDilemmaHandler_2, (IStatus)mostSevere);
                        }
                    } else if (mostSevere.getSeverity() >= 4) {
                        ArrayList statuses = new ArrayList();
                        statuses.addAll(results.values());
                        IStatus status = StatusUtil.newStatus((Object)this, (String)Messages.StandardLoadFileDilemmaHandler_4, statuses);
                        ErrorDialog.openError((Shell)context.getShell(), (String)Messages.StandardLoadFileDilemmaHandler_3, (String)Messages.StandardLoadFileDilemmaHandler_4, (IStatus)status);
                    } else {
                        MessageDialogFactory.showMessage((Shell)context.getShell(), (String)Messages.StandardLoadFileDilemmaHandler_5, (IStatus)mostSevere);
                    }
                }
            });
        }
    }

    private static class LoadDilemmaHandler
    extends RestoreFileOperation.RestoreFileDilemmaHandler {
        UIContext context;

        public LoadDilemmaHandler(UIContext context) {
            this.context = context;
        }

        public void loadCompleted(Map<LoadFileRequest, IStatus> results) {
            LoadFileAction.showErrors(this.context, results);
        }

        public int localChangesFound(List<ILocation> localChanges) {
            final int[] result = new int[1];
            this.context.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(context.getShell(), Messages.LoadAction_LocalChangesDialog_Title, null, Messages.LoadAction_LocalChangesDialog_Message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    result[0] = dialog.open();
                }
            });
            if (result[0] == 0) {
                return 0;
            }
            return 1;
        }

        public int restoreLocationNotFound(LoadFileRequest request, IStatus status) {
            return this.promptForLocation(request, Messages.LoadFileAction_RestoreLocationNotFoundDialogTitle, ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        }

        public int multipleValidLocationsFound(LoadFileRequest request, Collection<IShareable> shareables) {
            return this.promptForLocation(request, NLS.bind((String)Messages.LoadFileAction_1, (Object)request.getPath().toString()), shareables.iterator().next().getFullPath().getParent().toOSString());
        }

        private int promptForLocation(final LoadFileRequest request, final String message, final String filterPath) {
            final int[] result = new int[1];
            this.context.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = this.internalPromptForLocation(request, message, filterPath);
                }
            });
            return result[0];
        }

        private int internalPromptForLocation(LoadFileRequest request, String message, String filterPath) {
            FileDialog dialog = new FileDialog(this.context.getShell(), 8192);
            dialog.setText(message);
            IFileItem file = request.getFile();
            dialog.setFileName(file.getName());
            dialog.setFilterPath(filterPath);
            String result = dialog.open();
            if (result == null) {
                return 1;
            }
            request.setLocation((ILocation)new PathLocation((IPath)new Path(result)));
            return 0;
        }

        public BackupDilemmaHandler getBackupDilemmaHandler() {
            return new WarnBackupUserWithConsole(this.context.getShell(), Messages.LoadFileAction_0);
        }

        public ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler() {
            return new ChangePropertiesDilemmaHandler(){

                public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                    return 0;
                }
            };
        }
    }
}

