/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.file;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ide.ui.internal.editorfactory.SandboxEditorInputFactory;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.filesystem.ui.changes.AnnotateInput;
import com.ibm.team.filesystem.ui.editor.EditorTuple;
import com.ibm.team.filesystem.ui.editor.ISlowShareableAdapter;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.editor.RemoteFileEditorInput;
import com.ibm.team.filesystem.ui.operations.LiveAnnotateUtil;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.LocationPicker;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractVersionableHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.OperationManager;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension4;

public class LiveAnnotate
extends AbstractActionDelegate {
    private static ITextEditorExtension4 getEditorExtension(IEditorPart editor, IEditorInput input) {
        ITextEditorExtension4 ext = (ITextEditorExtension4)Adapters.getAdapter((Object)editor, ITextEditorExtension4.class);
        if (ext != null) {
            return ext;
        }
        if (editor instanceof MultiPageEditorPart) {
            MultiPageEditorPart mpep = (MultiPageEditorPart)editor;
            IEditorPart[] parts = mpep.findEditors(input);
            int i = 0;
            while (i < parts.length) {
                IEditorPart editorPart = parts[i];
                ext = (ITextEditorExtension4)Adapters.getAdapter((Object)editorPart, ITextEditorExtension4.class);
                if (ext != null) {
                    return ext;
                }
                ++i;
            }
        }
        return null;
    }

    public void run(final Shell shell, final IWorkbenchPage page, final IStructuredSelection selection) {
        final UIContext context = this.getContext();
        context.getUserOperationRunner().enqueue(Messages.LiveAnnotate_AnnotationJobName, new Operation(){

            public void run(IProgressMonitor progress, IStatusCollector problems) throws OperationFailedException {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)20);
                Object selectedItem = selection.getFirstElement();
                IShareable s = null;
                IResource resource = (IResource)Adapters.getAdapter((Object)selectedItem, IResource.class);
                if (resource == null) {
                    ISlowShareableAdapter adapter;
                    s = (IShareable)Adapters.getAdapter((Object)selectedItem, IShareable.class);
                    if (s == null && (adapter = (ISlowShareableAdapter)Adapters.getAdapter((Object)selectedItem, ISlowShareableAdapter.class)) != null) {
                        try {
                            s = adapter.resolveShareable((IProgressMonitor)monitor.newChild(1));
                        }
                        catch (TeamRepositoryException e) {
                            problems.reportException((Throwable)e);
                            return;
                        }
                    }
                } else if (resource.getType() == 1) {
                    s = (IShareable)resource.getAdapter(IShareable.class);
                }
                if (s != null) {
                    ShareableAnnotateOperation op = new ShareableAnnotateOperation(LiveAnnotate.this.getContext(), shell, page, s);
                    try {
                        FileItemWrapper fiw = HistoryViewUtil.getFileItemWrapper(s, (IProgressMonitor)monitor.newChild(19));
                        LiveAnnotate.doRun(LiveAnnotate.this.getContext(), op, fiw);
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                    return;
                }
                AnnotateInput ai = LiveAnnotate.adaptToAnnotateInput(selectedItem);
                if (ai != null) {
                    final AnnotateInput finalAi = ai;
                    if (ai.getNamespace().isEmpty()) {
                        ItemId componentId;
                        try {
                            componentId = finalAi.getNamespace().fetchComponentId((IProgressMonitor)monitor.newChild(1));
                        }
                        catch (TeamRepositoryException e) {
                            problems.reportException((Throwable)e);
                            return;
                        }
                        context.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LocationPicker.pickLocation(LiveAnnotate.this.getContext(), Messages.ShowHistoryAction_selectLocationDialogTitle, Messages.ShowHistoryAction_selectLocationDialogDescription, null, (ItemLocator<IComponent>)ItemLocator.create((ITeamRepository)finalAi.getNamespace().getRepository(), (ItemId)componentId), false, new IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult>(){

                                    public void setResult(ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult result) {
                                        if (result != null) {
                                            AnnotateInput newInput = new AnnotateInput(result.getItemNamespace(), finalAi.getChangeSet(), finalAi.getFileItem(), finalAi.getPath());
                                            LiveAnnotate.runWithAnnotateInput(context, newInput);
                                        }
                                    }
                                });
                            }
                        });
                        return;
                    }
                    LiveAnnotate.runWithAnnotateInput(context, ai);
                    return;
                }
                final IStatus errorMessage = StatusUtil.newStatus((Object)this, (int)1, (String)Messages.LiveAnnotate_cannotHandleInputErrorMessage);
                StatusUtil.log((IStatus)errorMessage);
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ErrorDialog.openError((Shell)shell, (String)Messages.LiveAnnotate_InvalidSelectionMessageTitle, null, (IStatus)errorMessage);
                    }
                });
            }
        });
    }

    private static void runWithAnnotateInput(UIContext context, AnnotateInput ai) {
        FileItemWrapper fiw = new FileItemWrapper(ai.getFileItem(), ai.getPath().toOSString(), ai.getNamespace());
        AnnotateInputAnnotateOperation op = new AnnotateInputAnnotateOperation(context, ai);
        LiveAnnotate.doRun(context, op, fiw);
    }

    private static void doRun(UIContext context, AbstractAnnotateOperation op, FileItemWrapper fiw) {
        if (fiw != null) {
            HistoryViewUtil.showHistory(context, AbstractVersionableHistoryViewInput.newVersionableHistoryViewInput(fiw));
        }
        context.getUserOperationRunner().enqueue(Messages.LiveAnnotate_AnnotationJobName, (Operation)op);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss;
        super.selectionChanged(action, selection);
        if (action.getActionDefinitionId() == null) {
            action.setActionDefinitionId("com.ibm.team.filesystem.ide.ui.command.annotate");
        }
        if ((ss = this.getStructuredSelection()).size() != 1) {
            action.setEnabled(false);
            return;
        }
        Object element = ss.getFirstElement();
        Object input = LiveAnnotate.adaptInput(element);
        action.setEnabled(input != null);
    }

    private static Object adaptInput(Object element) {
        Object input = null;
        if (element != null && (input = (AbstractHistoryViewInput)Adapters.getAdapter((Object)element, AbstractHistoryViewInput.class)) == null) {
            IResource resource = (IResource)Adapters.getAdapter((Object)element, IResource.class);
            input = (AbstractHistoryViewInput)Adapters.getAdapter((Object)resource, AbstractHistoryViewInput.class);
        }
        return input == null ? LiveAnnotate.adaptToAnnotateInput(element) : input;
    }

    private static AnnotateInput adaptToAnnotateInput(Object element) {
        FileItemWrapper fi;
        AnnotateInput ai = (AnnotateInput)Adapters.getAdapter((Object)element, AnnotateInput.class);
        if (ai == null && (fi = (FileItemWrapper)((Object)Adapters.getAdapter((Object)element, FileItemWrapper.class))) != null && !fi.getFileItem().equals((Object)StateId.getDeletedState((ItemId)fi.getItem()))) {
            ai = (AnnotateInput)Adapters.getAdapter((Object)((Object)fi), AnnotateInput.class);
        }
        if (ai != null && ai.getFileItem() != null && ai.getFileItem().isDeleted()) {
            ai = null;
        }
        return ai;
    }

    protected Object adaptEditorInput(IEditorInput input) {
        return LiveAnnotate.adaptInput(input);
    }

    private static abstract class AbstractAnnotateOperation
    implements Operation {
        private UIContext context;
        protected ItemNamespace namespace;
        StateId<IFileItem> fileItem;
        protected ItemId<IChangeSet> csh = ItemId.getNullItem((IItemType)IChangeSet.ITEM_TYPE);
        private ITextEditorExtension4 editor;

        protected AbstractAnnotateOperation(UIContext context) {
            this.context = context;
        }

        public ITextEditorExtension4 getEditor() {
            return this.editor;
        }

        protected IStatus runOp(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                ItemId<IChangeSet> changeSetId = this.csh;
                final RevisionInformation info = LiveAnnotateUtil.computeRevisions(this.namespace, this.fileItem, changeSetId, (IProgressMonitor)progress.newChild(40));
                final IEditorInput input = this.constructInput((IProgressMonitor)progress.newChild(30));
                final IContentType content = this.computeContentType(input, (IProgressMonitor)progress.newChild(30));
                this.context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (editor == null) {
                            if (editor == null) {
                                IEditorPart part = null;
                                try {
                                    part = PartUtil.openEditor(context.getPage(), input, null, content, true, false);
                                    FileItemWrapper fileItemWrapper = new FileItemWrapper(fileItem, "", namespace);
                                    HistoryViewUtil.showHistory(context, AbstractVersionableHistoryViewInput.newVersionableHistoryViewInput(fileItemWrapper));
                                }
                                catch (PartInitException e) {
                                    StatusUtil.log((Object)this, (Throwable)e);
                                }
                                editor = LiveAnnotate.getEditorExtension(part, input);
                            }
                            if (editor != null) {
                                this.registerListener();
                            }
                        }
                        if (editor != null) {
                            editor.showRevisionInformation(info, "org.eclipse.quickdiff.providers.JazzReferenceProvider");
                        }
                    }
                });
            }
            catch (TeamRepositoryException e) {
                return StatusUtil.newStatus((Object)this, (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private IContentType computeContentType(IEditorInput input, IProgressMonitor newChild) throws TeamRepositoryException {
            return ResourceUtil.getContentTypeFor((String)input.getName());
        }

        protected IEditorInput constructInput(IProgressMonitor monitor) throws TeamRepositoryException {
            return RemoteFileEditorInput.createInput(this.namespace.getRepository(), this.fileItem, this.namespace.getContext(monitor).getName(), monitor);
        }

        protected void registerListener() {
        }
    }

    private static class AnnotateInputAnnotateOperation
    extends AbstractAnnotateOperation {
        private AnnotateInput comparable;

        AnnotateInputAnnotateOperation(UIContext context, AnnotateInput comparable) {
            super(context);
            this.comparable = comparable;
        }

        public void run(IProgressMonitor monitor, IStatusCollector status) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.namespace = this.comparable.getNamespace();
            this.fileItem = this.comparable.getFileItem();
            this.csh = this.comparable.getChangeSet();
            status.reportProblem(this.runOp((IProgressMonitor)progress));
        }
    }

    private static class ShareableAnnotateOperation
    extends AbstractAnnotateOperation {
        private IShareable shareable;
        private boolean disposed;
        private ICopyFileAreaListener listener = new ICopyFileAreaListener(){

            public void change(ICopyFileAreaEvent[] events) {
                if (disposed) {
                    return;
                }
                int i = 0;
                while (i < events.length) {
                    IVersionableHandle v = events[i].getVersionable();
                    if (v != null && fileItem.getItemUUID().equals((Object)v.getItemId()) && !fileItem.getStateUUID().equals((Object)v.getStateId())) {
                        fileItem = new StateId((IItemHandle)v);
                        OperationManager.runOperation((String)Messages.LiveAnnotate_UpdatingLiveAnnotationJobName, (Operation)this);
                        break;
                    }
                    ++i;
                }
            }
        };
        private IPartListener2 partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == this.getEditor()) {
                    this.unregisterListener();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        };
        private Shell shell;
        private IWorkbenchPage page;

        ShareableAnnotateOperation(UIContext context, Shell shell, IWorkbenchPage page, IShareable shareable) {
            super(context);
            this.shell = shell;
            this.page = page;
            this.shareable = shareable;
        }

        public void run(IProgressMonitor reporter, IStatusCollector status) throws OperationFailedException {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)100);
                IShare share = this.shareable.getShare((IProgressMonitor)progress.newChild(1));
                if (share == null) {
                    return;
                }
                ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                ITeamRepository repository = RepositoryUtils.getTeamRepository((ISharingDescriptor)sharingDescriptor);
                this.namespace = CoreShareablesUtil.getNamespace((ITeamRepository)repository, (IContextHandle)sharingDescriptor.getConnectionHandle(), (IComponentHandle)sharingDescriptor.getComponent());
                IVersionableHandle remote = this.shareable.getRemote((IProgressMonitor)progress.newChild(1));
                if (remote == null) {
                    return;
                }
                this.fileItem = new StateId((IItemHandle)remote);
                IStatus result = this.runOp((IProgressMonitor)progress.newChild(95));
                status.reportProblem(result);
            }
            catch (TeamRepositoryException e) {
                throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }

        private void unregisterListener() {
            ((ITextEditor)this.getEditor()).getSite().getPage().removePartListener(this.partListener);
            FileSystemCore.getSharingManager().removeListener(this.listener);
        }

        @Override
        protected void registerListener() {
            FileSystemCore.getSharingManager().addListener(this.listener);
            ((ITextEditor)this.getEditor()).getSite().getPage().addPartListener(this.partListener);
        }

        @Override
        protected IEditorInput constructInput(IProgressMonitor monitor) throws TeamRepositoryException {
            EditorTuple editor = SandboxEditorInputFactory.getInstance().createEditorInput(this.shell, this.page, this.shareable);
            if (editor == null) {
                return super.constructInput(monitor);
            }
            return editor.getEditorInput();
        }
    }
}

