/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.file;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.LockConfirmationHandlerForVersionable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FSFileModificationValidator
extends FileModificationValidator {
    public IStatus validateEdit(IFile[] files, final FileModificationValidationContext context) {
        final List<IShareable> shareables = this.getReadOnlyShareables(files);
        if (shareables.size() == 0) {
            return Status.OK_STATUS;
        }
        if (context == null) {
            try {
                return this.acquireLocks(null, shareables, null);
            }
            catch (CoreException e) {
                return FileSystemStatusUtil.getStatusFor((Throwable)e);
            }
            catch (TeamRepositoryException e) {
                return FileSystemStatusUtil.getStatusFor((Throwable)e);
            }
            catch (OperationCanceledException e) {
                return Status.CANCEL_STATUS;
            }
        }
        Display display = Display.getCurrent();
        if (display == null) {
            final IStatus[] result = new IStatus[]{Status.OK_STATUS};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = FSFileModificationValidator.this.requestLockInUI(context, shareables);
                }
            });
            return result[0];
        }
        return this.requestLockInUI(context, shareables);
    }

    private List<IShareable> getReadOnlyShareables(IFile[] files) {
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable;
            IFile file = iFileArray[n2];
            if (file.isReadOnly() && (shareable = this.getShareable(file)) != null) {
                shareables.add(shareable);
            }
            ++n2;
        }
        return shareables;
    }

    private IShareable getShareable(IFile file) {
        Object adapted = file.getAdapter(IShareable.class);
        if (adapted instanceof IShareable) {
            return (IShareable)adapted;
        }
        return null;
    }

    private IStatus requestLockInUI(FileModificationValidationContext context, final List<IShareable> shareables) {
        try {
            final Shell shell = this.getShell(context);
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
            final IStatus[] result = new IStatus[]{Status.OK_STATUS};
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.FSFileModificationValidator_PROGRESS_MESSAGE, (int)(shareables.size() * 10));
                    try {
                        result[0] = FSFileModificationValidator.this.acquireLocks(shell, shareables, (IProgressMonitor)subMonitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return result[0];
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OperationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            return FileSystemStatusUtil.getStatusFor((Throwable)cause);
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
    }

    private Shell getShell(FileModificationValidationContext context) {
        IWorkbenchWindow window;
        if (context == null) {
            return null;
        }
        if (context.getShell() != null && context.getShell() instanceof Shell) {
            return (Shell)context.getShell();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        Display display = Display.getCurrent();
        if (display.isDisposed()) {
            return null;
        }
        return new Shell(display);
    }

    protected IStatus acquireLocks(final Shell shell, List<IShareable> readOnlyShareables, IProgressMonitor progress) throws CoreException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(readOnlyShareables.size() + 1));
        boolean canPrompt = shell != null;
        ILockOperation lockOperation = IOperationFactory.instance.getLockOperation((LockDilemmaHandler)(canPrompt ? new LockConfirmationHandlerForVersionable() : new LockDilemmaHandler(){

            public int incomingChangesToLockedFiles(Map<ITeamRepository, ? extends Collection<LockEntry>> locks) {
                return 0;
            }
        }));
        final ArrayList<IShareable> shareablesToLock = new ArrayList<IShareable>();
        HashMap<UUID, IWorkspaceConnection> workspaceHandleToFlowTargetConnection = new HashMap<UUID, IWorkspaceConnection>();
        HashMap<UUID, IWorkspaceConnection> workspaceHandleToConnection = new HashMap<UUID, IWorkspaceConnection>();
        for (IShareable shareable : readOnlyShareables) {
            SubMonitor innerProgress = monitor.newChild(1).setWorkRemaining(4);
            IVersionableHandle versionableHandle = shareable.getVersionable((IProgressMonitor)innerProgress);
            IShare share = shareable.getShare((IProgressMonitor)innerProgress);
            IContextHandle workspaceHandle = share.getSharingDescriptor().getConnectionHandle();
            IWorkspaceConnection defaultFlowConnection = (IWorkspaceConnection)workspaceHandleToFlowTargetConnection.get(workspaceHandle.getItemId());
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)workspaceHandleToConnection.get(workspaceHandle.getItemId());
            if (defaultFlowConnection == null && workspaceHandle instanceof IWorkspaceHandle) {
                UUID repositoryId = share.getSharingDescriptor().getRepositoryId();
                ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryId);
                if (repository != null) {
                    workspaceConnection = this.getWorkspaceConnection((IWorkspaceHandle)workspaceHandle, repository, (IProgressMonitor)innerProgress.newChild(1));
                    ConnectionDescriptor defaultCollaboration = FlowTableUtil.getDefaultOutgoingCollaborationDescriptor((IWorkspaceConnection)workspaceConnection);
                    if (defaultCollaboration != null && defaultCollaboration.connectionHandle instanceof IWorkspaceHandle) {
                        IWorkspaceHandle defaultFlowHandle = (IWorkspaceHandle)defaultCollaboration.connectionHandle;
                        defaultFlowConnection = this.getWorkspaceConnection(defaultFlowHandle, repository, (IProgressMonitor)innerProgress.newChild(1));
                    }
                    workspaceHandleToFlowTargetConnection.put(workspaceHandle.getItemId(), defaultFlowConnection);
                    workspaceHandleToConnection.put(workspaceHandle.getItemId(), workspaceConnection);
                }
            }
            if (defaultFlowConnection == null || !defaultFlowConnection.isStream()) continue;
            IComponentHandle compHandle = share.getSharingDescriptor().getComponent();
            lockOperation.lock(workspaceConnection, defaultFlowConnection, compHandle, versionableHandle);
            shareablesToLock.add(shareable);
        }
        if (!shareablesToLock.isEmpty()) {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            boolean prompt = canPrompt && store.getBoolean("com.ibm.team.filesystem.ide.ui.prompt_notify_before_lock");
            int code = 0;
            if (prompt) {
                if (shareablesToLock.size() == 1) {
                    String fileName = ((IShareable)shareablesToLock.get(0)).getLocalPath().getName();
                    code = JFaceUtils.showMessageButtonsBlocking((String)Messages.FSFileModificationValidator_DIALOG_ACQUIRE_LOCK_TITLE, (String)NLS.bind((String)Messages.FSFileModificationValidator_DIALOG_ACQUIRE_LOCK_MESSAGE, (Object)fileName), (String[])new String[]{Messages.FSFileModificationValidator_ACQUIRE_LOCK_BUTTON, Messages.FSFileModificationValidator_HIJACK_BUTTON, Messages.FSFileModificationValidator_CANCEL_BUTTON}, (int)6, (int)0);
                } else {
                    code = JFaceUtils.showMessageButtonsBlocking((String)Messages.FSFileModificationValidator_0, (String)NLS.bind((String)Messages.FSFileModificationValidator_1, (Object)shareablesToLock.size()), (String[])new String[]{Messages.FSFileModificationValidator_2, Messages.FSFileModificationValidator_3, Messages.FSFileModificationValidator_CANCEL_BUTTON}, (int)6, (int)0);
                }
                if (code == 2 || code == -1) {
                    return Status.CANCEL_STATUS;
                }
            }
            if (code == 0) {
                Throwable ex = null;
                try {
                    lockOperation.run((IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemException e) {
                    if (!canPrompt) {
                        throw e;
                    }
                    ex = e;
                }
                catch (TeamRepositoryException e) {
                    if (!canPrompt) {
                        throw e;
                    }
                    ex = e;
                }
                if (canPrompt && ex != null) {
                    StatusUtil.log((Object)((Object)this), (Throwable)ex);
                    final String errorMessage = ex.getLocalizedMessage();
                    final IStatus errorStatus = FileSystemStatusUtil.getStatusFor((Throwable)ex);
                    final int[] proceedCode = new int[]{1};
                    shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String message;
                            if (shareablesToLock.size() == 1) {
                                String fileName = ((IShareable)shareablesToLock.get(0)).getLocalPath().getName();
                                message = NLS.bind((String)Messages.FSFileModificationValidator_DIALOG_LOCK_MESSAGE, (Object)errorMessage, (Object)fileName);
                            } else {
                                message = NLS.bind((String)Messages.FSFileModificationValidator_4, (Object)errorMessage);
                            }
                            UnableToLockDialog dialog = new UnableToLockDialog(shell, Messages.FSFileModificationValidator_DIALOG_LOCK_TITLE, message, errorStatus);
                            proceedCode[0] = dialog.open();
                        }
                    });
                    if (proceedCode[0] == 1) {
                        return Status.CANCEL_STATUS;
                    }
                } else if (ex != null) {
                    return FileSystemStatusUtil.getStatusFor((Throwable)ex);
                }
            }
        }
        this.setWriteable(readOnlyShareables);
        return Status.OK_STATUS;
    }

    private IWorkspaceConnection getWorkspaceConnection(IWorkspaceHandle wsHandle, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection workspaceConnection = manager.getWorkspaceConnection(wsHandle, monitor);
        return workspaceConnection;
    }

    protected void setWriteable(List<IShareable> shareables) throws CoreException {
        for (IShareable shareable : shareables) {
            File localFile = (File)shareable.getAdapter(File.class);
            if (!localFile.exists()) continue;
            localFile.setWritable(true);
        }
    }

    public IStatus validateSave(IFile file) {
        if (file.isReadOnly()) {
            return super.validateSave(file);
        }
        return Status.OK_STATUS;
    }

    public static class UnableToLockDialog
    extends ErrorDialog {
        public UnableToLockDialog(Shell parentShell, String dialogTitle, String message, IStatus status) {
            super(parentShell, dialogTitle, message, status, 6);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createDetailsButton(parent);
        }
    }
}

