/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.feed;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ui.changes.FeedManagerConfigurer;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CreateSCMFeedAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        Object first = selection.getFirstElement();
        IContributorHandle contributorHandle = null;
        IContributor contributor = null;
        ITeamRepository repo = null;
        if (first instanceof ContributorWrapper) {
            ContributorWrapper wrapper = (ContributorWrapper)((Object)first);
            contributor = wrapper.getContributor();
            repo = wrapper.getRepository();
        } else if (first instanceof IContributorHandle) {
            contributorHandle = (IContributorHandle)first;
            repo = (ITeamRepository)contributorHandle.getOrigin();
            contributor = contributorHandle.hasFullState() ? (IContributor)contributorHandle.getFullState() : (IContributor)repo.itemManager().getSharedItemIfKnown((IItemHandle)contributorHandle);
        }
        final ITeamRepository finalRepo = repo;
        final IContributorHandle finalContributorHandle = contributorHandle;
        if (contributor == null && finalRepo != null && finalContributorHandle != null) {
            this.getOperationRunner().enqueue(Messages.CreateSCMFeedAction_0, (Operation)new RepositoryOperation(finalRepo){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    IContributor c = (IContributor)finalRepo.itemManager().fetchCompleteItem((IItemHandle)finalContributorHandle, 0, monitor);
                    CreateSCMFeedAction.registerChannel(c, finalRepo);
                }
            });
            return;
        }
        if (contributor != null && repo != null) {
            CreateSCMFeedAction.registerChannel(contributor, repo);
        }
    }

    private static void registerChannel(IContributor contributor, ITeamRepository repo) {
        try {
            FeedManagerConfigurer.registerChannel(contributor.getName(), contributor.getUserId(), repo.getRepositoryURI());
        }
        catch (URISyntaxException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CreateStreamFeedAction_ErrorConstructingURLError, (Throwable)e);
            JFaceUtils.showError(null, null, (IStatus)status);
            StatusUtil.log((IStatus)status);
        }
    }
}

