/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions.feed;

import com.ibm.team.feed.ui.FeedUI;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.ui.changes.FeedManagerConfigurer;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractCreateFeedAction
extends AbstractActionDelegate {
    public static final String DEFAULT_ENCODING = "UTF-8";

    protected void showFeed(IWorkbenchPage page, String repositoryURI, IItemHandle itemHandle, String providerIdentifier, String title, String description) {
        try {
            StringBuilder builder = FeedManagerConfigurer.getFeedServiceURL(repositoryURI);
            builder.append("provider=" + providerIdentifier);
            builder.append("&itemId=");
            builder.append(URLEncoder.encode(itemHandle.getItemId().getUuidValue(), DEFAULT_ENCODING));
            String urlString = builder.toString();
            URL url = new URL(urlString);
            FeedUI.openRecentItemView((IWorkbenchPage)page, (URL)url, (String)title, (String)description);
        }
        catch (URISyntaxException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CreateStreamFeedAction_ErrorConstructingURLError, (Throwable)e);
            JFaceUtils.showError(null, null, (IStatus)status);
            StatusUtil.log((IStatus)status);
        }
        catch (UnsupportedEncodingException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CreateStreamFeedAction_ErrorConstructingURLError, (Throwable)e);
            JFaceUtils.showError(null, null, (IStatus)status);
            StatusUtil.log((IStatus)status);
        }
        catch (MalformedURLException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor((int)4, (String)Messages.CreateStreamFeedAction_ErrorConstructingURLError, (Throwable)e);
            JFaceUtils.showError(null, null, (IStatus)status);
            StatusUtil.log((IStatus)status);
        }
    }
}

