/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ide.ui.internal.actions;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.ui.changes.actions.OpenLocalFileAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractOpenLocalFileAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        final UIContext context = this.getContext();
        this.getOperationRunner().enqueue(Messages.OpenLocalFileAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                final ArrayList<IShareable> shareables = new ArrayList<IShareable>(AbstractOpenLocalFileAction.this.getShareablesFor(selection, (IProgressMonitor)progress.newChild(50)));
                progress.setWorkRemaining(shareables.size());
                Iterator iShareables = shareables.iterator();
                while (iShareables.hasNext()) {
                    IShareable shareable = (IShareable)iShareables.next();
                    if (shareable.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FILE) continue;
                    iShareables.remove();
                }
                context.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!shareables.isEmpty()) {
                            for (IShareable shareable : shareables) {
                                OpenLocalFileAction.openLocalFile(context.getShell(), context.getPage(), shareable);
                            }
                        } else {
                            MessageDialog.openInformation((Shell)context.getShell(), (String)Messages.OpenLocalFileAction_100, (String)Messages.OpenLocalFileAction_200);
                        }
                    }
                });
            }
        });
    }

    protected abstract Collection<IShareable> getShareablesFor(IStructuredSelection var1, IProgressMonitor var2) throws FileSystemException, TeamRepositoryException;
}

