/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.internal.ide.java.ui.deliver;

import com.ibm.team.filesystem.internal.ide.java.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.filesystem.internal.ide.java.ui.deliver.Messages;
import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.ui.launcher.JUnitWorkbenchLaunchShortcut;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FailedTestsProblemResolutionDelegate
implements IAdvisorProblemResolutionDelegate {
    private static void errorDialog(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    return;
                }
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    return;
                }
                MessageDialog.openError((Shell)shell, (String)Messages.FailedTestsProblemResolutionDelegate_ERROR_DIALOG_TITLE, (String)msg);
            }
        });
    }

    private static IType findTypeInWorkspace(String typeName) throws CoreException {
        class ResultException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IType fType;

            public ResultException(IType type) {
                this.fType = type;
            }
        }
        String simpleName;
        char[][] qualifications;
        int dot = typeName.lastIndexOf(46);
        if (dot != -1) {
            qualifications = new char[][]{typeName.substring(0, dot).toCharArray()};
            simpleName = typeName.substring(dot + 1);
        } else {
            qualifications = null;
            simpleName = typeName;
        }
        char[][] typeNames = new char[][]{simpleName.toCharArray()};
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                throw new ResultException(match.getType());
            }
        };
        try {
            new SearchEngine().searchAllTypeNames((char[][])qualifications, (char[][])typeNames, SearchEngine.createWorkspaceScope(), requestor, 3, null);
        }
        catch (ResultException e) {
            return e.fType;
        }
        return null;
    }

    public boolean run(IAdvisorInfo problem, IProgressMonitor monitor) {
        IType type;
        String className = problem.getData();
        try {
            type = FailedTestsProblemResolutionDelegate.findTypeInWorkspace(className);
        }
        catch (CoreException e) {
            FailedTestsProblemResolutionDelegate.errorDialog(NLS.bind((String)Messages.FailedTestsProblemResolutionDelegate_EXCEPTION_LOCATING_CLASS_NAME, (Object)className));
            DefinitionsIdeUIPlugin.getDefault().log(e);
            return false;
        }
        if (type == null) {
            FailedTestsProblemResolutionDelegate.errorDialog(NLS.bind((String)Messages.FailedTestsProblemResolutionDelegate_UNABLE_TO_FIND_TEST_CLASS, (Object)className));
            return false;
        }
        IResource typeResource = type.getResource();
        if (typeResource == null) {
            FailedTestsProblemResolutionDelegate.errorDialog(NLS.bind((String)Messages.FailedTestsProblemResolutionDelegate_UNABLE_TO_FIND_RESOURCE_FOR_CLASS, (Object)className));
            return false;
        }
        IProject project = typeResource.getProject();
        if (project == null) {
            FailedTestsProblemResolutionDelegate.errorDialog(NLS.bind((String)Messages.FailedTestsProblemResolutionDelegate_UNABLE_TO_FIND_LAUNCHER_FOR_CLASS, (Object)className));
            return false;
        }
        Object shortcut = PluginRegistry.findModel((IProject)project) == null ? new JUnitLaunchShortcut() : new JUnitWorkbenchLaunchShortcut();
        Display.getDefault().asyncExec(new Runnable((JUnitLaunchShortcut)shortcut, type){
            private final /* synthetic */ JUnitLaunchShortcut val$shortcut;
            private final /* synthetic */ IType val$type;
            {
                this.val$shortcut = jUnitLaunchShortcut;
                this.val$type = iType;
            }

            @Override
            public void run() {
                this.val$shortcut.launch((ISelection)new StructuredSelection((Object)this.val$type), "run");
            }
        });
        return true;
    }

    public boolean mayBeApplicable(IAdvisorInfo info) {
        return true;
    }
}

