/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.util;

import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.repository.rcp.common.NullUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SubComponentUtil {
    public static FileChange getSubComponentInfoFile(Collection<FileChange> changes) {
        for (FileChange fileChange : changes) {
            if (fileChange == null || !fileChange.isSubcomponentChange()) continue;
            return fileChange;
        }
        return null;
    }

    public static List<String> extractComponentItemIds(FileState fileState, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DisposableInputStreamProvider fileBuffer = TemporaryOutputStream.createLocalBuffer((IInputStreamProvider)fileState.getContents(), (IProgressMonitor)progress.newChild(50));
        return SubComponentUtil.extractComponentItemIds(fileBuffer, (IProgressMonitor)progress.newChild(50));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> extractComponentItemIds(DisposableInputStreamProvider fileBuffer, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<String> componentIds = new ArrayList<String>();
        try {
            if (fileBuffer == null) return componentIds;
            InputStream inputStream = null;
            BufferedReader reader = null;
            try {
                block19: {
                    String nextLine;
                    block18: {
                        inputStream = fileBuffer.getInputStream((IProgressMonitor)progress.newChild(100));
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        reader = new BufferedReader(inputStreamReader);
                        nextLine = NullUtil.safeString((String)reader.readLine());
                        if (!true) break block18;
                        if (nextLine == null) return componentIds;
                        if (nextLine.isEmpty()) break block19;
                    }
                    do {
                        componentIds.add(nextLine);
                        nextLine = NullUtil.safeString((String)reader.readLine());
                        if (nextLine == null) return componentIds;
                    } while (!nextLine.isEmpty());
                }
                return componentIds;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            progress.done();
        }
    }
}

