/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.util;

import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import java.util.ArrayList;
import java.util.List;

public class PathMatcher {
    private static final String WILDCARD = "**";
    private final MatcherChain leadMatcher;
    private final List<MatcherChain> chains;
    private final String pattern;
    private final boolean anchorEnd;
    final int minSegments;

    protected PathMatcher(String pattern, MatcherChain leadMatcher, ArrayList<MatcherChain> chains, boolean anchorEnd) {
        this.pattern = pattern;
        this.leadMatcher = leadMatcher;
        this.chains = chains;
        this.anchorEnd = anchorEnd;
        int tmpMinSegments = 0;
        for (MatcherChain chain : chains) {
            tmpMinSegments += chain.chain.size();
        }
        if (leadMatcher != null) {
            tmpMinSegments += leadMatcher.chain.size();
        }
        this.minSegments = tmpMinSegments;
    }

    public static PathMatcher create(String matcher) {
        String[] split = matcher.split("(?<!\\\\)/");
        if (split.length == 0) {
            throw new IllegalArgumentException();
        }
        boolean anchorStart = false;
        int start = 0;
        if ("".equals(split[0])) {
            anchorStart = true;
            start = 1;
        }
        boolean anchorEnd = true;
        int end = split.length;
        if (WILDCARD.equals(split[end - 1])) {
            anchorEnd = false;
            --end;
        }
        ArrayList<MatcherChain> chains = new ArrayList<MatcherChain>(split.length);
        ArrayList<StringMatcher> currentChain = new ArrayList<StringMatcher>(split.length);
        int i = start;
        while (i < end) {
            if (WILDCARD.equals(split[i])) {
                if (!currentChain.isEmpty()) {
                    chains.add(new MatcherChain(currentChain));
                    currentChain = new ArrayList(split.length - i);
                }
            } else {
                currentChain.add(new StringMatcher(split[i], false, false));
            }
            ++i;
        }
        if (!currentChain.isEmpty()) {
            chains.add(new MatcherChain(currentChain));
        }
        MatcherChain leadMatcher = null;
        if (anchorStart) {
            leadMatcher = (MatcherChain)chains.remove(0);
        }
        return new PathMatcher(matcher, leadMatcher, chains, anchorEnd);
    }

    public boolean match(String ... segments) {
        if (this.minSegments > segments.length) {
            return false;
        }
        int segStart = 0;
        if (this.leadMatcher != null) {
            int i = 0;
            while (i < this.leadMatcher.chain.size()) {
                if (!this.leadMatcher.chain.get(i).match(segments[i])) {
                    return false;
                }
                ++i;
            }
            segStart = this.leadMatcher.chain.size() - 1;
        }
        boolean anchored = this.anchorEnd;
        int patternsRemaining = this.minSegments - segStart;
        int iSeg = segments.length - 1;
        int iChain = this.chains.size() - 1;
        while (iChain >= 0) {
            MatcherChain cur = this.chains.get(iChain);
            int iSegCandidate = iSeg;
            boolean anchoredCandidate = anchored;
            int iPattern = cur.chain.size() - 1;
            while (iSeg >= segStart) {
                if (cur.chain.get(iPattern).match(segments[iSegCandidate])) {
                    anchoredCandidate = false;
                    --iSegCandidate;
                    if (--iPattern >= 0) continue;
                    break;
                }
                iSegCandidate = --iSeg;
                iPattern = cur.chain.size() - 1;
                anchoredCandidate = anchored;
                if (!anchoredCandidate) continue;
                return false;
            }
            if (iPattern != -1) {
                return false;
            }
            iSeg = iSegCandidate;
            anchored = anchoredCandidate;
            patternsRemaining -= cur.chain.size();
            --iChain;
        }
        return true;
    }

    public String pattern() {
        return this.pattern;
    }

    private static class MatcherChain {
        final ArrayList<StringMatcher> chain;

        public MatcherChain(ArrayList<StringMatcher> chain) {
            this.chain = chain;
        }

        public String toString() {
            ArrayList<String> s = new ArrayList<String>(this.chain.size());
            for (StringMatcher matcher : this.chain) {
                s.add(matcher.getPattern());
            }
            return s.toString();
        }
    }
}

