/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IHierarchyNode;
import com.ibm.team.scm.common.IHierarchyResult;
import com.ibm.team.scm.common.internal.subcomponents.SubcomponentCommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ComponentHierarchyCompareResult {
    private Map<MoveResultKey, MovedComponentResult> moveResults = new HashMap<MoveResultKey, MovedComponentResult>();
    private IHierarchyResult<IHierarchyNode, IItemHandle> left;
    private IHierarchyResult<IHierarchyNode, IItemHandle> right;
    final Map<UUID, IItemHandle> leftComponentToElementMap = new HashMap<UUID, IItemHandle>();
    final Map<UUID, IComponentHandle> leftElementToComponentMap = new HashMap<UUID, IComponentHandle>();
    final Map<UUID, IItemHandle> rightComponentToElementMap = new HashMap<UUID, IItemHandle>();
    final Map<UUID, IComponentHandle> rightElementToComponentMap = new HashMap<UUID, IComponentHandle>();
    private Set<UUID> desiredLeafs;
    private Set<UUID> prunedComponentIds;

    private MovedComponentResult addMoveResult(IComponentHandle parent, IComponentHandle leftChild, Collection<IComponentHandle> newParents) {
        MoveResultKey key = new MoveResultKey(parent, leftChild);
        MovedComponentResult newResult = new MovedComponentResult(parent, leftChild, newParents);
        this.moveResults.put(key, newResult);
        return newResult;
    }

    public MovedComponentResult getMoveResult(IComponentHandle originalParent, IComponentHandle component) {
        MoveResultKey key = new MoveResultKey(originalParent, component);
        return this.moveResults.get(key);
    }

    public Set<UUID> getPrunedComponentIds() {
        return this.prunedComponentIds;
    }

    public ComponentHierarchyCompareResult(IHierarchyResult left, IHierarchyResult right, Set<UUID> desiredLeafs) {
        this.left = left;
        this.right = right;
        this.desiredLeafs = desiredLeafs;
        this.initialize();
    }

    public ComponentHierarchyCompareResult(IHierarchyResult left, IHierarchyResult right) {
        this(left, right, null);
    }

    private void initialize() {
        SubcomponentCommonUtils.visitHierarchy(this.left, (SubcomponentCommonUtils.IHierarchyVisitor)new SubcomponentCommonUtils.IHierarchyVisitor(){

            public boolean visit(IHierarchyNode node) {
                ComponentHierarchyCompareResult.this.leftComponentToElementMap.put(node.getComponentHandle().getItemId(), node.getElementHandle());
                ComponentHierarchyCompareResult.this.leftElementToComponentMap.put(node.getElementHandle().getItemId(), node.getComponentHandle());
                return true;
            }
        });
        SubcomponentCommonUtils.visitHierarchy(this.right, (SubcomponentCommonUtils.IHierarchyVisitor)new SubcomponentCommonUtils.IHierarchyVisitor(){

            public boolean visit(IHierarchyNode node) {
                ComponentHierarchyCompareResult.this.rightComponentToElementMap.put(node.getComponentHandle().getItemId(), node.getElementHandle());
                ComponentHierarchyCompareResult.this.rightElementToComponentMap.put(node.getElementHandle().getItemId(), node.getComponentHandle());
                return true;
            }
        });
        HashSet<UUID> rightComponentUUIDs = new HashSet<UUID>();
        for (IHierarchyNode iHierarchyNode : this.right.getRoots()) {
            rightComponentUUIDs.add(iHierarchyNode.getComponentHandle().getItemId());
        }
        for (IHierarchyNode iHierarchyNode : this.left.getRoots()) {
            UUID leftComponentUUID = iHierarchyNode.getComponentHandle().getItemId();
            if (rightComponentUUIDs.contains(leftComponentUUID)) continue;
            this.addMoveResult(null, iHierarchyNode.getComponentHandle(), this.calculateNewParents(leftComponentUUID));
        }
        for (Map.Entry entry : this.left.getParentToChildrenMap().entrySet()) {
            Collection rightChildrenElements;
            UUID leftParentElementId = (UUID)entry.getKey();
            Collection leftChildrenElements = (Collection)entry.getValue();
            IComponentHandle leftCoponentHandle = this.leftElementToComponentMap.get(leftParentElementId);
            rightComponentUUIDs.clear();
            IItemHandle equivalentParentElement = this.rightComponentToElementMap.get(leftCoponentHandle.getItemId());
            if (equivalentParentElement != null && (rightChildrenElements = (Collection)this.right.getParentToChildrenMap().get(equivalentParentElement.getItemId())) != null) {
                for (IItemHandle righChildElement : rightChildrenElements) {
                    IComponentHandle rightChildComponent = this.rightElementToComponentMap.get(righChildElement.getItemId());
                    rightComponentUUIDs.add(rightChildComponent.getItemId());
                }
            }
            for (IItemHandle leftChildElement : leftChildrenElements) {
                IComponentHandle leftChildComponent = this.leftElementToComponentMap.get(leftChildElement.getItemId());
                UUID leftComponentUUID = leftChildComponent.getItemId();
                if (rightComponentUUIDs.contains(leftComponentUUID)) continue;
                IComponentHandle parentComponent = this.leftElementToComponentMap.get(leftParentElementId);
                this.addMoveResult(parentComponent, leftChildComponent, this.calculateNewParents(leftComponentUUID));
            }
        }
        this.prunedComponentIds = this.prune(this.left, this.desiredLeafs);
    }

    private Collection<IComponentHandle> calculateNewParents(UUID leftComponentUUID) {
        IItemHandle leftElement;
        HashMap<UUID, IComponentHandle> newParents = new HashMap<UUID, IComponentHandle>();
        IItemHandle rightElement = this.rightComponentToElementMap.get(leftComponentUUID);
        if (rightElement == null) {
            return newParents.values();
        }
        Collection newParentCandidateElements = (Collection)this.right.getChildToParentsMap().get(rightElement.getItemId());
        if (newParentCandidateElements == null) {
            newParentCandidateElements = Collections.EMPTY_LIST;
        }
        if ((leftElement = this.leftComponentToElementMap.get(leftComponentUUID)) == null) {
            return newParents.values();
        }
        Collection oldParentElements = (Collection)this.left.getChildToParentsMap().get(leftElement.getItemId());
        if (oldParentElements == null) {
            oldParentElements = Collections.EMPTY_LIST;
        }
        for (IItemHandle newParentElement : newParentCandidateElements) {
            IComponentHandle newParentComponent = this.rightElementToComponentMap.get(newParentElement.getItemId());
            newParents.put(newParentComponent.getItemId(), newParentComponent);
        }
        for (IItemHandle oldParentElement : oldParentElements) {
            IComponentHandle oldParentComponent = this.leftElementToComponentMap.get(oldParentElement.getItemId());
            newParents.remove(oldParentComponent.getItemId());
        }
        return newParents.values();
    }

    private Set<UUID> prune(IHierarchyResult<IHierarchyNode, IItemHandle> left, Set<UUID> desiredLeafs) {
        if (desiredLeafs == null) {
            return null;
        }
        HashSet<UUID> result = new HashSet<UUID>();
        HashSet<UUID> visited = new HashSet<UUID>();
        if (!desiredLeafs.isEmpty()) {
            for (UUID leaf : desiredLeafs) {
                IItemHandle element = this.leftComponentToElementMap.get(leaf);
                if (element == null) continue;
                UUID leafElementId = element.getItemId();
                this.visitComponent(leafElementId, left, result, visited);
            }
        }
        HashSet<UUID> newResult = new HashSet<UUID>(result.size());
        for (UUID elementId : result) {
            newResult.add(this.leftElementToComponentMap.get(elementId).getItemId());
        }
        return newResult;
    }

    private void visitComponent(UUID element, IHierarchyResult<IHierarchyNode, IItemHandle> left, Set<UUID> result, Set<UUID> visited) {
        Collection parents = (Collection)left.getChildToParentsMap().get(element);
        if (parents != null && !visited.contains(element)) {
            visited.add(element);
            for (IItemHandle parent : parents) {
                this.visitComponent(parent.getItemId(), left, result, visited);
            }
        }
        result.addAll(visited);
        visited.clear();
    }

    public IHierarchyResult getLeftHierarchy() {
        return this.left;
    }

    private class MoveResultKey {
        private IComponentHandle parent;
        private IComponentHandle child;

        private MoveResultKey(IComponentHandle parent, IComponentHandle child) {
            this.parent = parent;
            this.child = child;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parent == null ? 0 : this.parent.getItemId().hashCode());
            result = 31 * result + (this.child == null ? 0 : this.child.getItemId().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MoveResultKey other = (MoveResultKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.parent == null ? other.parent != null : !this.parent.sameItemId((IItemHandle)other.parent)) {
                return false;
            }
            return !(this.child == null ? other.child != null : !this.child.sameItemId((IItemHandle)other.child));
        }

        private ComponentHierarchyCompareResult getOuterType() {
            return ComponentHierarchyCompareResult.this;
        }
    }

    public class MovedComponentResult {
        private IComponentHandle child;
        private IComponentHandle originalParent;
        private Collection<IComponentHandle> newParents;

        private MovedComponentResult(IComponentHandle originaoParent, IComponentHandle child, Collection<IComponentHandle> newParents) {
            this.child = child;
            this.originalParent = originaoParent;
            this.newParents = newParents;
        }

        public IItemHandle getComponent() {
            return this.child;
        }

        public IItemHandle getOriginalParent() {
            return this.originalParent;
        }

        public Collection<IComponentHandle> getNewParents() {
            return this.newParents;
        }
    }
}

