/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.util;

import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.List;

public class ChangeSetUtil {
    public static List<StateId<IVersionable>> getBeforeStates(IChange change) {
        ArrayList<StateId<IVersionable>> result = new ArrayList<StateId<IVersionable>>();
        result.add(ChangeSetUtil.adaptState(change, change.beforeState()));
        List mergeStates = change.mergeStates();
        for (IVersionableHandle handle : mergeStates) {
            result.add((StateId<IVersionable>)ChangeSetUtil.adaptState(change, handle));
        }
        return result;
    }

    public static StateId<IVersionable> getLastMergeState(IChange change) {
        if (change.mergeStates().isEmpty()) {
            return ChangeSetUtil.adaptState(change, change.beforeState());
        }
        IVersionableHandle handle = (IVersionableHandle)change.mergeStates().get(change.mergeStates().size() - 1);
        return ChangeSetUtil.adaptState(change, handle);
    }

    public static StateId<IVersionable> getBeforeState(IChange change) {
        return ChangeSetUtil.adaptState(change, change.beforeState());
    }

    public static StateId<IVersionable> getAfterState(IChange change) {
        return ChangeSetUtil.adaptState(change, change.afterState());
    }

    public static ItemId<IComponent> getComponent(IChangeSet changeSet) {
        return ItemUtil.getComponent(changeSet.getComponent());
    }

    public static ItemId getItem(IChange nextChange) {
        return new ItemId((IItemHandle)nextChange.item());
    }

    public static IChange getChangeFor(IChangeSet change, ItemId item) {
        for (IChange next : change.changes()) {
            if (!next.item().getItemId().equals((Object)item.getItemUUID())) continue;
            return next;
        }
        return null;
    }

    public static ItemId<IChangeSet> getChangeSet(IChangeSetHandle changeSet) {
        if (changeSet == null) {
            return ItemId.getNullItem((IItemType)IChangeSet.ITEM_TYPE);
        }
        return new ItemId((IItemHandle)changeSet);
    }

    public static ItemId<IContributor> getAuthor(IChangeSet changeSet) {
        return ItemId.create((IItemHandle)changeSet.getAuthor());
    }

    static StateId adaptState(IChange change, IVersionableHandle handle) {
        if (handle == null) {
            return new StateId(change.item().getItemType(), change.item().getItemId(), StateId.STATE_DELETED);
        }
        return new StateId((IItemHandle)handle);
    }
}

