/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.rest.debug.core.impl;

import com.ibm.team.filesystem.common.internal.rest.debug.core.DebugRestClientDTOPackage;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeMethodDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeRepoDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeRootDTO;
import com.ibm.team.filesystem.common.internal.rest.debug.core.MetronomeServiceDTO;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class MetronomeRootDTOImpl
extends EObjectImpl
implements MetronomeRootDTO {
    protected int ALL_FLAGS = 0;
    protected EList repos;
    private static final String NL = System.getProperty("line.separator");

    protected MetronomeRootDTOImpl() {
    }

    protected EClass eStaticClass() {
        return DebugRestClientDTOPackage.Literals.METRONOME_ROOT_DTO;
    }

    @Override
    public List getRepos() {
        if (this.repos == null) {
            this.repos = new EObjectResolvingEList.Unsettable(MetronomeRepoDTO.class, (InternalEObject)this, 0);
        }
        return this.repos;
    }

    @Override
    public void unsetRepos() {
        if (this.repos != null) {
            ((InternalEList.Unsettable)this.repos).unset();
        }
    }

    @Override
    public boolean isSetRepos() {
        return this.repos != null && ((InternalEList.Unsettable)this.repos).isSet();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getRepos();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getRepos().clear();
                this.getRepos().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetRepos();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetRepos();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public MetronomeMethodDTO getMethod(String uri, String methodPath) {
        int lastDot = methodPath.lastIndexOf(46);
        if (lastDot < 0) {
            throw new IllegalArgumentException();
        }
        String type = methodPath.substring(0, lastDot);
        MetronomeServiceDTO service = this.getService(uri, type);
        if (service == null) {
            return null;
        }
        String called = methodPath.substring(lastDot + 1, methodPath.length());
        for (MetronomeMethodDTO candidate : service.getMethods()) {
            if (!called.equals(candidate.getName())) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public MetronomeServiceDTO getService(String uri, String typePath) {
        MetronomeRepoDTO repo = null;
        for (Object candidate : this.getRepos()) {
            if (!uri.equals(candidate.getUri())) continue;
            repo = candidate;
            break;
        }
        if (repo == null) {
            return null;
        }
        for (Object candidate : repo.getServices()) {
            if (!typePath.equals(candidate.getName())) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public long getMethodCallCount(String uri, String path) {
        MetronomeMethodDTO method = this.getMethod(uri, path);
        if (method == null) {
            return 0L;
        }
        return method.getCallCount();
    }

    @Override
    public long getMethodTime(String uri, String path) {
        MetronomeMethodDTO method = this.getMethod(uri, path);
        if (method == null) {
            return 0L;
        }
        return method.getElapsedTime();
    }

    @Override
    public long getServiceCallCount(String uri, String path) {
        MetronomeServiceDTO service = this.getService(uri, path);
        if (service == null) {
            return 0L;
        }
        return service.getCallCount();
    }

    @Override
    public long getServiceTime(String uri, String path) {
        MetronomeServiceDTO service = this.getService(uri, path);
        if (service == null) {
            return 0L;
        }
        return service.getElapsedTime();
    }

    @Override
    public void tabulate(Writer onto) throws IOException {
        TreeMap<String, MetronomeRepoDTO> repos = new TreeMap<String, MetronomeRepoDTO>(String.CASE_INSENSITIVE_ORDER);
        for (MetronomeRepoDTO repo : this.getRepos()) {
            String name = String.valueOf(repo.getUri()) + repo.getRepoId();
            repos.put(name, repo);
        }
        for (MetronomeRepoDTO repo : repos.values()) {
            onto.write(repo.getUri());
            onto.write(" (");
            onto.write(repo.getRepoId());
            onto.write(")");
            onto.write(NL);
            TreeMap<String, MetronomeServiceDTO> svcs = new TreeMap<String, MetronomeServiceDTO>();
            for (MetronomeServiceDTO svc : repo.getServices()) {
                svcs.put(svc.getName(), svc);
            }
            for (MetronomeServiceDTO svc : svcs.values()) {
                onto.write(" ");
                onto.write(svc.getName());
                onto.write(" ");
                onto.write(Long.toString(svc.getCallCount()));
                onto.write(", ");
                onto.write(Long.toString(svc.getElapsedTime()));
                onto.write("ms");
                onto.write(NL);
                TreeMap<String, MetronomeMethodDTO> methods = new TreeMap<String, MetronomeMethodDTO>();
                for (MetronomeMethodDTO m : svc.getMethods()) {
                    methods.put(m.getName(), m);
                }
                for (MetronomeMethodDTO m : methods.values()) {
                    onto.write("  ");
                    onto.write(m.getName());
                    onto.write(" ");
                    onto.write(Long.toString(m.getCallCount()));
                    onto.write(", ");
                    onto.write(Long.toString(m.getElapsedTime()));
                    onto.write("ms");
                    onto.write(NL);
                }
            }
        }
    }
}

