/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.process.config;

import com.ibm.team.filesystem.common.internal.process.ComponentMatchBlock;
import com.ibm.team.filesystem.common.internal.process.config.ComponentScopedAdvisorConfig;
import com.ibm.team.scm.common.internal.process.PCD_defaultValue;
import com.ibm.team.scm.common.internal.process.PCD_mayBeNull;
import com.ibm.team.scm.common.internal.process.PCD_serializationName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RestrictMimeTypeEncodingAdvisorConfig
extends ComponentScopedAdvisorConfig {
    @PCD_mayBeNull
    public ComponentMatchBlock components = new ComponentMatchBlock();
    @PCD_mayBeNull
    public MimeTypeBlock mimetypes = new MimeTypeBlock();
    @PCD_mayBeNull
    public EncodingBlock encodings = new EncodingBlock();

    @Override
    public ComponentMatchBlock getComponentMatchBlock() {
        return this.components;
    }

    @Override
    public void setComponentMatchBlock(ComponentMatchBlock block) {
        this.components = block;
    }

    public boolean isAllowMimeTypes() {
        return this.mimetypes.allow;
    }

    public void setAllowMimeTypes(boolean selection) {
        this.mimetypes.allow = selection;
    }

    public boolean isIncludeMimeTypes() {
        return this.mimetypes.include;
    }

    public void setIncludeMimeTypes(boolean selection) {
        this.mimetypes.include = selection;
    }

    public void setIncludeEncodings(boolean selection) {
        this.encodings.include = selection;
    }

    public boolean isIncludeEncodings() {
        return this.encodings.include;
    }

    public void setAllowEncodings(boolean selection) {
        this.encodings.allow = selection;
    }

    public boolean isAllowEncodings() {
        return this.encodings.allow;
    }

    public Collection<String> getEncodings() {
        ArrayList<String> result = new ArrayList<String>(this.encodings.encodings.size());
        for (Encoding encoding : this.encodings.encodings) {
            result.add(encoding.name);
        }
        return result;
    }

    public Collection<String> getMimeTypes() {
        ArrayList<String> result = new ArrayList<String>(this.mimetypes.mimetypes.size());
        for (MimeType mimetype : this.mimetypes.mimetypes) {
            result.add(mimetype.name);
        }
        return result;
    }

    public void setMimeTypes(List<String> mimeTypes) {
        this.mimetypes.mimetypes.clear();
        for (String string : mimeTypes) {
            this.mimetypes.mimetypes.add(new MimeType(string));
        }
    }

    public void setEncodings(List<String> encodings) {
        this.encodings.encodings.clear();
        for (String string : encodings) {
            this.encodings.encodings.add(new Encoding(string));
        }
    }

    private boolean matchMimeType(Collection<String> mimeTypes, String fileMimeType) {
        for (String mimeType : mimeTypes) {
            Pattern r;
            Matcher m;
            if (mimeType.startsWith("*")) {
                mimeType = ".+" + mimeType.substring(1);
            }
            if (mimeType.startsWith("?")) {
                mimeType = ".?" + mimeType.substring(1);
            }
            if (!(m = (r = Pattern.compile(mimeType, 2)).matcher(fileMimeType)).find()) continue;
            return true;
        }
        return false;
    }

    private boolean matchEncoding(Collection<String> encodings, String fileEncoding) {
        for (String encoding : encodings) {
            if (!encoding.equalsIgnoreCase(fileEncoding)) continue;
            return true;
        }
        return false;
    }

    public boolean isMimeTypeAllowed(String fileMimeType) {
        if (!this.isIncludeMimeTypes()) {
            return true;
        }
        Collection<String> mt = this.getMimeTypes();
        if (mt.isEmpty()) {
            return true;
        }
        boolean matchMimeType = this.matchMimeType(mt, fileMimeType);
        if (this.isAllowMimeTypes()) {
            return matchMimeType;
        }
        return !matchMimeType;
    }

    public boolean isEncodingAllowed(String fileEncoding) {
        if (!this.isIncludeEncodings()) {
            return true;
        }
        Collection<String> e = this.getEncodings();
        if (e.isEmpty()) {
            return true;
        }
        boolean matchesEncoding = this.matchEncoding(e, fileEncoding);
        if (this.isAllowEncodings()) {
            return matchesEncoding;
        }
        return !matchesEncoding;
    }

    public static class Encoding {
        public String name;

        public Encoding() {
        }

        public Encoding(String string) {
            this.name = string;
        }
    }

    public static class EncodingBlock {
        @PCD_serializationName(value="allow")
        @PCD_defaultValue(value="true")
        @PCD_mayBeNull
        public boolean allow = true;
        @PCD_serializationName(value="include")
        @PCD_defaultValue(value="true")
        @PCD_mayBeNull
        public boolean include = false;
        @PCD_serializationName(value="encoding")
        public List<Encoding> encodings = new ArrayList<Encoding>();
    }

    public static class MimeType {
        public String name;

        public MimeType() {
        }

        public MimeType(String string) {
            this.name = string;
        }
    }

    public static class MimeTypeBlock {
        @PCD_serializationName(value="allow")
        @PCD_defaultValue(value="true")
        @PCD_mayBeNull
        public boolean allow = true;
        @PCD_serializationName(value="include")
        @PCD_defaultValue(value="true")
        @PCD_mayBeNull
        public boolean include = false;
        @PCD_serializationName(value="mimetype")
        public List<MimeType> mimetypes = new ArrayList<MimeType>();
    }
}

