/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.process.config;

import com.ibm.team.filesystem.common.internal.process.ComponentMatchBlock;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.process.PCD_asObject;
import com.ibm.team.scm.common.internal.process.PCD_defaultValue;
import com.ibm.team.scm.common.internal.process.PCD_mayBeNull;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ProtectFileTypeAdvisorConfig {
    public static String ROOT_NODE_NAME = "config";
    @PCD_mayBeNull
    public ComponentMatchBlock compMatcher = new ComponentMatchBlock();
    public List<VersionableMatchRule> pathMatchers = new ArrayList<VersionableMatchRule>();
    @PCD_defaultValue(value="ALLOW_MATCHES")
    @PCD_asObject
    public Mode mode = Mode.ALLOW_MATCHES;

    public List<MatcherInitializationException> initMatchers() {
        ArrayList<MatcherInitializationException> exceptions = new ArrayList<MatcherInitializationException>();
        for (VersionableMatchRule rule : this.pathMatchers) {
            try {
                rule.initMatcher(this.mode);
            }
            catch (MatcherInitializationException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public static class MatcherInitializationException
    extends TeamRepositoryException {
        private static final long serialVersionUID = 7909502540457045602L;
        public final VersionableMatchRule rule;

        public MatcherInitializationException(VersionableMatchRule rule) {
            super("Bad matcher: " + rule.matchText);
            this.rule = rule;
        }
    }

    public static enum MatcherType {
        NAME_PATTERN,
        REGEX;

    }

    public static enum Mode {
        DENY_MATCHES,
        ALLOW_MATCHES;

    }

    public static class VersionableMatchRule {
        public String matchText = "";
        public MatcherType type = MatcherType.NAME_PATTERN;
        public boolean matchAll = true;
        public boolean matchAddition = false;
        public boolean matchDelete = false;
        public boolean matchModify = false;
        public boolean matchRename = false;
        public boolean matchMove = false;
        private transient Pattern regex;
        private transient StringMatcher stringMatcher;

        public VersionableMatchRule(VersionableMatchRule seed) {
            this.setValues(seed);
        }

        public VersionableMatchRule() {
        }

        public boolean matches(String name) {
            if (this.type == MatcherType.NAME_PATTERN) {
                return this.stringMatcher.match(name);
            }
            return this.regex.matcher(name).find();
        }

        public boolean isMove(int changeType, IVersionable previous, IVersionable current) {
            if (VersionableMatchRule.eq(8, changeType) && previous.getName().equals(current.getName())) {
                if (previous.getParent() == null) {
                    return current.getParent() != null;
                }
                if (current.getParent() == null) {
                    return previous.getParent() != null;
                }
                if (!current.getParent().sameItemId((IItemHandle)previous.getParent())) {
                    return true;
                }
            }
            return false;
        }

        public boolean isRename(int changeType, IVersionable previous, IVersionable current) {
            return VersionableMatchRule.eq(8, changeType) && !previous.getName().equals(current.getName());
        }

        private static boolean eq(int type, int toCheck) {
            return type == (type & toCheck);
        }

        public void initMatcher(Mode mode) throws MatcherInitializationException {
            if (this.type == MatcherType.NAME_PATTERN) {
                this.stringMatcher = new StringMatcher(this.matchText, false, false);
                return;
            }
            try {
                this.regex = Pattern.compile(this.matchText);
            }
            catch (PatternSyntaxException e) {
                throw new MatcherInitializationException(this);
            }
        }

        public boolean whiteListTestShouldFail(IVersionable previous, IVersionable current, int changeType) {
            boolean result = true;
            if (VersionableMatchRule.eq(1, changeType) && (this.matchAddition || this.matchAll)) {
                result &= this.matches(current.getName());
            }
            if (VersionableMatchRule.eq(2, changeType) && (this.matchDelete || this.matchAll)) {
                result &= this.matches(previous.getName());
            }
            if (VersionableMatchRule.eq(4, changeType) && (this.matchModify || this.matchAll)) {
                result &= this.matches(previous.getName());
            }
            if (this.isRename(changeType, previous, current)) {
                String oldName = previous.getName();
                String newName = current.getName();
                if (this.matches(oldName) && !this.matches(newName)) {
                    if (this.matchAddition || this.matchAll) {
                        result &= this.matches(current.getName());
                    }
                } else if (!this.matches(oldName) && this.matches(newName)) {
                    if (this.matchDelete || this.matchAll) {
                        result &= this.matches(previous.getName());
                    }
                } else if (this.matchRename || this.matchAll) {
                    result &= this.matches(current.getName());
                }
            }
            if (this.isMove(changeType, previous, current) && (this.matchMove || this.matchAll)) {
                result &= this.matches(current.getName());
            }
            return !result;
        }

        public boolean blackListTestShouldFail(IVersionable previous, IVersionable current, int changeType) {
            boolean result = false;
            if (VersionableMatchRule.eq(1, changeType) && (this.matchAddition || this.matchAll)) {
                result |= this.matches(current.getName());
            }
            if (VersionableMatchRule.eq(2, changeType) && (this.matchDelete || this.matchAll)) {
                result |= this.matches(previous.getName());
            }
            if (VersionableMatchRule.eq(4, changeType) && (this.matchModify || this.matchAll)) {
                result |= this.matches(previous.getName());
            }
            if (this.isRename(changeType, previous, current)) {
                String oldName = previous.getName();
                String newName = current.getName();
                if (this.matches(oldName) && !this.matches(newName)) {
                    if (this.matchDelete || this.matchAll) {
                        result |= this.matches(previous.getName());
                    }
                } else if (!this.matches(oldName) && this.matches(newName)) {
                    if (this.matchAddition || this.matchAll) {
                        result |= this.matches(current.getName());
                    }
                } else if (this.matchRename || this.matchAll) {
                    result |= this.matches(current.getName());
                }
            }
            if (this.isMove(changeType, previous, current) && (this.matchMove || this.matchAll)) {
                result |= this.matches(current.getName());
            }
            return result;
        }

        public void setValues(VersionableMatchRule seed) {
            if (seed != null) {
                this.matchText = seed.matchText;
                this.type = seed.type;
                this.matchAll = seed.matchAll;
                this.matchAddition = seed.matchAddition;
                this.matchDelete = seed.matchDelete;
                this.matchModify = seed.matchModify;
                this.matchRename = seed.matchRename;
                this.matchMove = seed.matchMove;
                this.regex = seed.regex;
                this.stringMatcher = seed.stringMatcher;
            }
        }
    }
}

