/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.process;

import com.ibm.team.filesystem.common.internal.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import com.ibm.team.scm.common.internal.process.AdvisorDetailConstants;
import com.ibm.team.scm.common.internal.process.UnifiedProcessDescriptionUtil;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DisallowIncomingChangeErrorDescription
implements AdvisorDataMarshaller.IScmAdvisorMarshallable {
    private static final String ATTR_TARGET_NAME = "target-name";
    private static final String ATTR_TARGET_UUID = "target-uuid";
    private static final String ATTR_SOURCE_NAME = "source-name";
    private static final String ATTR_SOURCE_UUID = "source-uuid";
    private static final String ATTR_REPO_UUID = "repository-uuid";
    private static final String TAG_DISALLOWED = "disallowed";
    private static final String TAG_WORKSPACE = "workspace";
    private static final String TAG_COMPONENT = "component";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_UUID = "uuid";
    private static final String ATTR_SOURCE_ISSTTREAM = "source-isStream";
    private static final String ATTR_TARGET_ISSTTREAM = "target-isStream";
    public UUID targetRepoId;
    public String sourceName;
    public UUID sourceUuid;
    public Boolean isSourceAStream;
    public List<DisallowedComponent> components = new ArrayList<DisallowedComponent>();
    public ErrorNature nature;

    public DisallowIncomingChangeErrorDescription(UUID targetRepoId, String sourceName, UUID sourceUuid, boolean isSourceAStream, ErrorNature nature) {
        this.targetRepoId = targetRepoId;
        this.sourceName = sourceName;
        this.sourceUuid = sourceUuid;
        this.isSourceAStream = isSourceAStream;
        this.nature = nature;
    }

    public DisallowIncomingChangeErrorDescription() {
    }

    public static DisallowIncomingChangeErrorDescription deserialize(String s) throws ParseException {
        Element root;
        try {
            DocumentBuilderFactory factory = XMLUtil.getSecureDocumentBuilderFactory();
            Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(s.getBytes()));
            root = doc.getDocumentElement();
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        if (!TAG_DISALLOWED.equals(root.getTagName())) {
            throw new IllegalArgumentException();
        }
        return DisallowIncomingChangeErrorDescription.loadVersion1(root);
    }

    public String serialize() throws TeamRepositoryException {
        Document doc = UnifiedProcessDescriptionUtil.createXmlDoc();
        Element disallowedTag = doc.createElement(TAG_DISALLOWED);
        doc.appendChild(disallowedTag);
        disallowedTag.setAttribute(ATTR_VERSION, "1");
        Element wsTag = doc.createElement(TAG_WORKSPACE);
        wsTag.setAttribute(ATTR_REPO_UUID, this.targetRepoId.getUuidValue());
        wsTag.setAttribute(ATTR_SOURCE_UUID, this.sourceUuid.getUuidValue());
        wsTag.setAttribute(ATTR_SOURCE_NAME, this.sourceName);
        wsTag.setAttribute(ATTR_SOURCE_ISSTTREAM, this.isSourceAStream.toString());
        disallowedTag.appendChild(wsTag);
        for (DisallowedComponent comp : this.components) {
            Element compTag = doc.createElement(TAG_COMPONENT);
            compTag.setAttribute(ATTR_UUID, comp.uuid.getUuidValue());
            compTag.setAttribute(ATTR_NAME, comp.name);
            compTag.setAttribute(ATTR_TARGET_UUID, comp.targetUuid.getUuidValue());
            compTag.setAttribute(ATTR_TARGET_NAME, comp.targetName);
            compTag.setAttribute(ATTR_TARGET_ISSTTREAM, comp.isTargetAStream.toString());
            wsTag.appendChild(compTag);
        }
        Element unifiedRoot = doc.createElement("unified");
        disallowedTag.appendChild(unifiedRoot);
        try {
            AdvisorDataMarshaller.marshallInto((AdvisorDataMarshaller.IScmAdvisorMarshallable)new AdvisorDataMarshaller.AdvisorData(this.toAml(), (AdvisorDataMarshaller.IScmAdvisorMarshallable)this), (Document)doc, (Element)unifiedRoot, (UUID)this.targetRepoId);
        }
        catch (AdvisorDataMarshaller.MarshallerException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return UnifiedProcessDescriptionUtil.serializeDoc((Document)doc);
    }

    private String toAml() throws TeamRepositoryException {
        String paraTextPlural;
        String paraTextSingular;
        Document doc = UnifiedProcessDescriptionUtil.createXmlDoc();
        Element desc = AdvisorDetailConstants.makeDescAndAppend((Document)doc);
        Element probPara = AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc);
        if (this.nature == null || this.nature == ErrorNature.INCOMING_CHANGE_SETS) {
            paraTextSingular = Messages.getString("DisallowIncomingChangeErrorDescription.SINGULAR_INCOMING_CHANGES");
            paraTextPlural = Messages.getString("DisallowIncomingChangeErrorDescription.PLURAL_INCOMING_CHANGES");
        } else {
            paraTextSingular = Messages.getString("DisallowIncomingChangeErrorDescription.SINGULAR_INCOMING_COMPONENT");
            paraTextPlural = Messages.getString("DisallowIncomingChangeErrorDescription.PLURAL_INCOMING_COMPONENT");
        }
        if (this.components == null || this.components.isEmpty()) {
            probPara.setTextContent("Missing components");
        } else {
            String streamOrWs = this.isSourceAStream != false ? Messages.getString("DisallowIncomingChangeErrorDescription.STREAM_TEXT") : Messages.getString("DisallowIncomingChangeErrorDescription.WORKSPACE_TEXT");
            Element wsLink = AdvisorDetailConstants.makeWorkspaceLink((Document)doc, (String)NLS.bind((String)Messages.getString("DisallowIncomingChangeErrorDescription.WORKSPACE_LINK_TEXT"), (Object)(String.valueOf(streamOrWs) + " \"" + this.sourceName + "\"")), (UUID)this.targetRepoId, (UUID)this.sourceUuid, (String)this.sourceName);
            if (this.components.size() == 1) {
                DisallowedComponent dc = this.components.get(0);
                Element compLink = AdvisorDetailConstants.makeComponentLink((Document)doc, (String)NLS.bind((String)Messages.getString("DisallowIncomingChangeErrorDescription.COMPONENT_LINK_TEXT"), (Object)dc.name), (UUID)this.targetRepoId, (UUID)dc.uuid, (String)dc.name, (UUID)this.sourceUuid, (String)TAG_WORKSPACE);
                String targetStreamWs = dc.isTargetAStream != false ? Messages.getString("DisallowIncomingChangeErrorDescription.STREAM_TEXT") : Messages.getString("DisallowIncomingChangeErrorDescription.WORKSPACE_TEXT");
                UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)probPara, (String)paraTextSingular, (Object[])new Object[]{wsLink, compLink, String.valueOf(targetStreamWs) + " \"" + dc.targetName + "\""});
            } else {
                String targetStreamOrWs = this.components.get((int)0).isTargetAStream != false ? Messages.getString("DisallowIncomingChangeErrorDescription.STREAM_TEXT") : Messages.getString("DisallowIncomingChangeErrorDescription.WORKSPACE_TEXT");
                UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)probPara, (String)paraTextPlural, (Object[])new Object[]{wsLink, String.valueOf(targetStreamOrWs) + " \"" + this.components.get((int)0).targetName + "\""});
                Element list = AdvisorDetailConstants.makeList((Document)doc, (AdvisorDetailConstants.ListType)AdvisorDetailConstants.ListType.BULLETS);
                desc.appendChild(list);
                for (DisallowedComponent dc : this.components) {
                    Element li = doc.createElement("item");
                    Element compLink = AdvisorDetailConstants.makeComponentLink((Document)doc, (String)dc.name, (UUID)this.targetRepoId, (UUID)dc.uuid, (String)dc.name, (UUID)this.sourceUuid, (String)TAG_WORKSPACE);
                    li.appendChild(compLink);
                    list.appendChild(li);
                }
            }
        }
        return UnifiedProcessDescriptionUtil.serializeDoc((Document)doc);
    }

    private static ArrayList<Element> findElements(NodeList nodes) {
        ArrayList<Element> toReturn = new ArrayList<Element>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node n = nodes.item(i);
            if (n instanceof Element) {
                toReturn.add((Element)n);
            }
            ++i;
        }
        return toReturn;
    }

    private static DisallowIncomingChangeErrorDescription loadVersion1(Element root) throws ParseException {
        DisallowIncomingChangeErrorDescription toReturn = null;
        for (Element wsEl : DisallowIncomingChangeErrorDescription.findElements(root.getChildNodes())) {
            if (!TAG_WORKSPACE.equals(wsEl.getTagName())) continue;
            if (toReturn != null) {
                throw new ParseException("Only one workspace allowed");
            }
            toReturn = new DisallowIncomingChangeErrorDescription(UUID.valueOf((String)wsEl.getAttribute(ATTR_REPO_UUID)), wsEl.getAttribute(ATTR_SOURCE_NAME), UUID.valueOf((String)wsEl.getAttribute(ATTR_SOURCE_UUID)), Boolean.valueOf(wsEl.getAttribute(ATTR_SOURCE_ISSTTREAM)), null);
            for (Element compEl : DisallowIncomingChangeErrorDescription.findElements(wsEl.getChildNodes())) {
                if (!TAG_COMPONENT.equals(compEl.getTagName())) continue;
                toReturn.components.add(new DisallowedComponent(compEl.getAttribute(ATTR_NAME), UUID.valueOf((String)compEl.getAttribute(ATTR_UUID)), compEl.getAttribute(ATTR_TARGET_NAME), UUID.valueOf((String)compEl.getAttribute(ATTR_TARGET_UUID)), Boolean.valueOf(compEl.getAttribute(ATTR_TARGET_ISSTTREAM))));
            }
        }
        return toReturn;
    }

    public static class DisallowedComponent
    implements AdvisorDataMarshaller.IScmAdvisorMarshallable {
        public final String name;
        public final UUID uuid;
        public final String targetName;
        public final UUID targetUuid;
        public final Boolean isTargetAStream;

        public DisallowedComponent(String name, UUID uuid, String targetName, UUID targetUuid, boolean isTargetAStream) {
            this.name = name;
            this.uuid = uuid;
            this.targetName = targetName;
            this.targetUuid = targetUuid;
            this.isTargetAStream = isTargetAStream;
        }
    }

    public static enum ErrorNature implements AdvisorDataMarshaller.IScmAdvisorMarshallable
    {
        INCOMING_CHANGE_SETS,
        MISSING_COMPONENT;

    }

    public static class ParseException
    extends Exception {
        public ParseException(Exception e) {
            super(e);
        }

        public ParseException(String error) {
            super(error);
        }
    }
}

