/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.process;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import java.util.ArrayList;

public class ComponentMatcher {
    public static final String TAG_COMPONENTS = "components";
    public static final String TAG_COMPONENT = "component";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_UUID = "uuid";
    final ArrayList<IComponentMatcher> matchers = new ArrayList();

    public ComponentMatcher(IProcessConfigurationElement config) {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = config.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement topLevel = iProcessConfigurationElementArray[n2];
            if (topLevel != null && TAG_COMPONENTS.equals(topLevel.getName())) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray2 = topLevel.getChildren();
                int n3 = iProcessConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    block8: {
                        IProcessConfigurationElement componentEntry = iProcessConfigurationElementArray2[n4];
                        if (componentEntry != null && TAG_COMPONENT.equals(componentEntry.getName())) {
                            String name;
                            String uuidStr = componentEntry.getAttribute(ATTR_UUID);
                            if (uuidStr != null) {
                                try {
                                    UUID uuid = UUID.valueOf((String)uuidStr);
                                    this.matchers.add(new ComponentIdentityMatcher(uuid));
                                    break block8;
                                }
                                catch (IllegalArgumentException uuid) {
                                    // empty catch block
                                }
                            }
                            if ((name = componentEntry.getAttribute(ATTR_NAME)) != null) {
                                this.matchers.add(new ComponentNameMatcher(name));
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public boolean matches(IComponent comp) {
        for (IComponentMatcher matcher : this.matchers) {
            if (!matcher.matches(comp)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.matchers.size();
    }

    private static class ComponentIdentityMatcher
    implements IComponentMatcher {
        private final UUID uuid;

        public ComponentIdentityMatcher(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public boolean matches(IComponent comp) {
            return comp.getItemId().equals((Object)this.uuid);
        }
    }

    private static class ComponentNameMatcher
    implements IComponentMatcher {
        private final String name;

        public ComponentNameMatcher(String name) {
            this.name = name;
        }

        @Override
        public boolean matches(IComponent comp) {
            return this.name.equals(comp.getName());
        }
    }

    private static interface IComponentMatcher {
        public boolean matches(IComponent var1);
    }
}

