/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.patch;

import com.ibm.team.filesystem.common.internal.patch.DiffParticipant;
import com.ibm.team.filesystem.common.internal.patch.ILCSInput;
import com.ibm.team.filesystem.common.internal.patch.LCS;
import com.ibm.team.filesystem.common.internal.patch.RangeDifference;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;

public abstract class StringDiffParticipant
extends DiffParticipant<List<String>> {
    public static final String UTF_8 = "UTF-8";

    @Override
    public List<String> getRange(InputStream in, String optionalCharsetName) throws IOException {
        int count;
        Charset c;
        try {
            c = Charset.forName(optionalCharsetName);
        }
        catch (IllegalArgumentException e) {
            c = Charset.forName(UTF_8);
        }
        ArrayList<String> lines = new ArrayList<String>();
        InputStreamReader r = new InputStreamReader(in, c.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        char[] buf = new char[32768];
        StringBuilder currentLine = new StringBuilder();
        while ((count = r.read(buf)) != -1) {
            int start = 0;
            int i = 0;
            while (i < count) {
                if (buf[i] == '\n') {
                    currentLine.append(buf, start, i - start + 1);
                    lines.add(currentLine.toString());
                    currentLine.setLength(0);
                    start = i + 1;
                }
                ++i;
            }
            if (start >= count) continue;
            currentLine.append(buf, start, count - start);
        }
        if (currentLine.length() != 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    @Override
    public RangeDifference[] getDifferences(final List<String> range1, final List<String> range2) {
        ILCSInput<String> input = new ILCSInput<String>(){

            @Override
            public int length1() {
                return range1.size();
            }

            @Override
            public int length2() {
                return range2.size();
            }

            @Override
            public String get1(int i) {
                return (String)range1.get(i);
            }

            @Override
            public String get2(int i) {
                return (String)range2.get(i);
            }

            @Override
            public boolean match(String e1, String e2) {
                return e1.hashCode() == e2.hashCode() && e1.equals(e2);
            }
        };
        return LCS.lcs(input).getDifferences();
    }

    @Override
    public boolean hasTrailingNL(List<String> range) {
        int size = range.size();
        if (size == 0) {
            return true;
        }
        String last = range.get(size - 1);
        return last.charAt(last.length() - 1) == '\n';
    }

    @Override
    public int numLines(List<String> range) {
        return range.size();
    }
}

