/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.patch;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HunkRange {
    private int beforeStart;
    private int beforeLength;
    private int afterStart;
    private int afterLength;

    public HunkRange(int beforeStart, int beforeLength, int afterStart, int afterLength) {
        this.beforeStart = beforeStart;
        this.beforeLength = beforeLength;
        this.afterStart = afterStart;
        this.afterLength = afterLength;
    }

    public int getBeforeStart() {
        return this.beforeStart;
    }

    public int getBeforeLength() {
        return this.beforeLength;
    }

    public int getAfterStart() {
        return this.afterStart;
    }

    public int getAfterLength() {
        return this.afterLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.afterLength;
        result = 31 * result + this.afterStart;
        result = 31 * result + this.beforeLength;
        result = 31 * result + this.beforeStart;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HunkRange other = (HunkRange)obj;
        if (this.afterLength != other.afterLength) {
            return false;
        }
        if (this.afterStart != other.afterStart) {
            return false;
        }
        if (this.beforeLength != other.beforeLength) {
            return false;
        }
        return this.beforeStart == other.beforeStart;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("@@ -");
        result.append(Integer.toString(this.beforeLength == 0 ? 0 : this.beforeStart + 1));
        result.append(',');
        result.append(Integer.toString(this.beforeLength));
        result.append(" +");
        result.append(Integer.toString(this.afterLength == 0 ? 0 : this.afterStart + 1));
        result.append(',');
        result.append(Integer.toString(this.afterLength));
        result.append(" @@");
        return result.toString();
    }

    public static HunkRange fromString(String toParse) {
        int beforeStart = 0;
        int beforeLength = 0;
        int afterStart = 0;
        int afterLength = 0;
        StringTokenizer tokenizer = new StringTokenizer(toParse, " @-,+", false);
        try {
            beforeStart = Integer.parseInt(tokenizer.nextToken());
            beforeLength = Integer.parseInt(tokenizer.nextToken());
            afterStart = Integer.parseInt(tokenizer.nextToken());
            afterLength = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new HunkRange(beforeStart, beforeLength, afterStart, afterLength);
    }
}

