/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.patch;

import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;

public class ChangeClassifier {
    private final Collection<FileChange> nonText = NewCollection.arrayList();
    private final Collection<FileChange> textChanges = NewCollection.arrayList();
    private final Collection<FileChange> folderChanges = NewCollection.arrayList();
    private final Collection<FileChange> linkChanges = NewCollection.arrayList();
    private final Collection<FileChange> propertyChanges = NewCollection.arrayList();
    private final Collection<FileChange> subcomponentChanges = NewCollection.arrayList();
    private final Collection<FileChange> externalLinkChanges = NewCollection.arrayList();

    public ChangeClassifier(Collection<FileChange> changes) {
        for (FileChange change : changes) {
            if (change.getItemId().getItemType() == IFolder.ITEM_TYPE) {
                this.folderChanges.add(change);
            } else if (change.getItemId().getItemType() == ISymbolicLink.ITEM_TYPE) {
                this.linkChanges.add(change);
            } else if (change.getInitial().isTextType() || change.getFinal().isTextType()) {
                this.textChanges.add(change);
            } else if (change.isSubcomponentChange()) {
                this.subcomponentChanges.add(change);
            } else {
                this.nonText.add(change);
            }
            if (change.isExternalLinksChange()) {
                this.externalLinkChanges.add(change);
            }
            if (!change.hasPropertyChange()) continue;
            this.propertyChanges.add(change);
        }
    }

    public Collection<FileChange> getNonText() {
        return this.nonText;
    }

    public Collection<FileChange> getTextChanges() {
        return this.textChanges;
    }

    public Collection<FileChange> getFolderChanges() {
        return this.folderChanges;
    }

    public Collection<FileChange> getLinkChanges() {
        return this.linkChanges;
    }

    public Collection<FileChange> getPropertyChanges() {
        return this.propertyChanges;
    }

    public Collection<FileChange> getSubcomponentChanges() {
        return this.subcomponentChanges;
    }

    public Collection<FileChange> getExternalLinkChanges() {
        return this.externalLinkChanges;
    }
}

