/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.patch;

import com.ibm.team.filesystem.common.internal.patch.ByteArrayLine;
import com.ibm.team.filesystem.common.internal.patch.ILCSInput;
import com.ibm.team.filesystem.common.internal.patch.LCS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ByteArrayLines {
    List<ByteArrayLine> lines = new ArrayList<ByteArrayLine>();
    boolean hasTrailingNL = true;

    public ByteArrayLines(InputStream in) throws IOException {
        if (in != null) {
            try {
                int count;
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                byte[] buf = new byte[8192];
                while ((count = in.read(buf)) != -1) {
                    int start = 0;
                    int i = 0;
                    while (i < count) {
                        if (buf[i] == 10) {
                            out.write(buf, start, i - start + 1);
                            this.lines.add(new ByteArrayLine(out.toByteArray()));
                            out.reset();
                            start = i + 1;
                        }
                        ++i;
                    }
                    if (start >= count) continue;
                    out.write(buf, start, count - start);
                }
                byte[] content = out.toByteArray();
                if (content.length != 0) {
                    this.lines.add(new ByteArrayLine(content));
                    this.hasTrailingNL = false;
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int numLines() {
        return this.lines.size();
    }

    public ByteArrayLine getLine(int line) {
        return this.lines.get(line);
    }

    public byte[] get(int line) {
        return this.lines.get((int)line).bytes;
    }

    public boolean hasTrailingNL() {
        return this.hasTrailingNL;
    }

    public LCS lcs(final ByteArrayLines other) {
        ILCSInput<ByteArrayLine> input = new ILCSInput<ByteArrayLine>(){

            @Override
            public int length1() {
                return ByteArrayLines.this.numLines();
            }

            @Override
            public int length2() {
                return other.numLines();
            }

            @Override
            public ByteArrayLine get1(int i) {
                return ByteArrayLines.this.getLine(i);
            }

            @Override
            public ByteArrayLine get2(int i) {
                return other.getLine(i);
            }

            @Override
            public boolean match(ByteArrayLine e1, ByteArrayLine e2) {
                return e1.equals(e2);
            }
        };
        return LCS.lcs(input);
    }
}

