/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;

public final class VersionablePathSegment {
    private ItemId<IFolder> parent;
    private ItemId<IVersionable> item;
    private String name;
    private static VersionablePathSegment root;

    private VersionablePathSegment(ItemId<IFolder> parent, ItemId<IVersionable> item, String filename) {
        if (parent.getItemType() != IFolder.ITEM_TYPE) {
            throw new IllegalArgumentException();
        }
        Assert.isNotNull(item);
        this.parent = parent;
        this.item = item;
        this.name = filename;
    }

    public static VersionablePathSegment pathFor(IVersionable folder) {
        return VersionablePathSegment.create(ItemUtil.getParent(folder), (ItemId<IVersionable>)ItemId.forItem((IItem)folder), folder.getName());
    }

    public static VersionablePathSegment create(ItemId<IFolder> parent, ItemId<IVersionable> item, String name) {
        return new VersionablePathSegment(parent, item, name);
    }

    @Deprecated
    public static VersionablePathSegment create(ItemId<IFolder> parent, String name) {
        return new VersionablePathSegment(VersionablePathSegment.asFolderItem(parent), (ItemId<IVersionable>)ItemId.getNullItem((IItemType)ItemId.getNullItemType()), name);
    }

    private static ItemId<IFolder> asFolderItem(ItemId<IFolder> itemId) {
        if (itemId.getItemType() == IFolder.ITEM_TYPE) {
            return itemId;
        }
        return new ItemId(IFolder.ITEM_TYPE, itemId.getItemUUID());
    }

    public static VersionablePathSegment emptyPath() {
        if (root == null) {
            root = VersionablePathSegment.create((ItemId<IFolder>)ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE), (ItemId<IVersionable>)ItemId.getNullItem((IItemType)ItemId.getNullItemType()), "");
        }
        return root;
    }

    public boolean isResolved() {
        return this.parent.isNull();
    }

    public boolean isEmpty() {
        return this.parent.isNull() && this.name.equals("");
    }

    public ItemId<IFolder> getParent() {
        return this.parent;
    }

    public ItemId<IVersionable> getItem() {
        return this.item;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionablePathSegment other = (VersionablePathSegment)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getFileExtension() {
        return new Path(this.name).getFileExtension();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return String.valueOf(this.parent.getItemUUID().getUuidValue()) + "/" + this.name;
    }
}

