/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.internal.repository.rcp.streams.ByteArrayInputStreamProvider;
import com.ibm.team.internal.repository.rcp.streams.EmptyInputStreamProvider;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class FileState {
    public static final String CHARACTER_ENCODING_UNKNOWN = "";
    public static final String FOLDER_TYPE = "inode/directory";
    public static final String SYMBOLICLINK_TYPE = "inode/symboliclink";
    public static final String LINE_DELIMITER_PROPERTY_KEY = " line_delimiter";
    public static final String CONTENT_TYPE_PROPERTY_KEY = " content_type";
    public static final String EXECUTABLE_PROPERTY_KEY = " executable_bit";
    public static final String VERSION_ID_UNKNOWN = "";
    public static final VersionIdType VERSION_IDS_UNKNOWN = new VersionIdType("", "");
    private final Date timestamp;
    private final IInputStreamProvider contents;
    private final VersionablePathSegment path;
    private final String characterEncoding;
    private final boolean isExecutable;
    private final String mimeType;
    private final boolean isTextType;
    private final FileLineDelimiter lineDelimiter;
    private final boolean isDeleted;
    private final StateId theState;
    private final String target;
    private final boolean directoryLink;
    private final Map<String, String> properties;
    private final ExternalLinks externalLinks;
    private final VersionIdType versionIds;

    public static FileState getDeletedState(IItemType type, VersionablePathSegment path) {
        if (path == null) {
            path = VersionablePathSegment.emptyPath();
        }
        String contentType = FileState.getContentType(type);
        return new FileState(path, new Date(0L), (IInputStreamProvider)EmptyInputStreamProvider.getDefault(), false, contentType, FileLineDelimiter.LINE_DELIMITER_NONE, false, "", true, new HashMap<String, String>(), StateId.getDeletedState((ItemId)ItemId.getNullItem((IItemType)type)), null, false, ExternalLinks.create(), VERSION_IDS_UNKNOWN);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, IInputStreamProvider contents, boolean isExecutable, String mimeType, FileLineDelimiter delimiter, boolean isTextType, String characterEncoding, boolean isDeleted, Map<String, String> properties, StateId stateId, ExternalLinks links, VersionIdType versionIds) {
        return new FileState(path, timestamp, contents, isExecutable, mimeType, delimiter, isTextType, characterEncoding, isDeleted, properties, stateId, null, false, links, versionIds);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, boolean isDeleted, Map<String, String> properties, StateId stateId, String target, boolean directoryLink) {
        ByteArrayInputStreamProvider streamProvider = target == null ? new ByteArrayInputStreamProvider(new byte[0]) : new ByteArrayInputStreamProvider(target.getBytes());
        return FileState.create(path, timestamp, (IInputStreamProvider)streamProvider, isDeleted, properties, stateId, target, directoryLink);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, IInputStreamProvider streamProvider, boolean isDeleted, Map<String, String> properties, StateId stateId, String target, boolean directoryLink) {
        String contentType = FileState.getContentType(stateId.getItemType());
        String encoding = System.getProperty("file.encoding");
        if (encoding == null) {
            encoding = "";
        }
        return new FileState(path, timestamp, streamProvider, false, contentType, FileLineDelimiter.LINE_DELIMITER_NONE, false, encoding, isDeleted, properties, stateId, target, directoryLink, ExternalLinks.create(), VERSION_IDS_UNKNOWN);
    }

    public static FileState create(VersionablePathSegment path, Date timestamp, boolean isDeleted, Map<String, String> properties, StateId stateId) {
        String contentType = FileState.getContentType(stateId.getItemType());
        return new FileState(path, timestamp, (IInputStreamProvider)EmptyInputStreamProvider.getDefault(), false, contentType, FileLineDelimiter.LINE_DELIMITER_NONE, false, "", isDeleted, properties, stateId, null, false, ExternalLinks.create(), VERSION_IDS_UNKNOWN);
    }

    private FileState(VersionablePathSegment path, Date timestamp, IInputStreamProvider contents, boolean isExecutable, String mimeType, FileLineDelimiter delimiter, boolean isTextType, String characterEncoding, boolean isDeleted, Map<String, String> properties, StateId stateId, String target, boolean directoryLink, ExternalLinks links, VersionIdType versionIds) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        this.theState = stateId;
        this.timestamp = timestamp;
        this.contents = contents;
        this.path = path;
        this.isExecutable = isExecutable;
        this.mimeType = mimeType;
        this.lineDelimiter = delimiter;
        this.isTextType = isTextType || FileState.isTextType(mimeType);
        this.characterEncoding = characterEncoding == null ? "" : characterEncoding;
        this.isDeleted = isDeleted;
        this.target = target;
        this.directoryLink = directoryLink;
        if (properties != null) {
            this.properties = new HashMap<String, String>();
            this.properties.putAll(properties);
        } else {
            this.properties = null;
        }
        this.externalLinks = ExternalLinks.create((ExternalLinks)links);
        this.versionIds = versionIds;
    }

    public static boolean isTextType(String mimeType) {
        return mimeType != null && mimeType.toLowerCase(Locale.ENGLISH).startsWith("text");
    }

    private static String getContentType(IItemType type) {
        String contentType = null;
        contentType = type == IFolder.ITEM_TYPE ? FOLDER_TYPE : (type == ISymbolicLink.ITEM_TYPE ? SYMBOLICLINK_TYPE : "application/unknown");
        return contentType;
    }

    public boolean isFolder() {
        return this.theState.getItemType() == IFolder.ITEM_TYPE;
    }

    public boolean isExectuable() {
        return this.isExecutable;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public FileLineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public boolean isTextType() {
        return this.isTextType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public VersionablePathSegment getPath() {
        return this.path;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public IInputStreamProvider getContents() {
        return this.contents;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public String toString() {
        String result = "FileState(";
        if (this.isDeleted) {
            return String.valueOf(result) + "deleted)";
        }
        return String.valueOf(result) + "FileState(contents " + this.contents.toString() + ", path= " + this.path + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.characterEncoding == null ? 0 : this.characterEncoding.hashCode());
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        result = 31 * result + (this.isDeleted ? 1231 : 1237);
        result = 31 * result + (this.isExecutable ? 1231 : 1237);
        result = 31 * result + (this.isTextType ? 1231 : 1237);
        result = 31 * result + (this.lineDelimiter == null ? 0 : this.lineDelimiter.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.theState == null ? 0 : this.theState.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileState other = (FileState)obj;
        if (this.characterEncoding == null ? other.characterEncoding != null : !this.characterEncoding.equals(other.characterEncoding)) {
            return false;
        }
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        if (this.isDeleted != other.isDeleted) {
            return false;
        }
        if (this.isExecutable != other.isExecutable) {
            return false;
        }
        if (this.isTextType != other.isTextType) {
            return false;
        }
        if (this.lineDelimiter == null ? other.lineDelimiter != null : !this.lineDelimiter.equals((Object)other.lineDelimiter)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.theState == null ? other.theState != null : !this.theState.equals((Object)other.theState)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public StateId getStateId() {
        return this.theState;
    }

    public String getTarget() {
        return this.target != null ? this.target : "";
    }

    public boolean isDirectoryLink() {
        return this.directoryLink;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public ExternalLinks getExternalLinks() {
        return ExternalLinks.create((ExternalLinks)this.externalLinks);
    }

    public boolean isValidStateId() {
        if (this.getStateId().getItemId().isNull()) {
            return false;
        }
        return this.isDeleted || !this.getStateId().isDeleted();
    }

    public VersionIdType getVersionIds() {
        if (this.versionIds != null) {
            return this.versionIds;
        }
        return VERSION_IDS_UNKNOWN;
    }

    public String getLongVersionId() {
        if (this.versionIds != null) {
            return this.versionIds.longVersionId;
        }
        return "";
    }

    public String getShortVersionId() {
        if (this.versionIds != null) {
            return this.versionIds.shortVersionId;
        }
        return "";
    }

    public static VersionIdType createVersionIds(String shortVersionId, String longVersionId) {
        return new VersionIdType(shortVersionId, longVersionId);
    }

    public static final class VersionIdType {
        private String shortVersionId;
        private String longVersionId;

        private VersionIdType(String shortVersionId, String longVersionId) {
            this.shortVersionId = shortVersionId;
            this.longVersionId = longVersionId;
        }
    }
}

