/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.StateNode;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ConfigurationChange {
    private Map<FileState, StateNode> stateGraph = new LinkedHashMap<FileState, StateNode>();
    private Set<FileState> rootNodes = new LinkedHashSet<FileState>();
    private Collection<FileChange> cachedChanges = null;

    public ConfigurationChange() {
    }

    public ConfigurationChange(Collection<FileChange> changes) {
        for (FileChange next : changes) {
            this.addChange(next, true);
        }
    }

    public void addChange(FileChange toAdd) {
        this.addChange(toAdd, true);
    }

    public void addMerge(FileChange toAdd) {
        this.addChange(toAdd, false);
    }

    private void addChange(FileChange toAdd, boolean activeChange) {
        this.cachedChanges = null;
        StateNode beforeNode = this.getNode(toAdd.getInitial());
        beforeNode.addOutgoing(toAdd);
        StateNode afterNode = this.getNode(toAdd.getFinal());
        if (activeChange) {
            afterNode.addActiveIncoming(toAdd);
        } else {
            afterNode.addMerge(toAdd);
        }
        if (beforeNode.getOutgoing().size() == 1 && !toAdd.getInitial().isDeleted() && beforeNode != afterNode) {
            this.rootNodes.remove(toAdd.getInitial());
        }
    }

    public Map<SiloedItemId<IVersionable>, List<FileChange>> getChangesByItem() {
        HashMap<SiloedItemId<IVersionable>, List<FileChange>> changesByItem = new HashMap<SiloedItemId<IVersionable>, List<FileChange>>();
        for (FileChange next : this.getChanges()) {
            CollectionUtil.addToMapOfLists(changesByItem, next.getSiloedItemId(), (Object)next);
        }
        return changesByItem;
    }

    private StateNode getNode(FileState key) {
        StateNode result = this.stateGraph.get(key);
        if (result == null) {
            result = new StateNode(key);
            this.stateGraph.put(key, result);
            this.rootNodes.add(key);
        }
        return result;
    }

    public Collection<FileChange> getChanges() {
        if (this.cachedChanges == null) {
            this.cachedChanges = this.computeChanges();
        }
        return this.cachedChanges;
    }

    private Collection<FileChange> computeChanges() {
        LinkedHashSet<FileChange> result = new LinkedHashSet<FileChange>();
        LinkedHashSet<FileState> visited = new LinkedHashSet<FileState>();
        for (FileState next : this.rootNodes) {
            StateNode nextNode = this.stateGraph.get(next);
            visited.add(next);
            LinkedList<FileChange> changes = new LinkedList<FileChange>();
            changes.addAll(nextNode.getActiveIncoming());
            LinkedHashSet<FileState> visitedThisRoot = new LinkedHashSet<FileState>();
            visitedThisRoot.add(next);
            while (!changes.isEmpty()) {
                FileChange nextChange = (FileChange)changes.removeFirst();
                FileState beforeState = nextChange.getFinal();
                FileState afterState = nextChange.getFinal();
                FileChange iter = nextChange;
                boolean redundantChain = false;
                SiloedItemId<IVersionable> item = nextChange.getSiloedItemId();
                while (iter != null) {
                    beforeState = iter.getInitial();
                    boolean bl = redundantChain = !visitedThisRoot.add(beforeState);
                    if (redundantChain || !visited.add(beforeState) || beforeState.isDeleted()) break;
                    iter = null;
                    List<FileChange> predecessors = this.stateGraph.get(beforeState).getActiveIncoming();
                    for (FileChange nextPredecessor : predecessors) {
                        if (iter == null && nextPredecessor.getSiloedItemId().equals(item)) {
                            iter = nextPredecessor;
                            continue;
                        }
                        changes.add(nextPredecessor);
                    }
                }
                if (redundantChain && !beforeState.equals(afterState)) continue;
                FileChange toAdd = new FileChange(beforeState, afterState, item);
                result.add(toAdd);
            }
        }
        return result;
    }

    public List<FileChange> getChanges(SiloedItemId<IVersionable> versionable) {
        ArrayList<FileChange> result = new ArrayList<FileChange>();
        for (FileChange next : this.getChanges()) {
            if (!next.getSiloedItemId().equals(versionable)) continue;
            result.add(next);
        }
        return result;
    }

    public ConfigurationChange reverse() {
        ConfigurationChange result = new ConfigurationChange();
        for (StateNode next : this.stateGraph.values()) {
            for (FileChange nextMerge : next.getMerges()) {
                result.addMerge(nextMerge.reverse());
            }
            for (FileChange nextChange : next.getActiveIncoming()) {
                result.addChange(nextChange.reverse());
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.getChanges().isEmpty();
    }

    public ConfigurationChange merge(ConfigurationChange individualChanges) {
        ArrayList changes = NewCollection.arrayList();
        changes.add(this);
        changes.add(individualChanges);
        return ConfigurationChange.merge(changes);
    }

    public static ConfigurationChange merge(Collection<ConfigurationChange> toMerge) {
        ConfigurationChange result = new ConfigurationChange();
        for (ConfigurationChange nextConfig : toMerge) {
            for (StateNode next : nextConfig.stateGraph.values()) {
                for (FileChange nextChange : next.getActiveIncoming()) {
                    result.addChange(nextChange);
                }
                for (FileChange nextMerge : next.getMerges()) {
                    result.addMerge(nextMerge);
                }
            }
        }
        return result;
    }

    public Map<FileState, StateNode> getStateGraph() {
        return this.stateGraph;
    }
}

