/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.internal.Messages;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public final class ChangeDescription {
    private String comment;
    private Collection<ItemId<IAuditable>> workItems;
    private ItemId<IComponent> component;
    private Date date;
    private Collection<ItemId<IChangeSet>> changeSets;
    private Collection<ItemId<IContributor>> authors;
    private ItemId<IChangeSet> portSource;
    private ItemId<IChangeSet> originalPortSource;

    public ChangeDescription() {
        this("", Collections.EMPTY_LIST, (ItemId<IComponent>)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE), Collections.EMPTY_LIST, new Date(), Collections.emptyList());
    }

    public ChangeDescription(String comment, Collection<ItemId<IAuditable>> workItems, ItemId<IComponent> component, Collection<ItemId<IChangeSet>> changeSets, Date date) {
        this(comment, workItems, component, changeSets, date, Collections.emptyList());
    }

    public ChangeDescription(String comment, Collection<ItemId<IAuditable>> workItems, ItemId<IComponent> component, Collection<ItemId<IChangeSet>> changeSets, Date date, Collection<ItemId<IContributor>> authors) {
        this.comment = comment;
        this.workItems = new HashSet<ItemId<IAuditable>>();
        this.workItems.addAll(workItems);
        this.component = component;
        this.date = date;
        this.changeSets = new HashSet<ItemId<IChangeSet>>();
        this.changeSets.addAll(changeSets);
        this.authors = authors;
    }

    public ChangeDescription withComment(String newComment) {
        ChangeDescription result = this.copy();
        result.comment = newComment;
        return result;
    }

    public ChangeDescription copy() {
        ChangeDescription changeDescription = new ChangeDescription(this.comment, this.workItems, this.component, this.changeSets, this.date, this.authors);
        if (this.portSource != null) {
            changeDescription.setPortData(this.portSource, this.originalPortSource);
        }
        return changeDescription;
    }

    public String getComment() {
        return this.comment;
    }

    public Collection<ItemId<IAuditable>> getWorkItems() {
        return this.workItems;
    }

    public ItemId<IComponent> getComponent() {
        return this.component;
    }

    public Date getDate() {
        return this.date;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.changeSets == null ? 0 : this.changeSets.hashCode());
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.workItems == null ? 0 : this.workItems.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeDescription other = (ChangeDescription)obj;
        if (this.changeSets == null ? other.changeSets != null : !this.changeSets.equals(other.changeSets)) {
            return false;
        }
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        return !(this.workItems == null ? other.workItems != null : !this.workItems.equals(other.workItems));
    }

    public ChangeDescription reverse() {
        String text = this.getComment();
        String newText = text.equals("") ? NLS.bind((String)Messages.getString("ChangeDescription.0"), (Object)this.getDate(), (Object[])new Object[0]) : NLS.bind((String)Messages.getString("ChangeDescription.1"), (Object)text, (Object[])new Object[0]);
        return new ChangeDescription(newText, this.getWorkItems(), this.getComponent(), Collections.EMPTY_LIST, this.getDate(), this.authors);
    }

    public Collection<ItemId<IChangeSet>> getChangeSets() {
        return this.changeSets;
    }

    public ChangeDescription merge(ChangeDescription description) {
        Date resultingDate = this.getDate().compareTo(description.getDate()) > 0 ? this.getDate() : description.getDate();
        String comment = this.getComment().equals("") ? description.getComment() : this.getComment();
        ItemId component = this.component.equals(description.getComponent()) ? this.component : ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        HashSet changeSets = NewCollection.hashSet();
        changeSets.addAll(this.getChangeSets());
        changeSets.addAll(description.getChangeSets());
        HashSet workItems = NewCollection.hashSet();
        workItems.addAll(this.getWorkItems());
        workItems.addAll(description.getWorkItems());
        ArrayList newAuthors = NewCollection.arrayList();
        newAuthors.addAll(this.authors);
        newAuthors.addAll(description.authors);
        return new ChangeDescription(comment, workItems, (ItemId<IComponent>)component, changeSets, resultingDate, newAuthors);
    }

    public static ChangeDescription merge(List<ChangeDescription> orderedDescriptions) {
        ChangeDescription result = new ChangeDescription();
        for (ChangeDescription next : orderedDescriptions) {
            result = result.merge(next);
        }
        return result;
    }

    public Collection<ItemId<IContributor>> getAuthors() {
        return this.authors;
    }

    public void setPortData(ItemId<IChangeSet> portSource, ItemId<IChangeSet> originalPortSource) {
        this.portSource = portSource;
        this.originalPortSource = originalPortSource;
    }

    public ItemId<IChangeSet> getPortSource() {
        return this.portSource;
    }

    public ItemId<IChangeSet> getOriginalPortSource() {
        return this.originalPortSource;
    }
}

