/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsJazzIgnoreRule;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;

public final class ParmsShareRequest
implements IParameterWrapper {
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String componentName;
    public String changeSetItemId;
    public String parentFolderItemId;
    public String newFolderPath;
    public String sandboxPath;
    public String[] itemsToShare;
    public ParmsJazzIgnoreRule[] ignoreRules;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        if (this.componentItemId == null && (this.componentName == null || this.componentName.trim().length() == 0)) {
            throw new IllegalArgumentException(NLS.bind((String)"Either {0} or {1} must be supplied for {2} in {3} request", (Object)"componentItemId", (Object[])new Object[]{"componentName", ParmValidation.getParameterName(parameterName), requestName}));
        }
        if (this.componentItemId != null && this.componentName != null && this.componentName.trim().length() != 0) {
            throw new IllegalArgumentException(NLS.bind((String)"Only one of {0} and {1} may be supplied for {2} in {3} request,", (Object)"componentItemId", (Object[])new Object[]{"componentName", ParmValidation.getParameterName(parameterName), requestName}));
        }
        if (this.componentItemId == null && this.parentFolderItemId != null) {
            throw new IllegalArgumentException(NLS.bind((String)"When a component is being created, {0} can not be specified in {1} request", (Object)ParmValidation.getParameterName(parameterName, "parentFolderItemId"), (Object[])new Object[]{requestName}));
        }
        if (this.componentItemId != null) {
            ParmValidation.requiredValue(this.parentFolderItemId, requestName, parameterName, "parentFolderItemId");
        }
        if (this.newFolderPath != null && this.newFolderPath.trim().length() != 0 && !this.newFolderPath.startsWith("/")) {
            throw new IllegalArgumentException(NLS.bind((String)"Path {0} in must have a leading slash in {1} request", (Object)this.newFolderPath, (Object[])new Object[]{requestName}));
        }
        ParmValidation.requiredValue(this.sandboxPath, requestName, "sandboxPath");
        this.sandboxPath = ParmValidation.validCanonicalPath(this.sandboxPath, requestName, parameterName, "sandboxPath");
        ParmValidation.requiredArray(this.itemsToShare, requestName, "itemsToShare");
        if (this.itemsToShare == null || this.itemsToShare.length < 1) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_0, (Object)ParmValidation.getParameterName(parameterName, "itemsToShare"), (Object[])new Object[]{requestName}));
        }
        this.itemsToShare = ParmValidation.validRelativeCanonicalPaths(this.sandboxPath, this.itemsToShare, requestName, parameterName, "itemsToShare");
    }

    public IComponentHandle getComponentHandle() throws TeamRepositoryException {
        if (this.componentItemId == null || this.componentItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }

    public IChangeSetHandle getChangeSetHandle() throws TeamRepositoryException {
        if (this.changeSetItemId == null || this.changeSetItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.changeSetItemId), null);
    }

    public IFolderHandle getParentFolderHandle() throws TeamRepositoryException {
        if (this.parentFolderItemId == null || this.parentFolderItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.parentFolderItemId), null);
    }
}

