/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;

public class ParmsRenameVersionableRequest
implements IParameterWrapper {
    public ParmsWorkspace workspace;
    public String componentItemId;
    public ParmsVersionable[] versionablesToRename;
    public String[] newNames;
    public String changeSetComment;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        ParmValidation.requiredValue(this.componentItemId, requestName, parameterName, "componentItemId");
        ParmValidation.requiredValue(this.versionablesToRename, requestName, parameterName, "versionablesToRename");
        ParmValidation.requiredValue(this.newNames, requestName, parameterName, "newNames");
        if (this.versionablesToRename.length != this.newNames.length) {
            throw new IllegalArgumentException(NLS.bind((String)"The {0} and {1} must be in 1-1 correspondence for {2} request", (Object)ParmValidation.getParameterName(parameterName, "versionablesToRename"), (Object[])new Object[]{ParmValidation.getParameterName(parameterName, "newNames"), requestName}));
        }
        int i = 0;
        while (i < this.versionablesToRename.length) {
            this.versionablesToRename[i].validate(requestName, parameterName, "versionablesToRename", i);
            ParmValidation.requiredValue(this.newNames[i], requestName, parameterName, "newNames", i);
            ++i;
        }
    }

    public IVersionableHandle[] getVersionableHandles() throws TeamRepositoryException {
        IVersionableHandle[] handles = new IVersionableHandle[this.versionablesToRename.length];
        int i = 0;
        while (i < this.versionablesToRename.length) {
            handles[i] = this.versionablesToRename[i].getVersionableHandle();
            ++i;
        }
        return handles;
    }

    public IComponentHandle getComponentHandle() throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
    }
}

