/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ParmsLoadRule
implements IParameterWrapper {
    public String sandboxPath;
    public String subFolder;
    public ParmsWorkspace workspace;
    public String componentItemId;
    public String loadRuleFileItemId;
    public String loadRuleFileContents;
    public String loadRuleFile;
    public String[] componentItemIdFilter;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.sandboxPath, requestName, parameterName, "sandboxPath");
        this.sandboxPath = ParmValidation.validCanonicalPath(this.sandboxPath, requestName, parameterName, "sandboxPath");
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        if ((this.loadRuleFileItemId == null || this.loadRuleFileItemId.length() == 0) && this.componentItemId != null && this.componentItemId.length() != 0 || this.loadRuleFileItemId != null && this.loadRuleFileItemId.length() != 0 && (this.componentItemId == null || this.componentItemId.length() == 0)) {
            throw new IllegalArgumentException(NLS.bind((String)"both {0} and {1} must be supplied to identify the rule in the configuration", (Object)ParmValidation.getParameterName(parameterName, "loadRuleFileItemId"), (Object[])new Object[]{ParmValidation.getParameterName(parameterName, "componentItemId")}));
        }
        if (!(this.loadRuleFileContents != null && this.loadRuleFileContents.length() != 0 || this.loadRuleFileItemId != null && this.loadRuleFileItemId.length() != 0 || this.loadRuleFile != null && this.loadRuleFile.length() != 0)) {
            throw new IllegalArgumentException(NLS.bind((String)"Either {0} or {1} or {2} must be supplied for {3} in {4} operation request", (Object)"loadRuleFileContents", (Object[])new Object[]{"loadRuleFileItemId", "loadRuleFile", ParmValidation.getParameterName(parameterName), requestName}));
        }
        if (this.loadRuleFileContents != null && this.loadRuleFileContents.length() != 0) {
            ParmValidation.requiredNull(this.loadRuleFileItemId, requestName, parameterName, "loadRuleFileItemId");
            ParmValidation.requiredNull(this.componentItemId, requestName, parameterName, "componentItemId");
            ParmValidation.requiredNull(this.loadRuleFile, requestName, parameterName, "loadRuleFile");
        } else if (this.loadRuleFile != null && this.loadRuleFile.length() != 0) {
            ParmValidation.requiredNull(this.loadRuleFileItemId, requestName, parameterName, "loadRuleFileItemId");
            ParmValidation.requiredNull(this.componentItemId, requestName, parameterName, "componentItemId");
            ParmValidation.requiredNull(this.loadRuleFileContents, requestName, parameterName, "loadRuleFileContents");
        } else if (this.loadRuleFileItemId != null && this.loadRuleFileItemId.length() != 0) {
            ParmValidation.requiredNull(this.loadRuleFileContents, requestName, parameterName, "loadRuleFileContents");
            ParmValidation.requiredNull(this.loadRuleFile, requestName, parameterName, "loadRuleFile");
        }
        if (this.componentItemIdFilter != null) {
            ParmValidation.requiredArray(this.componentItemIdFilter, requestName, parameterName, "componentItemIdFilter");
        }
    }

    public IComponentHandle getComponentHandle() throws TeamRepositoryException {
        if (this.componentItemId != null) {
            ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
            return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.componentItemId), null);
        }
        return null;
    }

    public IFileItemHandle getLoadRuleFileItemHandle() throws TeamRepositoryException {
        if (this.loadRuleFileItemId == null || this.loadRuleFileItemId.trim().length() == 0) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        return (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.loadRuleFileItemId), null);
    }

    public List<IComponentHandle> getComponentFilter() throws TeamRepositoryException {
        if (this.componentItemIdFilter == null || this.componentItemIdFilter.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.workspace.repositoryUrl);
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>(this.componentItemIdFilter.length);
        String[] stringArray = this.componentItemIdFilter;
        int n = this.componentItemIdFilter.length;
        int n2 = 0;
        while (n2 < n) {
            String componentItemId = stringArray[n2];
            result.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)componentItemId), null));
            ++n2;
        }
        return result;
    }
}

