/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;

public class ParmsHistoryReference
implements IValidatingParameterWrapper {
    public String repositoryUrl;
    public String workspaceId;
    public String componentId;
    public long state = -1L;
    public String snapshotId;

    public ParmsHistoryReference() {
    }

    public ParmsHistoryReference(String repositoryUrl, WorkspaceComponentState wcs) {
        this.repositoryUrl = repositoryUrl;
        this.workspaceId = wcs.getWorkspace().getItemId().getUuidValue();
        this.componentId = wcs.getComponent().getItemId().getUuidValue();
        this.state = wcs.getState();
    }

    public ParmsHistoryReference(String repositoryUrl, IBaselineSetHandle snapshot) {
        this.repositoryUrl = repositoryUrl;
        this.snapshotId = snapshot.getItemId().getUuidValue();
    }

    public ParmsHistoryReference(String repositoryUrl, IWorkspaceHandle workspace) {
        this.repositoryUrl = repositoryUrl;
        this.workspaceId = workspace.getItemId().getUuidValue();
    }

    @Override
    public void validate(String requestName, Object ... path) {
        ParmValidation.requiredValue(this.repositoryUrl, requestName, "repositoryUrl");
        if (this.snapshotId != null) {
            ParmValidation.requiredValue(this.snapshotId, requestName, "snapshotId");
            ParmValidation.requiredNull(this.workspaceId, requestName, "workspaceId");
            ParmValidation.requiredNull(this.componentId, requestName, "componentId");
            return;
        }
        if (this.componentId != null) {
            ParmValidation.requiredValue(this.workspaceId, requestName, "workspaceId");
            ParmValidation.requiredValue(this.state, requestName, "state");
            if (this.state < 0L) {
                throw new IllegalArgumentException(NLS.bind((String)"state must be 0 or more for request {1}", (Object)requestName, (Object[])new Object[0]));
            }
        }
        ParmValidation.requiredValue(this.workspaceId, requestName, "workspaceId");
    }
}

