/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.DelegatingFileContentMerger;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import org.eclipse.osgi.util.NLS;

public class ParmsExternalTool
implements IValidatingParameterWrapper {
    private static final String ALWAYS = "always";
    private static final String NEVER = "never";
    private static final String INCLUSIVE = "inclusive";
    private static final String EXCLUSIVE = "exclusive";
    public String externalTool;
    public String policy;
    public String filePatterns;

    @Override
    public void validate(String requestName, Object ... path) {
        ParmValidation.requiredNonNull(this.externalTool, requestName, "externalTool");
        ParmValidation.requiredNonNull(this.policy, requestName, "policy");
        if (!(ALWAYS.equalsIgnoreCase(this.policy) || NEVER.equalsIgnoreCase(this.policy) || INCLUSIVE.equalsIgnoreCase(this.policy) || EXCLUSIVE.equalsIgnoreCase(this.policy))) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_11, (Object)this.policy));
        }
    }

    public boolean matches(String filename) {
        if (ALWAYS.equalsIgnoreCase(this.policy)) {
            return true;
        }
        if (NEVER.equalsIgnoreCase(this.policy)) {
            return false;
        }
        return DelegatingFileContentMerger.filenameMatches(this.filePatterns, filename, INCLUSIVE.equalsIgnoreCase(this.policy));
    }
}

